/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.conversion;

import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.BaseMetadataXMLReader;
import oracle.olapi.metadata.BaseMetadataXMLReaderState;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.conversion.LegacyXMLObject;
import oracle.olapi.metadata.conversion.LegacyXMLTags;
import oracle.olapi.metadata.conversion.MetadataLegacyXMLReader;
import oracle.olapi.xml.TagHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

final class MetadataLegacyXMLReaderState
extends BaseMetadataXMLReaderState {
    private LegacyXMLObject m_CurrentLegacyXMLObject = null;

    public MetadataLegacyXMLReaderState() {
    }

    private MetadataLegacyXMLReaderState(XMLTag xMLTag) {
        this.setPropertyTag(xMLTag);
    }

    private LegacyXMLObject createMetadataObject(XMLTag xMLTag, BaseMetadataXMLReader baseMetadataXMLReader) {
        Class clazz = xMLTag.getObjectClass();
        BaseMetadataProvider baseMetadataProvider = baseMetadataXMLReader.getMetadataProvider();
        LegacyXMLObject legacyXMLObject = (LegacyXMLObject)xMLTag.getFactory().createMetadataObjectFromClass(clazz, baseMetadataProvider);
        baseMetadataXMLReader.addParsedObject(legacyXMLObject, true);
        return legacyXMLObject;
    }

    private void initializeAttributes(Attributes attributes, BaseMetadataXMLReader baseMetadataXMLReader) throws SAXException {
        String string = baseMetadataXMLReader.getXMLFormat().getVersion();
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String string2 = attributes.getLocalName(i);
            String string3 = attributes.getValue(i);
            XMLTag xMLTag = this.getCurrentObject().getPropertyXMLTag(string2, string);
            if (xMLTag == null) {
                String[] stringArray = new String[]{string2, string3, null};
                baseMetadataXMLReader.reportError("InvalidXMLAttr", stringArray, false);
                continue;
            }
            string3 = baseMetadataXMLReader.getAttributeValue(attributes, xMLTag);
            baseMetadataXMLReader.initializeProperty(this.getCurrentObject(), xMLTag, string3, baseMetadataXMLReader.getDefaultPropertyAction());
        }
    }

    private LegacyXMLObject getCurrentObject() {
        return this.m_CurrentLegacyXMLObject;
    }

    private void setCurrentObject(LegacyXMLObject legacyXMLObject) {
        this.m_CurrentLegacyXMLObject = legacyXMLObject;
    }

    private LegacyXMLObject getContainerObject(boolean bl) {
        if (bl && null != this.getCurrentObject()) {
            return this.getCurrentObject();
        }
        MetadataLegacyXMLReaderState metadataLegacyXMLReaderState = this.getParentState();
        if (null != metadataLegacyXMLReaderState) {
            return metadataLegacyXMLReaderState.getContainerObject(true);
        }
        return null;
    }

    private XMLTag getContainerPropertyTag() {
        if (null != this.getParentState()) {
            if (this.getParentState().getPropertyTag().isChoiceTag()) {
                return this.getParentState().getPropertyTag();
            }
            return this.getPropertyTag();
        }
        return null;
    }

    @Override
    protected void enter(String string, Attributes attributes, TagHandler tagHandler) throws SAXException {
        MetadataLegacyXMLReader metadataLegacyXMLReader = (MetadataLegacyXMLReader)tagHandler;
        if (10 == this.getPropertyTag().getXMLType() || 7 == this.getPropertyTag().getXMLType()) {
            return;
        }
        if (9 == this.getPropertyTag().getXMLType() || 6 == this.getPropertyTag().getXMLType()) {
            LegacyXMLObject legacyXMLObject = this.createMetadataObject(this.getPropertyTag(), metadataLegacyXMLReader);
            this.setCurrentObject(legacyXMLObject);
            LegacyXMLObject legacyXMLObject2 = this.getContainerObject(false);
            if (null != legacyXMLObject2) {
                metadataLegacyXMLReader.initializeProperty(legacyXMLObject2, this.getContainerPropertyTag(), legacyXMLObject, metadataLegacyXMLReader.getDefaultPropertyAction());
                legacyXMLObject.initializeContainedByProperty(legacyXMLObject2, metadataLegacyXMLReader.getDefaultPropertyAction());
            }
            this.initializeAttributes(attributes, metadataLegacyXMLReader);
            legacyXMLObject.finishObjectCreation(metadataLegacyXMLReader);
        } else if (this.getPropertyTag().isXMLObjectReference()) {
            String string2 = metadataLegacyXMLReader.getAttributeValue(attributes, LegacyXMLTags.XML_ID_REF);
            LegacyXMLObject legacyXMLObject = this.getContainerObject(false);
            metadataLegacyXMLReader.registerDeferredProperty(legacyXMLObject, this.getPropertyTag(), string2, metadataLegacyXMLReader.getDefaultPropertyAction());
        }
    }

    @Override
    protected MetadataLegacyXMLReaderState exit(TagHandler tagHandler) throws SAXException {
        MetadataLegacyXMLReader metadataLegacyXMLReader = (MetadataLegacyXMLReader)tagHandler;
        if (LegacyXMLTags.AWXML_TAG == this.getPropertyTag()) {
            metadataLegacyXMLReader.resolveDeferredProperties();
            return (MetadataLegacyXMLReaderState)metadataLegacyXMLReader.getInitialState();
        }
        return this.getParentState();
    }

    @Override
    protected MetadataLegacyXMLReaderState transition(String string, Attributes attributes, TagHandler tagHandler) throws SAXException {
        MetadataLegacyXMLReader metadataLegacyXMLReader = (MetadataLegacyXMLReader)tagHandler;
        String string2 = metadataLegacyXMLReader.getXMLFormat().getVersion();
        XMLTag xMLTag = null;
        if (null == this.getParentState()) {
            if (LegacyXMLTags.AWXML_TAG.matches(string, string2)) {
                xMLTag = LegacyXMLTags.AWXML_TAG;
            }
        } else if (null == this.getParentState().getParentState()) {
            if (LegacyXMLTags.AWXML_CONTENT_TAG.matches(string, string2)) {
                xMLTag = LegacyXMLTags.AWXML_CONTENT_TAG;
            }
        } else {
            if (this.getPropertyTag().isXMLObjectReference()) {
                return null;
            }
            xMLTag = this.getPropertyTag().isChoiceTag() ? this.getPropertyTag().findObjectTag(string, string2) : this.getContainerObject(true).getPropertyXMLTag(string, string2);
        }
        if (null != xMLTag) {
            return new MetadataLegacyXMLReaderState(xMLTag);
        }
        return null;
    }

    @Override
    public MetadataLegacyXMLReaderState getParentState() {
        return (MetadataLegacyXMLReaderState)super.getParentState();
    }

    @Override
    protected BaseMetadataObject getMetadataObject() {
        return this.getContainerObject(true);
    }
}

