/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.util.ArrayList;
import java.util.List;
import oracle.express.mdm.MetadataNotFoundException;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.MetadataXMLReader;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.mdm.MdmAttribute;
import oracle.olapi.metadata.mdm.MdmDimension;
import oracle.olapi.metadata.mdm.MdmDimensionMemberInfo;
import oracle.olapi.metadata.mdm.MdmInvalidValueException;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmQuery;
import oracle.olapi.metadata.mdm.MdmQueryColumn;
import oracle.olapi.metadata.mdm.MdmSubDimension;
import oracle.olapi.metadata.mdm.MdmViewColumn;
import oracle.olapi.metadata.mdm.MdmViewColumnOwner;
import oracle.olapi.metadata.mdm.MdmXMLTags;
import oracle.olapi.syntax.BaseQuery;
import oracle.olapi.syntax.DataType;
import oracle.olapi.syntax.Query;
import oracle.olapi.syntax.SQLDataType;
import org.xml.sax.SAXException;

public abstract class MdmHierarchy
extends MdmSubDimension
implements MdmViewColumnOwner,
MdmQuery {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{MdmXMLTags.DEFAULT_MEMBER, MdmXMLTags.CONTAINER_PRIMARY_DIM, MdmXMLTags.ET_VIEW_NAME, MdmXMLTags.ET_DEPTH_COLUMN_NAME, MdmXMLTags.ET_PARENT_COLUMN_NAME};
    private static final String ET_DEPTH_COLUMN_NAME = "DEPTH";
    private static final String ET_PARENT_COLUMN_NAME = "PARENT";
    private BaseQuery m_Query = null;
    private MdmViewColumn m_ParentColumn = null;
    private MdmViewColumn m_DepthColumn = null;

    private synchronized void createViewColumns() {
        if (null != this.m_DepthColumn) {
            return;
        }
        this.m_DepthColumn = new MdmViewColumn(this, ET_DEPTH_COLUMN_NAME, MdmXMLTags.ET_DEPTH_COLUMN_NAME, DataType.NUMBER.toSQLDataType());
        this.m_ParentColumn = new MdmViewColumn(this, ET_PARENT_COLUMN_NAME, MdmXMLTags.ET_PARENT_COLUMN_NAME);
    }

    private synchronized void createQuery() {
        if (null != this.m_Query) {
            return;
        }
        this.m_Query = new BaseQuery(this);
    }

    final void populateHierarchyETViewColumns(List<MdmQueryColumn> list) {
        list.add(this.getETParentColumn());
        list.add(this.getETDepthColumn());
    }

    final MdmQueryColumn getHierarchyETViewColumn(String string) {
        if (ET_DEPTH_COLUMN_NAME.equals(string)) {
            return this.getETDepthColumn();
        }
        if (ET_PARENT_COLUMN_NAME.equals(string)) {
            return this.getETParentColumn();
        }
        return null;
    }

    protected MdmHierarchy(MdmMetadataProvider mdmMetadataProvider) {
        super(mdmMetadataProvider);
    }

    protected MdmHierarchy(String string, short s, MdmPrimaryDimension mdmPrimaryDimension) {
        super(string, s, mdmPrimaryDimension);
        if (mdmPrimaryDimension.getDefaultHierarchy() == null) {
            MdmXMLTags.DEFAULT_COMPONENT.initializeProperty((BaseMetadataObject)mdmPrimaryDimension, (Object)this.getInternalID(), s);
        }
    }

    @Override
    public SQLDataType getSQLDataType() {
        return this.getPrimaryDimension().getSQLDataType();
    }

    public MdmAttribute getAncestorsAttribute() throws MetadataNotFoundException {
        return this.getPrimaryDimension().getAncestorsAttribute();
    }

    public MdmAttribute getParentAttribute() throws MetadataNotFoundException {
        return this.getPrimaryDimension().getParentAttribute();
    }

    public abstract MdmDimensionMemberInfo getDefaultMember() throws MetadataNotFoundException;

    public abstract void setDefaultMember(MdmDimensionMemberInfo var1) throws MetadataNotFoundException, MdmInvalidValueException;

    @Override
    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    public final boolean isDefaultHierarchy() {
        return this == this.getPrimaryDimension().getDefaultHierarchy();
    }

    @Override
    public MdmDimension getEnclosingDimension() {
        return this.getPrimaryDimension();
    }

    @Override
    protected final SourceDefinition getTypeDefinition() {
        return this.getPrimaryDimension().getSource().getDefinition();
    }

    final void setPrimaryDimension(MdmPrimaryDimension mdmPrimaryDimension) {
        this.setPropertyObjectValue(MdmXMLTags.CONTAINER_PRIMARY_DIM, mdmPrimaryDimension);
    }

    public static String generateIDFromXML(BaseMetadataObject baseMetadataObject, XMLTag xMLTag, String string, String string2, String string3, MetadataXMLReader metadataXMLReader) throws SAXException {
        BaseMetadataObject baseMetadataObject2 = baseMetadataObject.getTopLevelObject(metadataXMLReader.getPersistenceType());
        if (baseMetadataObject2 instanceof MdmPrimaryDimension) {
            baseMetadataObject = baseMetadataObject2;
        }
        return MdmSubDimension.generateIDFromXML(baseMetadataObject, xMLTag, string, string2, string3, metadataXMLReader);
    }

    public final String getETViewName() {
        return this.getPropertyStringValue(MdmXMLTags.ET_VIEW_NAME);
    }

    public final void setETViewName(String string) {
        this.setPropertyStringValue(MdmXMLTags.ET_VIEW_NAME, string);
    }

    public final MdmQueryColumn getETParentColumn() {
        if (null == this.m_ParentColumn) {
            this.createViewColumns();
        }
        return this.m_ParentColumn;
    }

    public final MdmQueryColumn getETDepthColumn() {
        if (null == this.m_DepthColumn) {
            this.createViewColumns();
        }
        return this.m_DepthColumn;
    }

    @Override
    public final Query getQuery() {
        if (null == this.m_Query) {
            this.createQuery();
        }
        return this.m_Query;
    }

    @Override
    public final String getQueryName() {
        return this.getID();
    }

    @Override
    public List<MdmQueryColumn> getQueryColumns() {
        ArrayList<MdmQueryColumn> arrayList = new ArrayList<MdmQueryColumn>();
        this.getPrimaryDimension().populateBaseETViewColumns(arrayList);
        this.populateHierarchyETViewColumns(arrayList);
        this.populateAttributeColumnList(arrayList);
        return arrayList;
    }

    @Override
    public MdmQueryColumn getQueryColumn(String string) {
        if (null == string) {
            return null;
        }
        MdmQueryColumn mdmQueryColumn = this.getPrimaryDimension().getBaseETViewColumn(string);
        if (null != mdmQueryColumn) {
            return mdmQueryColumn;
        }
        mdmQueryColumn = this.getHierarchyETViewColumn(string);
        if (null != mdmQueryColumn) {
            return mdmQueryColumn;
        }
        mdmQueryColumn = this.getAttributeColumn(string);
        return mdmQueryColumn;
    }
}

