/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.digsig;

import java.io.ByteArrayOutputStream;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Properties;
import oracle.security.digsig.BrowserSignRequest;
import oracle.security.digsig.CertificateMapper;
import oracle.security.digsig.DigitalSignatureException;
import oracle.security.digsig.Utilities;

public class PKCS7BrowserSignRequest
extends BrowserSignRequest {
    private String userID = null;
    private String returnURL = null;
    private String sigData = null;
    private String sigInfo = null;
    private boolean isAttached = false;
    private ByteArrayOutputStream theData = new ByteArrayOutputStream();

    public PKCS7BrowserSignRequest(CertificateMapper certMap, Properties config) {
        super(certMap, config);
    }

    @Override
    public void start(String userID, String returnURL) throws DigitalSignatureException {
        if (returnURL == null) {
            throw new DigitalSignatureException("returnURL cannot be null");
        }
        this.userID = userID;
        this.returnURL = returnURL;
        this.theData.reset();
    }

    @Override
    public void update(byte[] plaintext, int offset, int length) throws DigitalSignatureException {
        try {
            this.theData.write(plaintext, offset, length);
        }
        catch (Exception ex) {
            throw new DigitalSignatureException("Update failed", ex);
        }
    }

    @Override
    public void finish() throws DigitalSignatureException {
    }

    @Override
    public int setBrowserSignResponse(String sigData, String sigInfo, Properties sigDataExtra) throws DigitalSignatureException {
        if (sigData == null) {
            throw new DigitalSignatureException("sigData cannot be null");
        }
        if (sigInfo == null) {
            throw new DigitalSignatureException("sigInfo cannot be null");
        }
        this.sigData = sigData;
        this.sigInfo = sigInfo;
        return 0;
    }

    @Override
    public boolean isSupported(int uiType) {
        return uiType == 1;
    }

    @Override
    public Object getBrowserSignRequestOAF(Properties hiddenFields, Properties guiText, Properties browserConfig, Object pageContext) throws DigitalSignatureException {
        throw new DigitalSignatureException("Unsupported UI Type");
    }

    @Override
    public String getBrowserSignRequestHTML(Properties hiddenFields, Properties guiText, Properties browserConfig) throws DigitalSignatureException {
        StringWriter hiddens = new StringWriter();
        if (hiddenFields != null) {
            Enumeration<?> keys = hiddenFields.propertyNames();
            while (keys.hasMoreElements()) {
                String curKey = (String)keys.nextElement();
                if (curKey.toUpperCase().equals("oracle_security_digsig_sigdata") || curKey.toUpperCase().equals("oracle_security_digsig_siginfo")) {
                    throw new DigitalSignatureException("Can't have hidden field '" + curKey + "'");
                }
                hiddens.write("  <INPUT type=\"hidden\" name=\"" + curKey + "\" value=\"" + hiddenFields.getProperty(curKey) + "\">\n");
            }
        }
        if (guiText == null) {
            guiText = new Properties();
            guiText.setProperty("title", "Create Digital Signature");
            guiText.setProperty("internalError", "Internal Error");
            guiText.setProperty("preamble", "You are requested to sign the following message:");
            guiText.setProperty("postamble", "If you agree to sign this message, click OK.  Otherwise, click cancel.");
            guiText.setProperty("userCancel", "User Cancelled Signing");
            guiText.setProperty("incompatibleBrowser", "Incompatible Browser");
        }
        String title = guiText.getProperty("title");
        String internalError = Utilities.StringEscape(guiText.getProperty("internalError"));
        String preamble = Utilities.StringEscape(guiText.getProperty("preamble"));
        String postamble = Utilities.StringEscape(guiText.getProperty("postamble"));
        String userCancel = Utilities.StringEscape(guiText.getProperty("userCancel"));
        String incompatibleBrowser = Utilities.StringEscape(guiText.getProperty("incompatibleBrowser"));
        if (title == null) {
            throw new DigitalSignatureException("Missing guiText title property");
        }
        if (internalError == null) {
            throw new DigitalSignatureException("Missing guiText internalError property");
        }
        if (preamble == null) {
            throw new DigitalSignatureException("Missing guiText preamble property");
        }
        if (postamble == null) {
            throw new DigitalSignatureException("Missing guiText postamble property");
        }
        if (userCancel == null) {
            throw new DigitalSignatureException("Missing guiText userCancel property");
        }
        if (incompatibleBrowser == null) {
            throw new DigitalSignatureException("Missing guiText incompatibleBrowser property");
        }
        if (browserConfig == null) {
            throw new DigitalSignatureException("browserConfig must not be null!");
        }
        String capicomURL = browserConfig.getProperty("capicomURL");
        String attached = browserConfig.getProperty("attached");
        if (capicomURL == null) {
            throw new DigitalSignatureException("browserConfig must specify the capicomURL property");
        }
        if (attached != null) {
            this.isAttached = attached.equalsIgnoreCase("yes");
        }
        String dataString = Utilities.StringEscape(this.theData.toString());
        String result = new String("<html>\n<head>\n<title>" + title + "</title>\n</head>\n<body>\n\n<object classid=\"clsid:A996E48C-D3DC-4244-89F7-AFA33EC60679\"\n codebase=\"" + capicomURL + "\">\n</object>\n\n<FORM action=\"" + this.returnURL + "\" method=\"post\" name=\"submitter\">\n  <INPUT type=\"hidden\" name=\"oracle_security_digsig_sigdata\" value=\"uninitialized\">\n  <INPUT type=\"hidden\" name=\"oracle_security_digsig_siginfo\" value=\"uninitialized\">\n" + hiddens.toString() + "</FORM>\n<script language=\"VBScript\">\n<!--\n\nfunction StringToBinary(str)\n  Const adTypeText = 2\n  Const adTypeBinary = 1\n  Dim binStream\n  Set binStream = CreateObject(\"ADODB.Stream\")\n  binStream.Type = adTypeText\n  binStream.Open\n  binStream.WriteText(str)\n  binStream.Position = 0\n  binStream.Type = adTypeBinary\n  binStream.Position = 0\n  StringToBinary = binStream.Read\n  End Function\nfunction SignMessage(oString)\n  Dim oSigner\n  Dim oSignedData\n  Set oSignedData = CreateObject(\"CAPICOM.SignedData\")\n  Set oSigner = CreateObject(\"CAPICOM.Signer\")\n  Dim oAttr\n  Set oAttr = CreateObject(\"CAPICOM.Attribute\")\n  oAttr.Name = 0\n  oAttr.Value = Now\n  oSigner.AuthenticatedAttributes.Add oAttr\n  oSignedData.content = StringToBinary(oString)\n" + (this.isAttached ? "  SignMessage = oSignedData.Sign(oSigner, true, 0)\n" : "  SignMessage = oSignedData.Sign(oSigner, false, 0)\n") + "end function\n\n// -->\n</script>\n\n<script language=\"JavaScript\">\n<!--\n\nfunction errorHandle() {\n  document.submitter.oracle_security_digsig_siginfo.value = \"error\";\n  document.submitter.oracle_security_digsig_sigdata.value = unescape(\"" + internalError + "\");\n  document.submitter.submit();\n  return null;\n}\n\nwindow.onerror = errorHandle;\n\nfunction getBrowserType() {\n  if(navigator.appName == \"Microsoft Internet Explorer\")\n    return 1;\n  else if(navigator.appName == \"Netscape\")\n    return 2;\n  else\n    return 0;\n}\n\nfunction getBrowserVersion() {\n  if(getBrowserType() == 1) {\n    var verString = navigator.appVersion;\n    var MSIEloc = verString.indexOf(\"MSIE \");\n    if(MSIEloc == -1)\n      return -1;\n    return parseFloat(verString.substring(MSIEloc+5));\n  } else\n    return parseFloat(navigator.appVersion);\n}\n\nvar browserType = getBrowserType();\nvar browserVersion = getBrowserVersion();\nvar dataString = unescape(\"" + dataString + "\");\n\nif(browserType == 2 && (browserVersion >= 4 && browserVersion < 5)) {\n  document.submitter.oracle_security_digsig_siginfo.value = \"goodSignature\";\n  document.submitter.oracle_security_digsig_sigdata.value = crypto.signText(dataString, \"ask\");\n  if(document.submitter.oracle_security_digsig_sigdata.value.indexOf(\"error\") == 0) {\n    document.submitter.oracle_security_digsig_siginfo.value = \"error\";\n  }\n} else if(browserType == 1 && browserVersion >= 5) {\n  if(confirm(unescape(\"" + preamble + "\") + \"\\n\" + dataString + \"\\n\\n\" + unescape(\"" + postamble + "\"))) {\n    document.submitter.oracle_security_digsig_siginfo.value = \"goodSignature\";\n    document.submitter.oracle_security_digsig_sigdata.value = SignMessage(dataString);\n  } else {\n    document.submitter.oracle_security_digsig_siginfo.value = \"error\";\n    document.submitter.oracle_security_digsig_sigdata.value = unescape(\"" + userCancel + "\");\n  }\n} else {\n  document.submitter.oracle_security_digsig_siginfo.value = \"error\";\n  document.submitter.oracle_security_digsig_sigdata.value = unescape(\"" + incompatibleBrowser + "\");\n}\n\ndocument.submitter.submit();\n\n// -->\n</script>\n</body>\n</html>\n");
        return result;
    }

    @Override
    public int getSignatureFormat() {
        return 2;
    }

    @Override
    public String getSignature() throws DigitalSignatureException {
        if (this.sigInfo == null || this.sigData == null) {
            throw new DigitalSignatureException("Need to call setBrowserSignResponse() before getSignature()");
        }
        if (this.sigInfo.equals("error")) {
            throw new DigitalSignatureException(this.sigData);
        }
        if (this.sigInfo.equals("goodSignature")) {
            return this.sigData;
        }
        throw new DigitalSignatureException("Unidentified Problem Occurred");
    }

    @Override
    public void addRecipientID(String id) throws DigitalSignatureException {
    }
}

