/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.sqltrace.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.sqltrace.parser.SqlCursor;
import oracle.ide.util.IdeUtil;

public class TraceFile {
    private static final Logger LOGGER = Logger.getLogger(SqlCursor.class.getName());
    private File _file = null;
    private Reader _reader = null;
    private ArrayList<SqlCursor> _cursors = new ArrayList();
    private static final Pattern PATTERN = Pattern.compile("#([0-9]++)[: ]");

    public TraceFile(File file) {
        this.setFile(file);
    }

    private void setFile(File file) {
        this._file = file;
        try {
            this._reader = new InputStreamReader((InputStream)new FileInputStream(this._file), IdeUtil.getIdeEncoding());
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
        }
    }

    public String getFileName() {
        return this._file.getAbsolutePath();
    }

    public SqlCursor getLatest(double d) {
        SqlCursor sqlCursor = null;
        for (SqlCursor sqlCursor2 : this._cursors) {
            if (sqlCursor == null && sqlCursor2.getCursorNumber() == d) {
                sqlCursor = sqlCursor2;
                continue;
            }
            if (sqlCursor == null || sqlCursor2.getCursorNumber() != d || !(sqlCursor2.getTime() > sqlCursor.getTime())) continue;
            sqlCursor = sqlCursor2;
        }
        return sqlCursor;
    }

    public SqlCursor getCursor(String string, String string2, String string3) {
        SqlCursor sqlCursor = null;
        for (SqlCursor sqlCursor2 : this._cursors) {
            if (sqlCursor != null || sqlCursor2.getCursorNumber() != (double)Long.parseLong(string) || sqlCursor2.getAddr() == null || !sqlCursor2.getAddr().equals(string3) || sqlCursor2.getSqlHash() == null || !sqlCursor2.getSqlHash().equals(string2)) continue;
            sqlCursor = sqlCursor2;
        }
        return sqlCursor;
    }

    public void shred() {
        Object object;
        Object object2;
        Object object3;
        try {
            object3 = new BufferedReader(this._reader);
            String string = null;
            Stack stack = new Stack();
            Object object4 = null;
            object2 = null;
            while ((string = ((BufferedReader)object3).readLine()) != null) {
                int n;
                if (string.startsWith("PARSING")) {
                    object = new SqlCursor(string);
                    if (stack.size() > 0 && ((SqlCursor)object).getDepLevel() > 0) {
                        int n2;
                        n = ((SqlCursor)stack.peek()).getDepLevel();
                        if (n == (n2 = ((SqlCursor)object).getDepLevel())) {
                            stack.pop();
                        } else if (n != n2 - 1 && n != n2) {
                            while (((SqlCursor)stack.peek()).getDepLevel() > n2 - 1) {
                                stack.pop();
                            }
                        }
                        ((SqlCursor)stack.peek()).addRecursiveCursor((SqlCursor)object);
                        stack.push(object);
                    } else if (((SqlCursor)object).getDepLevel() == 0) {
                        stack.clear();
                        stack.push(object);
                    }
                    object2 = object;
                    this._cursors.add((SqlCursor)object2);
                    continue;
                }
                if (object2 != null && string.startsWith("=====================")) {
                    Iterator iterator = object2;
                    object2 = null;
                    continue;
                }
                if (string == null) continue;
                object = PATTERN.matcher(string);
                n = ((Matcher)object).find();
                if (n != 0) {
                    SqlCursor sqlCursor;
                    double d = Double.parseDouble(((Matcher)object).group(1));
                    boolean bl = false;
                    if (object2 != null && ((SqlCursor)object2).getCursorNumber() == d) {
                        ((SqlCursor)object2).addEvent(string);
                        bl = true;
                    } else {
                        sqlCursor = this.getLatest(d);
                        if (sqlCursor != null) {
                            sqlCursor.addEvent(string);
                            bl = true;
                            object2 = sqlCursor;
                        }
                    }
                    if (bl) continue;
                    LOGGER.info("LOSTCHILD:" + string);
                    sqlCursor = new SqlCursor(d);
                    sqlCursor.addEvent(string);
                    this._cursors.add(sqlCursor);
                    Object object5 = object2 = sqlCursor;
                    continue;
                }
                if (object2 == null) continue;
                ((SqlCursor)object2).addEvent(string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        object3 = new ArrayList(this._cursors.size() + 1);
        boolean bl = false;
        for (SqlCursor sqlCursor : this._cursors) {
            if (sqlCursor.getSqlHash() == null) continue;
            if (((ArrayList)object3).size() == 0) {
                ((ArrayList)object3).add(sqlCursor);
                continue;
            }
            bl = false;
            object2 = ((ArrayList)object3).iterator();
            while (object2.hasNext()) {
                object = (SqlCursor)object2.next();
                if (!sqlCursor.equals((SqlCursor)object)) continue;
                ((SqlCursor)object).add(sqlCursor);
                bl = true;
            }
            if (bl) continue;
            ((ArrayList)object3).add(sqlCursor);
        }
        this._cursors = object3;
        Collections.sort(this._cursors, new Comparator(){

            public int compare(Object object, Object object2) {
                Double d = ((SqlCursor)object).getTime();
                Double d2 = ((SqlCursor)object2).getTime();
                return d.compareTo(d2);
            }
        });
        try {
            this._reader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void print(PrintStream printStream) {
        ArrayList<SqlCursor> arrayList = new ArrayList<SqlCursor>();
        arrayList.clear();
        for (SqlCursor sqlCursor : this._cursors) {
            if (sqlCursor.getDepLevel() != 0) continue;
            arrayList.add(sqlCursor);
        }
        this.printDep(arrayList, 0);
    }

    public void printDep(ArrayList<SqlCursor> arrayList, int n) {
        String string = "-----------------------------------------";
        for (SqlCursor sqlCursor : arrayList) {
            System.out.print(string.substring(0, n * 2));
            if (sqlCursor.getSQL() == null) continue;
            System.out.println(sqlCursor.getAddr() + ":" + sqlCursor.getSQL().trim());
            if (sqlCursor.getRecursiveCursors() == null) continue;
            this.printDep(sqlCursor.getRecursiveCursors(), n + 1);
        }
    }

    public ArrayList<SqlCursor> getCursors() {
        return this._cursors;
    }

    public ArrayList<SqlCursor> getRecursiveCursors() {
        ArrayList<SqlCursor> arrayList = new ArrayList<SqlCursor>();
        for (SqlCursor sqlCursor : this._cursors) {
            if (sqlCursor.getDepLevel() <= 0 || sqlCursor.getSQL() == null || sqlCursor.getSQL().trim().length() <= 0) continue;
            arrayList.add(sqlCursor);
        }
        return arrayList;
    }

    public ArrayList<SqlCursor> getNonRecursiveCursors() {
        ArrayList<SqlCursor> arrayList = new ArrayList<SqlCursor>();
        for (SqlCursor sqlCursor : this._cursors) {
            if (sqlCursor.getDepLevel() != 0 || sqlCursor.getSQL() == null || sqlCursor.getSQL().trim().length() <= 0) continue;
            arrayList.add(sqlCursor);
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        TraceFile traceFile = new TraceFile(new File(stringArray[0]));
        traceFile.shred();
        traceFile.print(System.out);
    }
}

