/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlcl.commands.aq;

import java.sql.Connection;
import java.util.logging.Logger;
import oracle.dbtools.extension.SQLCLService;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.HelpMessages;
import oracle.dbtools.sqlcl.commands.aq.AQModel;
import oracle.dbtools.sqlcl.commands.aq.AQParser;
import oracle.dbtools.sqlcl.commands.aq.Messages;

public class AQCommand
extends CommandListener
implements IHelp,
SQLCLService {
    public static String COMMAND = "aq";
    public static String COMMAND_AQ_ADM = "aq -adm";
    public static String COMMAND_AQ_USER = "aq -user";
    private AQModel model;
    protected static final Logger LOGGER = Logger.getLogger(AQCommand.class.getName());

    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void beginScript(Connection conn, ScriptRunnerContext ctx) {
        LOGGER.info("aqcommand - begin");
    }

    public void endScript(Connection conn, ScriptRunnerContext ctx) {
        LOGGER.info("aqcommand - end");
    }

    public String getCommand() {
        return COMMAND;
    }

    public String getHelp() {
        String BUNDLE_NAME = "oracle.dbtools.sqlcl.commands.aq.HelpMessages";
        return HelpMessages.getString((String)this.getCommand().toUpperCase(), (String)BUNDLE_NAME);
    }

    public boolean isSqlPlus() {
        return false;
    }

    public Class<? extends CommandListener> getCommandListener() {
        return ((Object)((Object)this)).getClass();
    }

    public String getExtensionDescription() {
        String desc = Messages.getString("AQCMD.EXTENSIONDESCRIPTION").trim();
        return desc;
    }

    public String getExtensionName() {
        String name = "Advanced Queue";
        return "Advanced Queue";
    }

    public String getExtensionVersion() {
        String version = Messages.getString("SQLclVersion.VERSION");
        return version;
    }

    public boolean handleEvent(Connection sqlConn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (!cmd.getLoweredTrimmedSQL().startsWith(COMMAND)) {
            return false;
        }
        this.model = new AQModel(sqlConn, ctx, cmd);
        AQParser parser = new AQParser(this.model);
        parser.parse();
        return true;
    }
}

