/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlcl.commands.aq;

import java.io.IOException;
import javax.json.stream.JsonParsingException;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.HelpMessages;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ConnectionNotValidException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.InvalidParameterException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ParameterFailedValidationException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.parser.CommandParserOld;
import oracle.dbtools.sqlcl.commands.aq.AQException;
import oracle.dbtools.sqlcl.commands.aq.AQModel;
import oracle.dbtools.sqlcl.commands.aq.AQOptions;
import oracle.dbtools.sqlcl.commands.aq.AQProcessor;
import oracle.dbtools.sqlcl.commands.aq.Messages;

public class AQParser {
    private final AQModel model;
    final String AQ_PARAMS = "sqlcl.aq.params";
    String command;

    public AQParser(AQModel model) {
        this.model = model;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    private void parseSubCommand(String[] splitCommand, int curr, int commandLength) throws InvalidParameterException, IOException, AQException {
        block97: {
            block98: {
                if (curr != commandLength) break block98;
                if (this.model.isEnqueueCommand()) {
                    AQProcessor.enqueue(this.model);
                    break block97;
                } else if (this.model.isDequeueCommand()) {
                    AQProcessor.dequeue(this.model);
                    break block97;
                } else {
                    if (!this.model.isHelpCommand()) {
                        throw new AQException(null, String.format(Messages.getString("AQEXP.INVALID_COMMAND"), this.command.toUpperCase().replace(',', ' ')));
                    }
                    String BUNDLE_NAME = "oracle.dbtools.sqlcl.commands.aq.HelpMessages";
                    this.model.getContext().write(HelpMessages.getString((String)"aq".toUpperCase(), (String)"oracle.dbtools.sqlcl.commands.aq.HelpMessages"));
                }
                break block97;
            }
            block9 : switch (splitCommand[curr++].toLowerCase()) {
                case "queue": {
                    if (curr == commandLength) {
                        if (this.model.isCreateCommand()) {
                            AQProcessor.createQueue(this.model);
                            break;
                        }
                        if (this.model.isAlterCommand()) {
                            AQProcessor.alterQueue(this.model);
                            break;
                        }
                        if (this.model.isDropCommand()) {
                            AQProcessor.dropQueue(this.model);
                            break;
                        }
                        if (this.model.isStartCommand()) {
                            AQProcessor.startQueue(this.model);
                            break;
                        }
                        if (!this.model.isStopCommand()) {
                            throw new AQException(null, String.format(Messages.getString("AQEXP.INVALID_COMMAND"), this.command.toUpperCase().replace(',', ' ')));
                        }
                        AQProcessor.stopQueue(this.model);
                        break;
                    }
                    switch (splitCommand[curr++].toLowerCase()) {
                        case "table": {
                            if (curr != commandLength) {
                                throw new AQException(null, String.format(Messages.getString("AQEXP.INVALID_COMMAND"), this.command.toUpperCase().replace(',', ' ')));
                            }
                            if (this.model.isCreateCommand()) {
                                AQProcessor.createQueueTable(this.model);
                                break block9;
                            }
                            if (this.model.isAlterCommand()) {
                                AQProcessor.alterQueueTable(this.model);
                                break block9;
                            }
                            if (!this.model.isDropCommand()) {
                                throw new AQException(null, String.format(Messages.getString("AQEXP.INVALID_COMMAND"), this.command.toUpperCase().replace(',', ' ')));
                            }
                            AQProcessor.dropQueueTable(this.model);
                            break block9;
                        }
                    }
                    throw new AQException(null, String.format(Messages.getString("AQEXP.INVALID_COMMAND"), this.command.toUpperCase().replace(',', ' ')));
                }
                case "sharded": {
                    if (curr == commandLength) {
                        throw new AQException(null, String.format(Messages.getString("AQEXP.INVALID_COMMAND"), this.command.toUpperCase().replace(',', ' ')));
                    }
                    switch (splitCommand[curr++].toLowerCase()) {
                        case "queue": {
                            if (curr != commandLength) {
                                throw new AQException(null, String.format(Messages.getString("AQEXP.INVALID_COMMAND"), this.command.toUpperCase().replace(',', ' ')));
                            }
                            if (this.model.isCreateCommand()) {
                                AQProcessor.createShardedQueue(this.model);
                                break block9;
                            }
                            if (this.model.isAlterCommand()) {
                                AQProcessor.alterShardedQueue(this.model);
                                break block9;
                            }
                            if (!this.model.isDropCommand()) {
                                throw new AQException(null, String.format(Messages.getString("AQEXP.INVALID_COMMAND"), this.command.toUpperCase().replace(',', ' ')));
                            }
                            AQProcessor.dropShardedQueue(this.model);
                            break block9;
                        }
                    }
                    throw new AQException(null, String.format(Messages.getString("AQEXP.INVALID_COMMAND"), this.command.toUpperCase().replace(',', ' ')));
                }
                case "transactional": {
                    if (curr == commandLength) {
                        throw new AQException(null, String.format(Messages.getString("AQEXP.INVALID_COMMAND"), this.command.toUpperCase().replace(',', ' ')));
                    }
                    switch (splitCommand[curr++].toLowerCase()) {
                        case "event": {
                            if (curr == commandLength) {
                                throw new AQException(null, String.format(Messages.getString("AQEXP.INVALID_COMMAND"), this.command.toUpperCase().replace(',', ' ')));
                            }
                            switch (splitCommand[curr++].toLowerCase()) {
                                case "queue": {
                                    if (curr != commandLength) {
                                        throw new AQException(null, String.format(Messages.getString("AQEXP.INVALID_COMMAND"), this.command.toUpperCase().replace(',', ' ')));
                                    }
                                    if (this.model.isCreateCommand()) {
                                        AQProcessor.createTransactionalEventQueue(this.model);
                                        break block9;
                                    }
                                    if (this.model.isAlterCommand()) {
                                        AQProcessor.alterTransactionalEventQueue(this.model);
                                        break block9;
                                    }
                                    if (!this.model.isDropCommand()) {
                                        throw new AQException(null, String.format(Messages.getString("AQEXP.INVALID_COMMAND"), this.command.toUpperCase().replace(',', ' ')));
                                    }
                                    AQProcessor.dropTransactionalEventQueue(this.model);
                                    break block9;
                                }
                            }
                            throw new AQException(null, String.format(Messages.getString("AQEXP.INVALID_COMMAND"), this.command.toUpperCase().replace(',', ' ')));
                        }
                    }
                    throw new AQException(null, String.format(Messages.getString("AQEXP.INVALID_COMMAND"), this.command.toUpperCase().replace(',', ' ')));
                }
                case "exception": {
                    if (curr == commandLength) {
                        throw new AQException(null, String.format(Messages.getString("AQEXP.INVALID_COMMAND"), this.command.toUpperCase().replace(',', ' ')));
                    }
                    switch (splitCommand[curr++].toLowerCase()) {
                        case "queue": {
                            if (this.model.isCreateCommand() && curr == commandLength) {
                                AQProcessor.createExceptionQueue(this.model);
                                break block9;
                            }
                            throw new AQException(null, String.format(Messages.getString("AQEXP.INVALID_COMMAND"), this.command.toUpperCase().replace(',', ' ')));
                        }
                    }
                    throw new AQException(null, String.format(Messages.getString("AQEXP.INVALID_COMMAND"), this.command.toUpperCase().replace(',', ' ')));
                }
                case "eq": {
                    if (curr == commandLength) {
                        throw new AQException(null, String.format(Messages.getString("AQEXP.INVALID_COMMAND"), this.command.toUpperCase().replace(',', ' ')));
                    }
                    switch (splitCommand[curr++].toLowerCase()) {
                        case "exception": {
                            if (curr == commandLength) {
                                throw new AQException(null, String.format(Messages.getString("AQEXP.INVALID_COMMAND"), this.command.toUpperCase().replace(',', ' ')));
                            }
                            switch (splitCommand[curr++].toLowerCase()) {
                                case "queue": {
                                    if (this.model.isCreateCommand() && curr == commandLength) {
                                        AQProcessor.createEQExceptionQueue(this.model);
                                        break block9;
                                    }
                                    throw new AQException(null, String.format(Messages.getString("AQEXP.INVALID_COMMAND"), this.command.toUpperCase().replace(',', ' ')));
                                }
                            }
                            throw new AQException(null, String.format(Messages.getString("AQEXP.INVALID_COMMAND"), this.command.toUpperCase().replace(',', ' ')));
                        }
                    }
                    throw new AQException(null, String.format(Messages.getString("AQEXP.INVALID_COMMAND"), this.command.toUpperCase().replace(',', ' ')));
                }
                case "subscriber": {
                    if (curr != commandLength) {
                        throw new AQException(null, String.format(Messages.getString("AQEXP.INVALID_COMMAND"), this.command.toUpperCase().replace(',', ' ')));
                    }
                    if (this.model.isAddCommand()) {
                        AQProcessor.addSubscriber(this.model);
                        break;
                    }
                    if (this.model.isAlterCommand()) {
                        AQProcessor.alterSubscriber(this.model);
                        break;
                    }
                    if (!this.model.isRemoveCommand()) {
                        throw new AQException(null, String.format(Messages.getString("AQEXP.INVALID_COMMAND"), this.command.toUpperCase().replace(',', ' ')));
                    }
                    AQProcessor.removeSubscriber(this.model);
                    break;
                }
                case "examples": {
                    if (curr == commandLength && this.model.isHelpCommand()) {
                        String BUNDLE_NAME = "oracle.dbtools.sqlcl.commands.aq.HelpMessages";
                        this.model.getContext().write(HelpMessages.getString((String)"aq_help_examples".toUpperCase(), (String)"oracle.dbtools.sqlcl.commands.aq.HelpMessages"));
                        break;
                    }
                    throw new AQException(null, String.format(Messages.getString("AQEXP.INVALID_COMMAND"), this.command.toUpperCase().replace(',', ' ')));
                }
                default: {
                    throw new AQException(null, String.format(Messages.getString("AQEXP.INVALID_COMMAND"), this.command.toUpperCase().replace(',', ' ')));
                }
            }
        }
        if (!this.model.isHelpCommand()) {
            this.model.getContext().write("\n" + String.format(Messages.getString("AQEXP.SUCCESS_COMMAND"), this.command.toUpperCase().replace(',', ' ')) + "\n");
        }
    }

    public void parse() {
        try {
            CommandParserOld.loadParams((String)"sqlcl.aq.params", (String)this.model.getCommand().getSql(), (ScriptRunnerContext)this.model.getContext(), AQOptions.subCommands, AQOptions.coreOptions);
            String string = AQOptions.commandAliases.containsKey(this.model.getContext().getParameterInstance().getParameterAsString("sqlcl.aq.params", "command")) ? AQOptions.commandAliases.get(this.model.getContext().getParameterInstance().getParameterAsString("sqlcl.aq.params", "command")) : (this.command = this.model.getContext().getParameterInstance().getParameterAsString("sqlcl.aq.params", "command") == null ? null : this.model.getContext().getParameterInstance().getParameterAsString("sqlcl.aq.params", "command"));
            if (this.command == null) {
                throw new AQException(null, String.format(Messages.getString("AQEXP.INVALID_COMMAND"), "NULL"));
            }
            String[] splitCommand = this.command.split(",");
            Integer commandLength = splitCommand.length;
            int curr = 0;
            switch (splitCommand[curr++].toLowerCase()) {
                case "create": {
                    this.model.setCreateCommand(true);
                    break;
                }
                case "alter": {
                    this.model.setAlterCommand(true);
                    break;
                }
                case "drop": {
                    this.model.setDropCommand(true);
                    break;
                }
                case "start": {
                    this.model.setStartCommand(true);
                    break;
                }
                case "stop": {
                    this.model.setStopCommand(true);
                    break;
                }
                case "add": {
                    this.model.setAddCommand(true);
                    break;
                }
                case "remove": {
                    this.model.setRemoveCommand(true);
                    break;
                }
                case "enqueue": {
                    this.model.setEnqueueCommand(true);
                    break;
                }
                case "dequeue": {
                    this.model.setDequeueCommand(true);
                    break;
                }
                case "help": {
                    this.model.setHelpCommand(true);
                    break;
                }
                default: {
                    throw new AQException(null, String.format(Messages.getString("AQEXP.INVALID_COMMAND"), this.command.toUpperCase().replace(',', ' ')));
                }
            }
            this.parseSubCommand(splitCommand, curr, commandLength);
        }
        catch (IOException | java.security.InvalidParameterException | JsonParsingException | ConnectionNotValidException | InvalidParameterException | ParameterFailedValidationException | AQException ex) {
            this.model.getContext().write(ex.getMessage());
        }
    }
}

