/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlcl.commands.aq;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.stream.JsonParsingException;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.InvalidParameterException;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.sqlcl.commands.aq.AQException;
import oracle.dbtools.sqlcl.commands.aq.AQModel;
import oracle.dbtools.sqlcl.commands.aq.AQOptions;
import oracle.dbtools.sqlcl.commands.aq.AQParams;
import oracle.dbtools.sqlcl.commands.aq.Messages;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleType;
import oracle.sql.RAW;
import oracle.sql.json.OracleJsonValue;

public class AQProcessor {
    static final String AQ_PARAMS = "sqlcl.aq.params";
    static List<String> booleanBinds = new ArrayList<String>();

    private static void bind(OracleCallableStatement statement, List<Object> binds) throws SQLException {
        int bindIdx = 1;
        for (Object bind : binds) {
            if (bind == AQOptions.NULL_OBJECT || bind instanceof String && ((String)bind).equals("")) {
                statement.setNull(bindIdx, 12);
            } else if (bind instanceof String) {
                statement.setString(bindIdx, (String)bind);
            } else if (bind instanceof Integer) {
                statement.setInt(bindIdx, ((Integer)bind).intValue());
            } else if (bind instanceof JsonStructure) {
                statement.setObject(bindIdx, bind, (SQLType)OracleType.JSON);
            } else {
                statement.setObject(bindIdx, bind);
            }
            ++bindIdx;
        }
    }

    private static void bindPayload(String payload, List<Object> binds, int payloadType) {
        if (payloadType == AQOptions.JSON_MAPPING) {
            binds.add(AQProcessor.getJSON(payload));
        } else {
            binds.add(payload);
        }
    }

    private static List<Object> collectParams(AQModel model, String option) throws InvalidParameterException {
        List<AQParams> params = AQOptions.params.get(option);
        ArrayList<Object> binds = new ArrayList<Object>();
        booleanBinds.clear();
        for (AQParams param : params) {
            Object val = AQProcessor.getParameter(model, param);
            if (param.getType() == AQParams.ParameterType.BOOLEAN) {
                booleanBinds.add(String.valueOf(val));
                continue;
            }
            binds.add(AQProcessor.getParameter(model, param));
        }
        return binds;
    }

    private static boolean containsParameter(AQModel model, String parameter) {
        return model.getContext().getParameterInstance().getParameters(AQ_PARAMS).containsKey(parameter) ? true : model.getContext().getParameterInstance().getParameters(AQ_PARAMS).containsKey(AQOptions.aliases.get(parameter));
    }

    private static void executeQuery(AQModel model, String query, List<Object> binds) throws AQException {
        DBUtil dBUtil = DBUtil.getInstance((Connection)model.getConnection());
        dBUtil.execute(query, binds);
        SQLException e = dBUtil.getLastException();
        if (e != null) {
            throw new AQException(null, String.format(e.getMessage(), new Object[0]));
        }
    }

    private static JsonStructure getJSON(String payload) throws JsonParsingException {
        try (JsonReader jsonReader = Json.createReader((Reader)new StringReader(payload));){
            JsonStructure object;
            JsonStructure jsonStructure = object = jsonReader.read();
            return jsonStructure;
        }
    }

    private static Object getParameter(AQModel model, AQParams param) throws InvalidParameterException {
        return model.getContext().getParameterInstance().getParameters(AQ_PARAMS).containsKey(param.getName()) ? AQProcessor.getValue(model, param.getType(), param.getName()) : (model.getContext().getParameterInstance().getParameters(AQ_PARAMS).containsKey(AQOptions.aliases.get(param.getName())) ? AQProcessor.getValue(model, param.getType(), AQOptions.aliases.get(param.getName())) : param.getDefault());
    }

    private static void getPayload(AQModel model, OracleCallableStatement statement, int position, int payloadType) throws SQLException, InvalidParameterException, IOException {
        if (payloadType == AQOptions.JSON_MAPPING) {
            OracleJsonValue deqPayload = (OracleJsonValue)statement.getObject(position, OracleJsonValue.class);
            AQProcessor.writePayload(model, deqPayload.toString());
        } else {
            RAW deqPayload = statement.getRAW(position);
            AQProcessor.writePayload(model, deqPayload.stringValue());
        }
    }

    private static String getQuery(String id, Connection conn) {
        QueryXMLSupport xml = QueryXMLSupport.getQueryXMLSupport((MetaResource)new MetaResource(AQProcessor.class.getClassLoader(), "oracle/dbtools/sqlcl/commands/aq/aqQueries.xml"));
        Query q = xml.getQuery(id, conn);
        return q == null ? null : q.getSql();
    }

    private static Object getValue(AQModel model, AQParams.ParameterType paramType, String paramName) throws InvalidParameterException {
        if (null != paramType) {
            switch (paramType) {
                case STRING: {
                    return model.getContext().getParameterInstance().getParameterAsString(AQ_PARAMS, paramName);
                }
                case NUMBER: {
                    return model.getContext().getParameterInstance().getParameterAsInt(AQ_PARAMS, paramName);
                }
                case BOOLEAN: {
                    return model.getContext().getParameterInstance().getParameterAsBoolean(AQ_PARAMS, paramName);
                }
            }
            return null;
        }
        return null;
    }

    private static void registerPayloadParameter(OracleCallableStatement statement, int position, int payloadType) throws SQLException {
        if (payloadType == AQOptions.JSON_MAPPING) {
            statement.registerOutParameter(position, (SQLType)OracleType.JSON);
        } else {
            statement.registerOutParameter(position, (SQLType)OracleType.RAW);
        }
    }

    private static boolean validOutParameter(AQModel model, String parameter) throws InvalidParameterException {
        return model.getContext().getParameterInstance().getParameters(AQ_PARAMS).containsKey(parameter) ? AQProcessor.getValue(model, AQParams.ParameterType.STRING, parameter).toString().charAt(0) == ':' : (model.getContext().getParameterInstance().getParameters(AQ_PARAMS).containsKey(AQOptions.aliases.get(parameter)) ? AQProcessor.getValue(model, AQParams.ParameterType.STRING, AQOptions.aliases.get(parameter)).toString().charAt(0) == ':' : true);
    }

    private static void writePayload(AQModel model, String payload) throws InvalidParameterException, IOException {
        if (AQProcessor.containsParameter(model, "payload")) {
            System.out.println("Payload : " + payload);
        } else if (AQProcessor.containsParameter(model, "filename")) {
            AQParams fileNameParam = new AQParams("filename", AQParams.ParameterType.STRING, null);
            String fileName = (String)AQProcessor.getParameter(model, fileNameParam);
            Path filepath = Path.of(fileName, new String[0]);
            Files.writeString(filepath, (CharSequence)payload, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
    }

    public static void addSubscriber(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("addsub", model.getConnection());
        if (!AQProcessor.containsParameter(model, "name")) {
            throw new AQException(null, String.format(Messages.getString("AQEXP.MISSING_COMPULSORY"), "name".toUpperCase()));
        }
        if (!AQProcessor.containsParameter(model, "queue_name")) {
            throw new AQException(null, String.format(Messages.getString("AQEXP.MISSING_COMPULSORY"), "queue_name".toUpperCase()));
        }
        List<Object> binds = AQProcessor.collectParams(model, "add,subscriber");
        query = String.format(query, booleanBinds.toArray());
        AQProcessor.executeQuery(model, query, binds);
    }

    public static void alterQueue(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("alterq", model.getConnection());
        if (!AQProcessor.containsParameter(model, "name")) {
            throw new AQException(null, String.format(Messages.getString("AQEXP.MISSING_COMPULSORY"), "name".toUpperCase()));
        }
        AQProcessor.executeQuery(model, query, AQProcessor.collectParams(model, "alter,queue"));
    }

    public static void alterQueueTable(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("alterqt", model.getConnection());
        if (!AQProcessor.containsParameter(model, "name")) {
            throw new AQException(null, String.format(Messages.getString("AQEXP.MISSING_COMPULSORY"), "name".toUpperCase()));
        }
        AQProcessor.executeQuery(model, query, AQProcessor.collectParams(model, "alter,queue,table"));
    }

    public static void alterShardedQueue(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("altersq", model.getConnection());
        if (!AQProcessor.containsParameter(model, "name")) {
            throw new AQException(null, String.format(Messages.getString("AQEXP.MISSING_COMPULSORY"), "name".toUpperCase()));
        }
        AQProcessor.executeQuery(model, query, AQProcessor.collectParams(model, "alter,sharded,queue"));
    }

    public static void alterSubscriber(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("altersub", model.getConnection());
        if (!AQProcessor.containsParameter(model, "name")) {
            throw new AQException(null, String.format(Messages.getString("AQEXP.MISSING_COMPULSORY"), "name".toUpperCase()));
        }
        if (!AQProcessor.containsParameter(model, "queue_name")) {
            throw new AQException(null, String.format(Messages.getString("AQEXP.MISSING_COMPULSORY"), "queue_name".toUpperCase()));
        }
        AQProcessor.executeQuery(model, query, AQProcessor.collectParams(model, "alter,subscriber"));
    }

    public static void alterTransactionalEventQueue(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("alterteq", model.getConnection());
        if (!AQProcessor.containsParameter(model, "name")) {
            throw new AQException(null, String.format(Messages.getString("AQEXP.MISSING_COMPULSORY"), "name".toUpperCase()));
        }
        AQProcessor.executeQuery(model, query, AQProcessor.collectParams(model, "alter,transactional,event,queue"));
    }

    public static void createEQExceptionQueue(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("createeqeq", model.getConnection());
        if (!AQProcessor.containsParameter(model, "teq_queue_name")) {
            throw new AQException(null, String.format(Messages.getString("AQEXP.MISSING_COMPULSORY"), "teq_queue_name".toUpperCase()));
        }
        AQProcessor.executeQuery(model, query, AQProcessor.collectParams(model, "create,eq,exception,queue"));
    }

    public static void createExceptionQueue(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("createeq", model.getConnection());
        if (!AQProcessor.containsParameter(model, "sharded_queue_name")) {
            throw new AQException(null, String.format(Messages.getString("AQEXP.MISSING_COMPULSORY"), "sharded_queue_name".toUpperCase()));
        }
        AQProcessor.executeQuery(model, query, AQProcessor.collectParams(model, "create,exception,queue"));
    }

    public static void createQueue(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("createq", model.getConnection());
        if (!AQProcessor.containsParameter(model, "name")) {
            throw new AQException(null, String.format(Messages.getString("AQEXP.MISSING_COMPULSORY"), "name".toUpperCase()));
        }
        if (!AQProcessor.containsParameter(model, "table_name")) {
            throw new AQException(null, String.format(Messages.getString("AQEXP.MISSING_COMPULSORY"), "table_name".toUpperCase()));
        }
        AQProcessor.executeQuery(model, query, AQProcessor.collectParams(model, "create,queue"));
    }

    public static void createQueueTable(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("createqt", model.getConnection());
        if (!AQProcessor.containsParameter(model, "name")) {
            throw new AQException(null, String.format(Messages.getString("AQEXP.MISSING_COMPULSORY"), "name".toUpperCase()));
        }
        if (!AQProcessor.containsParameter(model, "payload_type")) {
            throw new AQException(null, String.format(Messages.getString("AQEXP.MISSING_COMPULSORY"), "payload_type".toUpperCase()));
        }
        List<Object> binds = AQProcessor.collectParams(model, "create,queue,table");
        query = String.format(query, booleanBinds.toArray());
        AQProcessor.executeQuery(model, query, binds);
    }

    public static void createShardedQueue(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("createsq", model.getConnection());
        if (!AQProcessor.containsParameter(model, "name")) {
            throw new AQException(null, String.format(Messages.getString("AQEXP.MISSING_COMPULSORY"), "name".toUpperCase()));
        }
        List<Object> binds = AQProcessor.collectParams(model, "create,sharded,queue");
        query = String.format(query, booleanBinds.toArray());
        AQProcessor.executeQuery(model, query, binds);
    }

    public static void createTransactionalEventQueue(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("createteq", model.getConnection());
        if (!AQProcessor.containsParameter(model, "name")) {
            throw new AQException(null, String.format(Messages.getString("AQEXP.MISSING_COMPULSORY"), "name".toUpperCase()));
        }
        List<Object> binds = AQProcessor.collectParams(model, "create,transactional,event,queue");
        query = String.format(query, booleanBinds.toArray());
        AQProcessor.executeQuery(model, query, binds);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void dequeue(AQModel model) throws InvalidParameterException, IOException, AQException {
        if (!AQProcessor.containsParameter(model, "name")) {
            throw new AQException(null, String.format(Messages.getString("AQEXP.MISSING_COMPULSORY"), "name".toUpperCase()));
        }
        String query = AQProcessor.getQuery("deq", model.getConnection());
        List<Object> binds = AQProcessor.collectParams(model, "dequeue");
        if (AQProcessor.containsParameter(model, "message_id")) {
            AQParams messageIdParam = new AQParams("message_id", AQParams.ParameterType.STRING, null);
            String messageIdBind = (String)AQProcessor.getParameter(model, messageIdParam);
            if (messageIdBind.length() > 0 && messageIdBind.charAt(0) == ':') {
                messageIdBind = messageIdBind.substring(1);
                if (!model.getContext().getVarMap().containsKey(messageIdBind.toUpperCase())) throw new AQException(null, String.format(Messages.getString("AQEXP.INVALID_BIND"), messageIdBind.toUpperCase()));
                Bind msgIdBind = (Bind)model.getContext().getVarMap().get(messageIdBind.toUpperCase());
                binds.add(msgIdBind.getValue());
            } else {
                binds.add(messageIdBind);
            }
        } else {
            binds.add(null);
        }
        AQParams queueNameParam = new AQParams("name", AQParams.ParameterType.STRING, null);
        binds.add(AQProcessor.getParameter(model, queueNameParam));
        Integer payloadType = AQOptions.JSON_MAPPING;
        if (AQProcessor.containsParameter(model, "payload_type")) {
            AQParams payloadParam = new AQParams("payload_type", AQParams.ParameterType.STRING, null);
            String payloadTy = (String)AQProcessor.getParameter(model, payloadParam);
            if (!AQOptions.payloadTypes.containsKey(payloadTy.toLowerCase())) throw new AQException(null, String.format(Messages.getString("AQEXP.INVALID_PAYLOAD"), payloadTy.toUpperCase()));
            payloadType = AQOptions.payloadTypes.get(payloadTy.toLowerCase());
        }
        OracleCallableStatement dequeueStatement = null;
        if (!LockManager.lock((Connection)model.getConnection())) return;
        try {
            Bind sBind;
            Bind eBind;
            Bind msgIdBind;
            String messageIdBind;
            AQParams messageIdParam;
            RAW msg_id;
            dequeueStatement = (OracleCallableStatement)model.getConnection().prepareCall(query);
            AQProcessor.bind(dequeueStatement, binds);
            AQProcessor.registerPayloadParameter(dequeueStatement, binds.size() + 1, payloadType);
            dequeueStatement.registerOutParameter(binds.size() + 2, (SQLType)OracleType.RAW);
            dequeueStatement.registerOutParameter(binds.size() + 3, (SQLType)OracleType.NUMBER);
            dequeueStatement.registerOutParameter(binds.size() + 4, (SQLType)OracleType.NUMBER);
            dequeueStatement.registerOutParameter(binds.size() + 5, (SQLType)OracleType.NUMBER);
            dequeueStatement.registerOutParameter(binds.size() + 6, (SQLType)OracleType.VARCHAR2);
            dequeueStatement.registerOutParameter(binds.size() + 7, (SQLType)OracleType.NUMBER);
            dequeueStatement.registerOutParameter(binds.size() + 8, (SQLType)OracleType.VARCHAR2);
            dequeueStatement.registerOutParameter(binds.size() + 9, (SQLType)OracleType.DATE);
            dequeueStatement.registerOutParameter(binds.size() + 10, (SQLType)OracleType.NUMBER);
            dequeueStatement.registerOutParameter(binds.size() + 11, (SQLType)OracleType.VARCHAR2);
            dequeueStatement.registerOutParameter(binds.size() + 12, (SQLType)OracleType.RAW);
            dequeueStatement.registerOutParameter(binds.size() + 13, (SQLType)OracleType.NUMBER);
            dequeueStatement.executeUpdate();
            AQProcessor.getPayload(model, dequeueStatement, binds.size() + 1, payloadType);
            if (AQProcessor.containsParameter(model, "out_message_id")) {
                msg_id = dequeueStatement.getRAW(binds.size() + 2);
                messageIdParam = new AQParams("out_message_id", AQParams.ParameterType.STRING, null);
                messageIdBind = (String)AQProcessor.getParameter(model, messageIdParam);
                if (messageIdBind == null) {
                    System.out.println("Message ID : " + msg_id.stringValue());
                } else {
                    if (messageIdBind.charAt(0) == ':') {
                        messageIdBind = messageIdBind.substring(1);
                    }
                    if (model.getContext().getVarMap().containsKey(messageIdBind.toUpperCase())) {
                        msgIdBind = (Bind)model.getContext().getVarMap().get(messageIdBind.toUpperCase());
                        msgIdBind.setValue(msg_id.stringValue());
                        model.getContext().getVarMap().put(messageIdBind.toUpperCase(), msgIdBind);
                    } else {
                        System.out.println("Message ID : " + msg_id.stringValue());
                    }
                }
            }
            if (AQProcessor.containsParameter(model, "out_priority")) {
                Integer out_priority = dequeueStatement.getInt(binds.size() + 3);
                AQParams priorityParam = new AQParams("out_priority", AQParams.ParameterType.STRING, null);
                String priorityBind = (String)AQProcessor.getParameter(model, priorityParam);
                if (priorityBind == null) {
                    System.out.println("Priority : " + out_priority.toString());
                } else {
                    if (priorityBind.charAt(0) == ':') {
                        priorityBind = priorityBind.substring(1);
                    }
                    if (model.getContext().getVarMap().containsKey(priorityBind.toUpperCase())) {
                        Bind pBind = (Bind)model.getContext().getVarMap().get(priorityBind.toUpperCase());
                        pBind.setValue(out_priority.toString());
                        model.getContext().getVarMap().put(priorityBind.toUpperCase(), pBind);
                    } else {
                        System.out.println("Priority : " + out_priority.toString());
                    }
                }
            }
            if (AQProcessor.containsParameter(model, "out_delay")) {
                Integer out_delay = dequeueStatement.getInt(binds.size() + 4);
                AQParams delayParam = new AQParams("out_delay", AQParams.ParameterType.STRING, null);
                String delayBind = (String)AQProcessor.getParameter(model, delayParam);
                if (delayBind == null) {
                    System.out.println("Delay : " + out_delay.toString());
                } else {
                    if (delayBind.charAt(0) == ':') {
                        delayBind = delayBind.substring(1);
                    }
                    if (model.getContext().getVarMap().containsKey(delayBind.toUpperCase())) {
                        Bind dBind = (Bind)model.getContext().getVarMap().get(delayBind.toUpperCase());
                        dBind.setValue(out_delay.toString());
                        model.getContext().getVarMap().put(delayBind.toUpperCase(), dBind);
                    } else {
                        System.out.println("Delay : " + out_delay.toString());
                    }
                }
            }
            if (AQProcessor.containsParameter(model, "out_expiration")) {
                Integer out_expiration = dequeueStatement.getInt(binds.size() + 5);
                AQParams expParam = new AQParams("out_expiration", AQParams.ParameterType.STRING, null);
                String expBind = (String)AQProcessor.getParameter(model, expParam);
                if (expBind == null) {
                    System.out.println("Expiration : " + out_expiration.toString());
                } else {
                    if (expBind.charAt(0) == ':') {
                        expBind = expBind.substring(1);
                    }
                    if (model.getContext().getVarMap().containsKey(expBind.toUpperCase())) {
                        eBind = (Bind)model.getContext().getVarMap().get(expBind.toUpperCase());
                        eBind.setValue(out_expiration.toString());
                        model.getContext().getVarMap().put(expBind.toUpperCase(), eBind);
                    } else {
                        System.out.println("Expiration : " + out_expiration.toString());
                    }
                }
            }
            if (AQProcessor.containsParameter(model, "out_correlation")) {
                String out_correlation = dequeueStatement.getString(binds.size() + 6);
                AQParams corrParam = new AQParams("out_correlation", AQParams.ParameterType.STRING, null);
                String corrBind = (String)AQProcessor.getParameter(model, corrParam);
                if (corrBind == null) {
                    System.out.println("Correlation : " + out_correlation);
                } else {
                    if (corrBind.charAt(0) == ':') {
                        corrBind = corrBind.substring(1);
                    }
                    if (model.getContext().getVarMap().containsKey(corrBind.toUpperCase())) {
                        Bind cBind = (Bind)model.getContext().getVarMap().get(corrBind.toUpperCase());
                        cBind.setValue(out_correlation);
                        model.getContext().getVarMap().put(corrBind.toUpperCase(), cBind);
                    } else {
                        System.out.println("Correlation : " + out_correlation);
                    }
                }
            }
            if (AQProcessor.containsParameter(model, "out_attempts")) {
                Integer out_attempts = dequeueStatement.getInt(binds.size() + 7);
                AQParams attParam = new AQParams("out_attempts", AQParams.ParameterType.STRING, null);
                String attBind = (String)AQProcessor.getParameter(model, attParam);
                if (attBind == null) {
                    System.out.println("Attempts : " + out_attempts.toString());
                } else {
                    if (attBind.charAt(0) == ':') {
                        attBind = attBind.substring(1);
                    }
                    if (model.getContext().getVarMap().containsKey(attBind.toUpperCase())) {
                        Bind aBind = (Bind)model.getContext().getVarMap().get(attBind.toUpperCase());
                        aBind.setValue(out_attempts.toString());
                        model.getContext().getVarMap().put(attBind.toUpperCase(), aBind);
                    } else {
                        System.out.println("Attempts : " + out_attempts.toString());
                    }
                }
            }
            if (AQProcessor.containsParameter(model, "out_exception_queue")) {
                String out_eq = dequeueStatement.getString(binds.size() + 8);
                AQParams eqParam = new AQParams("out_exception_queue", AQParams.ParameterType.STRING, null);
                String eqBind = (String)AQProcessor.getParameter(model, eqParam);
                if (eqBind == null) {
                    System.out.println("Exception Queue : " + out_eq);
                } else {
                    if (eqBind.charAt(0) == ':') {
                        eqBind = eqBind.substring(1);
                    }
                    if (model.getContext().getVarMap().containsKey(eqBind.toUpperCase())) {
                        eBind = (Bind)model.getContext().getVarMap().get(eqBind.toUpperCase());
                        eBind.setValue(out_eq);
                        model.getContext().getVarMap().put(eqBind.toUpperCase(), eBind);
                    } else {
                        System.out.println("Exception Queue : " + out_eq);
                    }
                }
            }
            if (AQProcessor.containsParameter(model, "out_enqueue_time")) {
                String out_eq_time = dequeueStatement.getDate(binds.size() + 9).toString();
                AQParams eqdParam = new AQParams("out_enqueue_time", AQParams.ParameterType.STRING, null);
                String eqdBind = (String)AQProcessor.getParameter(model, eqdParam);
                if (eqdBind == null) {
                    System.out.println("Enqueue Time : " + out_eq_time);
                } else {
                    if (eqdBind.charAt(0) == ':') {
                        eqdBind = eqdBind.substring(1);
                    }
                    if (model.getContext().getVarMap().containsKey(eqdBind.toUpperCase())) {
                        Bind etBind = (Bind)model.getContext().getVarMap().get(eqdBind.toUpperCase());
                        etBind.setValue(out_eq_time);
                        model.getContext().getVarMap().put(eqdBind.toUpperCase(), etBind);
                    } else {
                        System.out.println("Enqueue Time : " + out_eq_time);
                    }
                }
            }
            if (AQProcessor.containsParameter(model, "out_state")) {
                Integer out_state = dequeueStatement.getInt(binds.size() + 10);
                AQParams stParam = new AQParams("out_state", AQParams.ParameterType.STRING, null);
                String stBind = (String)AQProcessor.getParameter(model, stParam);
                if (stBind == null) {
                    System.out.println("State : " + out_state.toString());
                } else {
                    if (stBind.charAt(0) == ':') {
                        stBind = stBind.substring(1);
                    }
                    if (model.getContext().getVarMap().containsKey(stBind.toUpperCase())) {
                        sBind = (Bind)model.getContext().getVarMap().get(stBind.toUpperCase());
                        sBind.setValue(out_state.toString());
                        model.getContext().getVarMap().put(stBind.toUpperCase(), sBind);
                    } else {
                        System.out.println("State : " + out_state.toString());
                    }
                }
            }
            if (AQProcessor.containsParameter(model, "out_sender_id")) {
                String out_sender = dequeueStatement.getString(binds.size() + 11);
                AQParams srParam = new AQParams("out_sender_id", AQParams.ParameterType.STRING, null);
                String srBind = (String)AQProcessor.getParameter(model, srParam);
                if (srBind == null) {
                    System.out.println("Sender ID : " + out_sender);
                } else {
                    if (srBind.charAt(0) == ':') {
                        srBind = srBind.substring(1);
                    }
                    if (model.getContext().getVarMap().containsKey(srBind.toUpperCase())) {
                        sBind = (Bind)model.getContext().getVarMap().get(srBind.toUpperCase());
                        sBind.setValue(out_sender);
                        model.getContext().getVarMap().put(srBind.toUpperCase(), sBind);
                    } else {
                        System.out.println("Sender ID : " + out_sender);
                    }
                }
            }
            if (AQProcessor.containsParameter(model, "out_original_message_id")) {
                msg_id = dequeueStatement.getRAW(binds.size() + 12) == null ? null : dequeueStatement.getRAW(binds.size() + 12);
                messageIdParam = new AQParams("out_original_message_id", AQParams.ParameterType.STRING, null);
                messageIdBind = (String)AQProcessor.getParameter(model, messageIdParam);
                if (messageIdBind == null) {
                    System.out.println("Original Message ID : " + (msg_id == null ? null : msg_id.stringValue()));
                } else {
                    if (messageIdBind.charAt(0) == ':') {
                        messageIdBind = messageIdBind.substring(1);
                    }
                    if (model.getContext().getVarMap().containsKey(messageIdBind.toUpperCase())) {
                        msgIdBind = (Bind)model.getContext().getVarMap().get(messageIdBind.toUpperCase());
                        msgIdBind.setValue(msg_id == null ? null : msg_id.stringValue());
                        model.getContext().getVarMap().put(messageIdBind.toUpperCase(), msgIdBind);
                    } else {
                        System.out.println("Original Message ID : " + (msg_id == null ? null : msg_id.stringValue()));
                    }
                }
            }
            if (!AQProcessor.containsParameter(model, "out_mode")) return;
            Integer out_mode = dequeueStatement.getInt(binds.size() + 13);
            AQParams modeParam = new AQParams("out_mode", AQParams.ParameterType.STRING, null);
            String modeBind = (String)AQProcessor.getParameter(model, modeParam);
            if (modeBind == null) {
                System.out.println("Mode : " + out_mode.toString());
                return;
            } else {
                if (modeBind.charAt(0) == ':') {
                    modeBind = modeBind.substring(1);
                }
                if (model.getContext().getVarMap().containsKey(modeBind.toUpperCase())) {
                    Bind mBind = (Bind)model.getContext().getVarMap().get(modeBind.toUpperCase());
                    mBind.setValue(out_mode.toString());
                    model.getContext().getVarMap().put(modeBind.toUpperCase(), mBind);
                    return;
                } else {
                    System.out.println("Mode : " + out_mode.toString());
                }
            }
            return;
        }
        catch (SQLException ex) {
            throw new AQException(null, String.format(ex.getMessage(), new Object[0]));
        }
        finally {
            if (dequeueStatement != null) {
                try {
                    dequeueStatement.close();
                }
                catch (SQLException e) {
                    throw new AQException(null, String.format(e.getMessage(), new Object[0]));
                }
            }
            LockManager.unlock((Connection)model.getConnection());
        }
    }

    public static void dropQueue(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("dropq", model.getConnection());
        if (!AQProcessor.containsParameter(model, "name")) {
            throw new AQException(null, String.format(Messages.getString("AQEXP.MISSING_COMPULSORY"), "name".toUpperCase()));
        }
        AQProcessor.executeQuery(model, query, AQProcessor.collectParams(model, "drop,queue"));
    }

    public static void dropQueueTable(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("dropqt", model.getConnection());
        if (!AQProcessor.containsParameter(model, "name")) {
            throw new AQException(null, String.format(Messages.getString("AQEXP.MISSING_COMPULSORY"), "name".toUpperCase()));
        }
        List<Object> binds = AQProcessor.collectParams(model, "drop,queue,table");
        query = String.format(query, booleanBinds.toArray());
        AQProcessor.executeQuery(model, query, binds);
    }

    public static void dropShardedQueue(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("dropsq", model.getConnection());
        if (!AQProcessor.containsParameter(model, "name")) {
            throw new AQException(null, String.format(Messages.getString("AQEXP.MISSING_COMPULSORY"), "name".toUpperCase()));
        }
        List<Object> binds = AQProcessor.collectParams(model, "drop,sharded,queue");
        query = String.format(query, booleanBinds.toArray());
        AQProcessor.executeQuery(model, query, binds);
    }

    public static void dropTransactionalEventQueue(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("dropteq", model.getConnection());
        if (!AQProcessor.containsParameter(model, "name")) {
            throw new AQException(null, String.format(Messages.getString("AQEXP.MISSING_COMPULSORY"), "name".toUpperCase()));
        }
        List<Object> binds = AQProcessor.collectParams(model, "drop,transactional,event,queue");
        query = String.format(query, booleanBinds.toArray());
        AQProcessor.executeQuery(model, query, binds);
    }

    public static void enqueue(AQModel model) throws InvalidParameterException, IOException, JsonParsingException, AQException {
        AQParams payloadParam;
        if (!AQProcessor.containsParameter(model, "name")) {
            throw new AQException(null, String.format(Messages.getString("AQEXP.MISSING_COMPULSORY"), "name".toUpperCase()));
        }
        if (!AQProcessor.containsParameter(model, "payload") && !AQProcessor.containsParameter(model, "filename")) {
            throw new AQException(null, String.format(Messages.getString("AQEXP.MISSING_COMPULSORY"), "payload".toUpperCase() + " OR " + "filename".toUpperCase()));
        }
        boolean isSenderPresent = false;
        Object senderVal = null;
        Integer payloadType = AQOptions.JSON_MAPPING;
        if (AQProcessor.containsParameter(model, "sender_id")) {
            String senderQuery = AQProcessor.getQuery("enqaddsub", model.getConnection());
            ArrayList<Object> senderBinds = new ArrayList<Object>();
            AQParams senderParam = new AQParams("sender_id", AQParams.ParameterType.STRING, null);
            senderVal = AQProcessor.getParameter(model, senderParam);
            senderBinds.add(senderVal);
            senderQuery = String.format(senderQuery, (String)senderVal);
            AQProcessor.executeQuery(model, senderQuery, senderBinds);
            isSenderPresent = true;
        }
        String query = AQProcessor.getQuery("enq", model.getConnection());
        query = isSenderPresent ? String.format(query, "aq$_sender" + (String)senderVal) : String.format(query, "NULL");
        List<Object> binds = AQProcessor.collectParams(model, "enqueue");
        if (AQProcessor.containsParameter(model, "payload_type")) {
            payloadParam = new AQParams("payload_type", AQParams.ParameterType.STRING, null);
            String payloadTy = (String)AQProcessor.getParameter(model, payloadParam);
            if (AQOptions.payloadTypes.containsKey(payloadTy.toLowerCase())) {
                payloadType = AQOptions.payloadTypes.get(payloadTy.toLowerCase());
            } else {
                throw new AQException(null, String.format(Messages.getString("AQEXP.INVALID_PAYLOAD"), payloadTy.toUpperCase()));
            }
        }
        if (AQProcessor.containsParameter(model, "payload")) {
            payloadParam = new AQParams("payload", AQParams.ParameterType.STRING, null);
            String payload = (String)AQProcessor.getParameter(model, payloadParam);
            AQProcessor.bindPayload(payload, binds, payloadType);
        } else if (AQProcessor.containsParameter(model, "filename")) {
            AQParams fileNameParam = new AQParams("filename", AQParams.ParameterType.STRING, null);
            String fileName = (String)AQProcessor.getParameter(model, fileNameParam);
            File file = new File(fileName);
            if (file.exists()) {
                Path filepath = Path.of(fileName, new String[0]);
                String payload = Files.readString(filepath);
                AQProcessor.bindPayload(payload, binds, payloadType);
            } else {
                throw new AQException(null, String.format(Messages.getString("AQEXP.INVALID_FILE"), fileName.toUpperCase()));
            }
        }
        OracleCallableStatement enqueueStatement = null;
        if (LockManager.lock((Connection)model.getConnection())) {
            try {
                enqueueStatement = (OracleCallableStatement)model.getConnection().prepareCall(query);
                AQProcessor.bind(enqueueStatement, binds);
                enqueueStatement.registerOutParameter(binds.size() + 1, (SQLType)OracleType.RAW);
                enqueueStatement.executeUpdate();
                RAW msg_id = enqueueStatement.getRAW(binds.size() + 1);
                if (AQProcessor.containsParameter(model, "out_message_id")) {
                    AQParams messageIdParam = new AQParams("out_message_id", AQParams.ParameterType.STRING, null);
                    String messageIdBind = (String)AQProcessor.getParameter(model, messageIdParam);
                    if (messageIdBind == null) {
                        System.out.println("Message ID : " + msg_id.stringValue());
                    } else {
                        if (messageIdBind.charAt(0) == ':') {
                            messageIdBind = messageIdBind.substring(1);
                        }
                        if (model.getContext().getVarMap().containsKey(messageIdBind.toUpperCase())) {
                            Bind msgIdBind = (Bind)model.getContext().getVarMap().get(messageIdBind.toUpperCase());
                            msgIdBind.setValue(msg_id.stringValue());
                            model.getContext().getVarMap().put(messageIdBind.toUpperCase(), msgIdBind);
                        } else {
                            System.out.println("Message ID : " + msg_id.stringValue());
                        }
                    }
                }
            }
            catch (SQLException e) {
                throw new AQException(null, String.format(e.getMessage(), new Object[0]));
            }
            finally {
                if (enqueueStatement != null) {
                    try {
                        enqueueStatement.close();
                    }
                    catch (SQLException e) {
                        throw new AQException(null, String.format(e.getMessage(), new Object[0]));
                    }
                }
                LockManager.unlock((Connection)model.getConnection());
            }
        }
    }

    public static void removeSubscriber(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("removesub", model.getConnection());
        if (!AQProcessor.containsParameter(model, "name")) {
            throw new AQException(null, String.format(Messages.getString("AQEXP.MISSING_COMPULSORY"), "name".toUpperCase()));
        }
        if (!AQProcessor.containsParameter(model, "queue_name")) {
            throw new AQException(null, String.format(Messages.getString("AQEXP.MISSING_COMPULSORY"), "queue_name".toUpperCase()));
        }
        AQProcessor.executeQuery(model, query, AQProcessor.collectParams(model, "remove,subscriber"));
    }

    public static void startQueue(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("startq", model.getConnection());
        if (!AQProcessor.containsParameter(model, "name")) {
            throw new AQException(null, String.format(Messages.getString("AQEXP.MISSING_COMPULSORY"), "name".toUpperCase()));
        }
        List<Object> binds = AQProcessor.collectParams(model, "start,queue");
        query = String.format(query, booleanBinds.toArray());
        AQProcessor.executeQuery(model, query, binds);
    }

    public static void stopQueue(AQModel model) throws InvalidParameterException, AQException {
        String query = AQProcessor.getQuery("stopq", model.getConnection());
        if (!AQProcessor.containsParameter(model, "name")) {
            throw new AQException(null, String.format(Messages.getString("AQEXP.MISSING_COMPULSORY"), "name".toUpperCase()));
        }
        List<Object> binds = AQProcessor.collectParams(model, "stop,queue");
        query = String.format(query, booleanBinds.toArray());
        AQProcessor.executeQuery(model, query, binds);
    }
}

