/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.control;

import javafx.animation.Timeline;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.shape.Ellipse;
import javafx.util.Duration;
import oracle.dbtools.raptor.metrics.control.AreaComponent;

public class EllipseComponent
extends AreaComponent {
    private final Ellipse ellipse;

    public EllipseComponent(Ellipse ellipse) {
        this.ellipse = ellipse;
    }

    @Override
    public double getHeight() {
        return 2.0 * this.ellipse.getRadiusY();
    }

    @Override
    public double getWidth() {
        return 2.0 * this.ellipse.getRadiusX();
    }

    @Override
    public void setHeight(double d) {
        this.ellipse.setRadiusY(0.5 * d);
    }

    @Override
    public void setWidth(double d) {
        this.ellipse.setRadiusX(0.5 * d);
    }

    public Ellipse getNode() {
        return this.ellipse;
    }

    @Override
    protected void doMove() {
        this.ellipse.setCenterX(this.getCenterX());
        this.ellipse.setCenterY(this.getCenterY());
    }

    @Override
    protected void doAnimate(Timeline timeline, Duration duration, EventHandler<ActionEvent> eventHandler) {
        this.addKeyFrame(timeline, duration, this.ellipse.centerXProperty(), this.getCenterX());
        this.addKeyFrame(timeline, duration, eventHandler, this.ellipse.centerYProperty(), this.getCenterY());
    }
}

