/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.ChoiceBox;
import javafx.util.Duration;
import oracle.dbtools.raptor.metrics.MetricsResources;
import oracle.dbtools.raptor.metrics.control.ChoiceAction;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.engine.DXListenerList;
import oracle.dbtools.raptor.metrics.engine.DXService;
import oracle.dbtools.raptor.metrics.facet.Monitor;
import oracle.dbtools.raptor.metrics.panel.ConnectionNameAttribute;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.InstanceListener;

public class JobIntervalMonitor
implements Monitor {
    private Context context;
    private final StringProperty jobPathProperty = new SimpleStringProperty();
    private final StringProperty connectionTypeNameProperty = new SimpleStringProperty();
    private final StringProperty intervalsProperty = new SimpleStringProperty();

    public JobIntervalMonitor() {
        this.init(new Listener());
    }

    public String getJobPath() {
        return (String)this.jobPathProperty.get();
    }

    public void setJobPath(String string) {
        this.jobPathProperty.set((Object)string);
    }

    public StringProperty jobPathProperty() {
        return this.jobPathProperty;
    }

    public String getConnectionTypeName() {
        return (String)this.connectionTypeNameProperty.get();
    }

    public void setConnectionTypeName(String string) {
        this.connectionTypeNameProperty.set((Object)string);
    }

    public StringProperty connectionTypeNameProperty() {
        return this.connectionTypeNameProperty;
    }

    public String getIntervals() {
        return (String)this.intervalsProperty.get();
    }

    public void setIntervals(String string) {
        this.intervalsProperty.set((Object)string);
    }

    public StringProperty intervalsProperty() {
        return this.intervalsProperty;
    }

    @Override
    public Class<?> getBindToClass() {
        return ChoiceAction.class;
    }

    private void initializeUI() {
        ChoiceAction choiceAction = this.context.getLinkedTarget(ChoiceAction.class, this);
        ChoiceBox choiceBox = this.getIntervals().split("\\s*,\\s*");
        ArrayList<FormattedDuration> arrayList = new ArrayList<FormattedDuration>();
        for (String string : choiceBox) {
            Duration duration = string.equalsIgnoreCase("off") ? Duration.INDEFINITE : Duration.valueOf((String)string);
            arrayList.add(new FormattedDuration(duration));
        }
        Collections.sort(arrayList);
        ChoiceBox choiceBox2 = choiceAction.getChoiceBox();
        choiceBox2.getItems().addAll(arrayList);
    }

    private void initializeSelectionUsingJobProperty(Context context) {
        URI uRI = DXIds.newId(this.getConnectionTypeName(), ConnectionNameAttribute.get(context), this.getJobPath());
        Platform.runLater(() -> DXService.getProperty(uRI, Double.class, "minimumInterval", (dXError, d) -> Platform.runLater(() -> {
            if (d != null) {
                this.initializeSelection(context, (double)d);
            } else {
                this.initializeSelectionUsingJobProperty(context);
            }
        })));
    }

    private void initializeSelection(Context context, double d) {
        ChoiceAction choiceAction = context.getLinkedTarget(ChoiceAction.class, this);
        ChoiceBox choiceBox = choiceAction.getChoiceBox();
        boolean bl = false;
        if (d > 0.0) {
            Duration duration = Duration.seconds((double)d);
            for (Duration duration2 : choiceBox.getItems()) {
                if (duration.compareTo(duration2) > 0) continue;
                choiceBox.setValue((Object)duration2);
                bl = true;
                break;
            }
        } else {
            for (Duration duration : choiceBox.getItems()) {
                if (duration.toMillis() != Double.POSITIVE_INFINITY) continue;
                choiceBox.setValue((Object)duration);
                bl = true;
                break;
            }
        }
        if (!bl) {
            choiceBox.setValue((Object)((Duration)choiceBox.getItems().get(choiceBox.getItems().size() - 1)));
        }
        choiceBox.getSelectionModel().selectedItemProperty().addListener(observable -> {
            Duration duration = (Duration)choiceBox.getSelectionModel().selectedItemProperty().get();
            double d = duration.toMillis() == Double.POSITIVE_INFINITY ? -1.0 : duration.toSeconds();
            URI uRI = DXIds.newId(this.getConnectionTypeName(), ConnectionNameAttribute.get(context), this.getJobPath());
            DXService.setProperty(uRI, Double.class, "minimumInterval", d, dXError -> {
                if (dXError.getException() != null) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "unable to reset interval", dXError.getException());
                }
            });
        });
        choiceAction.getButton().setOnAction(actionEvent -> DXService.requestJobRun(DXIds.newId(this.getConnectionTypeName(), ConnectionNameAttribute.get(context), this.getJobPath()), dXError -> {
            if (dXError.getException() != null) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "unable to request job refresh", dXError.getException());
            }
        }));
    }

    private class FormattedDuration
    extends Duration {
        FormattedDuration(Duration duration) {
            super(duration.toMillis());
        }

        public String toString() {
            double d = this.toMillis();
            if (d == Double.POSITIVE_INFINITY) {
                return MetricsResources.getString("METRICS_JOB_INTERVAL_OFF");
            }
            if (d >= 60000.0) {
                return this.toMinutes() + " m";
            }
            if (d >= 1000.0) {
                return this.toSeconds() + " s";
            }
            return d + " ms";
        }
    }

    protected class Listener
    implements InstanceListener {
        protected Listener() {
        }

        @Override
        public void onLoad(Context context) {
            JobIntervalMonitor.this.context = context;
        }

        @Override
        public void onStart(Context context, DXListenerList dXListenerList) {
            JobIntervalMonitor.this.initializeUI();
            JobIntervalMonitor.this.initializeSelectionUsingJobProperty(context);
        }
    }
}

