/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.transformation.SortedList;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import oracle.dbtools.raptor.metrics.engine.DXListenerList;
import oracle.dbtools.raptor.metrics.facet.AbstractTableViewMonitor;
import oracle.dbtools.raptor.metrics.facet.TableCellFactory;
import oracle.dbtools.raptor.metrics.observable.DXRow;
import oracle.dbtools.raptor.metrics.panel.Context;

public class PagedTableViewMonitor
extends AbstractTableViewMonitor {
    private TableColumn<DXRow, ?> rowNoColumn;
    private final IntegerProperty pageSizeProperty = new SimpleIntegerProperty((Object)this, "pageSize", 20);
    private final IntegerProperty pageNoProperty = new SimpleIntegerProperty((Object)this, "pageNo", 0);
    private final StringProperty rowNoColumnNameProperty = new SimpleStringProperty((Object)this, "rowNoColumnName", "Row#");
    private final ObservableList<SortOrder> sortOrders = FXCollections.observableArrayList();

    public PagedTableViewMonitor() {
        this.init(new Listener());
    }

    public int getPageSize() {
        return this.pageSizeProperty.get();
    }

    public void setPageSize(int n) {
        this.pageSizeProperty.set(n);
    }

    public IntegerProperty pageSizeProperty() {
        return this.pageSizeProperty;
    }

    public int getPageNo() {
        return this.pageNoProperty.get();
    }

    public void setPageNo(int n) {
        this.pageNoProperty.set(n);
    }

    public IntegerProperty pageNoProperty() {
        return this.pageNoProperty;
    }

    public String getRowNoColumnName() {
        return (String)this.rowNoColumnNameProperty.get();
    }

    public void setRowNoColumnName(String string) {
        this.rowNoColumnNameProperty.set((Object)string);
    }

    public StringProperty rowNoColumnNameProperty() {
        return this.rowNoColumnNameProperty;
    }

    public ObservableList<SortOrder> getSortOrders() {
        return this.sortOrders;
    }

    private Map<String, Object> getItemParameters(TableView<DXRow> tableView) {
        int n = this.getPageNo();
        int n2 = this.getPageSize();
        int n3 = n * n2 + 1;
        int n4 = (n + 1) * n2;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (SortOrder sortOrder : this.sortOrders) {
            hashSet.add(sortOrder.columnIndex);
        }
        ArrayList<SortOrder> arrayList = new ArrayList<SortOrder>((Collection<SortOrder>)this.sortOrders);
        for (int i = 0; i < tableView.getColumns().size(); ++i) {
            if (hashSet.contains(i)) continue;
            arrayList.add(new SortOrder(i, TableColumn.SortType.DESCENDING));
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getRowNoColumnName();
        boolean bl = true;
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            String string2;
            TableCellFactory<TableCell<DXRow, Object>> tableCellFactory;
            SortOrder sortOrder = (SortOrder)object.next();
            if (sortOrder.columnIndex < 0 || (tableCellFactory = this.getCellFactory((TableColumn<DXRow, Object>)((TableColumn)tableView.getColumns().get(sortOrder.columnIndex)))) == null || (string2 = tableCellFactory.getValueColumn()).equals(string)) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            if (sortOrder.sortType == TableColumn.SortType.ASCENDING) {
                stringBuilder.append('+');
            } else {
                stringBuilder.append('-');
            }
            stringBuilder.append(tableCellFactory.getValueColumn());
        }
        object = new HashMap();
        object.put("minRowNo", n3);
        object.put("maxRowNo", n4);
        object.put("orderBy", stringBuilder);
        return object;
    }

    private void setupTableViewSorting(TableView<DXRow> tableView) {
        SortedList sortedList = new SortedList(this.getItem().valueProperty());
        tableView.setItems((ObservableList)sortedList);
        sortedList.comparatorProperty().bind((ObservableValue)tableView.comparatorProperty());
        tableView.getSortOrder().clear();
        for (SortOrder sortOrder : this.sortOrders) {
            if (sortOrder.columnIndex < 0) continue;
            ((TableColumn)tableView.getColumns().get(sortOrder.columnIndex)).setSortType(sortOrder.sortType);
            tableView.getSortOrder().add((Object)((TableColumn)tableView.getColumns().get(sortOrder.columnIndex)));
        }
        sortedList.comparatorProperty().unbind();
        sortedList.comparatorProperty().set((dXRow, dXRow2) -> {
            long l = (Long)dXRow.get(this.getRowNoColumnName(), Long.class).get();
            long l2 = (Long)dXRow2.get(this.getRowNoColumnName(), Long.class).get();
            return Long.compare(l, l2);
        });
    }

    private void setupTableViewSortingUpdates(Context context, TableView<DXRow> tableView) {
        tableView.applyCss();
        tableView.layout();
        Set set = tableView.lookupAll(".column-header");
        for (Node node : set) {
            int n;
            TableColumnBase<DXRow, ?> tableColumnBase = this.getTableColumnBaseFromSkin(node);
            if (tableColumnBase == null || tableColumnBase == this.rowNoColumn || !tableColumnBase.isSortable() || (n = tableView.getColumns().indexOf(tableColumnBase)) < 0) continue;
            node.addEventFilter(MouseEvent.MOUSE_CLICKED, mouseEvent -> {
                if (!mouseEvent.isConsumed()) {
                    this.processHeaderMouseClick(context, n, (MouseEvent)mouseEvent);
                }
            });
        }
    }

    private void processHeaderMouseClick(Context context, int n, MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == MouseButton.PRIMARY) {
            SortOrder sortOrder = null;
            for (SortOrder sortOrder2 : this.sortOrders) {
                if (n != sortOrder2.columnIndex) continue;
                sortOrder = sortOrder2;
                break;
            }
            if (sortOrder == null) {
                SortOrder sortOrder3 = new SortOrder(n, TableColumn.SortType.DESCENDING);
                if (!mouseEvent.isShiftDown()) {
                    this.sortOrders.clear();
                    this.sortOrders.add((Object)new SortOrder(-1, TableColumn.SortType.ASCENDING));
                }
                this.sortOrders.add((Object)sortOrder3);
            } else {
                int n2 = this.sortOrders.indexOf(sortOrder);
                switch (sortOrder.sortType) {
                    case DESCENDING: {
                        SortOrder sortOrder2;
                        sortOrder2 = new SortOrder(n, TableColumn.SortType.ASCENDING);
                        this.sortOrders.set(n2, (Object)sortOrder2);
                        break;
                    }
                    case ASCENDING: {
                        this.sortOrders.remove(n2);
                    }
                }
            }
            context.restartDataStreaming();
            mouseEvent.consume();
        }
    }

    private void initializeDynamicItemParameters(Map<String, Object> map) {
        ObservableMap<String, Object> observableMap = this.getItem().getQueryParameters();
        for (String string : map.keySet()) {
            observableMap.put((Object)string, (Object)map.get(string).toString());
        }
    }

    private TableColumnBase<DXRow, ?> getTableColumnBaseFromSkin(Node node) {
        TableColumnBase tableColumnBase = null;
        try {
            Class<?> clazz = node.getClass();
            Method method = clazz.getMethod("getTableColumn", new Class[0]);
            tableColumnBase = (TableColumnBase)method.invoke((Object)node, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "unable to obtain tableColumnBase", exception);
        }
        return tableColumnBase;
    }

    protected class Listener
    extends AbstractTableViewMonitor.Listener {
        protected Listener() {
        }

        @Override
        public void onOpen(Context context) {
            super.onOpen(context);
            TableView<DXRow> tableView = PagedTableViewMonitor.this.getTableView();
            if (tableView != null) {
                for (TableColumn tableColumn : tableView.getColumns()) {
                    TableCellFactory<TableCell<DXRow, Object>> tableCellFactory = PagedTableViewMonitor.this.getCellFactory((TableColumn<DXRow, Object>)tableColumn);
                    if (tableCellFactory == null || !PagedTableViewMonitor.this.getRowNoColumnName().equals(tableCellFactory.getValueColumn())) continue;
                    PagedTableViewMonitor.this.rowNoColumn = tableColumn;
                    break;
                }
                PagedTableViewMonitor.this.bindTableView(context, tableView);
                PagedTableViewMonitor.this.setupTableViewSortingUpdates(context, tableView);
            }
        }

        @Override
        public void onStart(Context context, DXListenerList dXListenerList) {
            TableView tableView = context.getLinkedTarget(TableView.class, PagedTableViewMonitor.this);
            if (tableView != null) {
                if (PagedTableViewMonitor.this.sortOrders.isEmpty()) {
                    for (TableColumn tableColumn : tableView.getSortOrder()) {
                        PagedTableViewMonitor.this.sortOrders.add((Object)new SortOrder(-1, TableColumn.SortType.DESCENDING));
                        if (tableColumn == PagedTableViewMonitor.this.rowNoColumn || !tableColumn.isSortable()) continue;
                        int n = tableView.getColumns().indexOf((Object)tableColumn);
                        PagedTableViewMonitor.this.sortOrders.add((Object)new SortOrder(n, tableColumn.getSortType()));
                    }
                } else {
                    tableView.getSortOrder().clear();
                    for (SortOrder sortOrder : PagedTableViewMonitor.this.sortOrders) {
                        if (sortOrder.columnIndex < 0) continue;
                        TableColumn tableColumn = (TableColumn)tableView.getColumns().get(sortOrder.columnIndex);
                        tableColumn.setSortType(sortOrder.sortType);
                        tableView.getSortOrder().add((Object)tableColumn);
                    }
                }
                PagedTableViewMonitor.this.initializeDynamicItemParameters(PagedTableViewMonitor.this.getItemParameters((TableView<DXRow>)tableView));
                PagedTableViewMonitor.this.setupTableViewSorting((TableView<DXRow>)tableView);
            }
        }
    }

    public static class SortOrder {
        private final int columnIndex;
        private final TableColumn.SortType sortType;

        public SortOrder(int n, TableColumn.SortType sortType) {
            this.columnIndex = n;
            this.sortType = sortType;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public TableColumn.SortType getSortType() {
            return this.sortType;
        }
    }
}

