/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstAliasExpressionsList;
import com.adbs.ast.AstNode;
import com.adbs.ast.AstNodeBase;
import com.adbs.ast.AstNodeVisitor;
import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataField;
import com.adbs.ast.MetadataFieldList;
import com.adbs.ast.PrepareAndFixupParam;
import com.adbs.ast.SQLDatabaseObject;
import com.adbs.ast.SQLExpressionBetween;
import com.adbs.ast.SQLExpressionColumn;
import com.adbs.ast.SQLExpressionInSet;
import com.adbs.ast.SQLExpressionItem;
import com.adbs.ast.SQLExpressionLikeTemplate;
import com.adbs.ast.SQLExpressionOperatorBinary;
import com.adbs.ast.SQLExpressionParameter;
import com.adbs.ast.SQLFromFunction;
import com.adbs.ast.SQLFromGroup;
import com.adbs.ast.SQLFromObject;
import com.adbs.ast.SQLFromSource;
import com.adbs.ast.SQLObjectColumn;
import com.adbs.ast.SQLOrderByClause;
import com.adbs.ast.SQLOrderByItem;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLSelectItem;
import com.adbs.ast.SQLSelectItemAllColumns;
import com.adbs.ast.SQLSelectItemAllTableColumns;
import com.adbs.ast.SQLSelectItemExpression;
import com.adbs.ast.SQLSubQueryExpressions;
import com.adbs.ast.SQLSubQuerySelectExpression;
import com.adbs.ast.SQLSubSelectStatement;
import com.adbs.ast.SQLWithClause;
import com.adbs.ast.SQLWithClauseItem;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PrepareAndFixupVisitor
extends AstNodeVisitor {
    private ArrayList withClauseItemList;
    private ArrayList fromSourcesList;
    private ArrayList orderByAlias;
    private boolean calcFieldUsageStats;

    public PrepareAndFixupVisitor(boolean calcFieldUsageStats) {
        this.calcFieldUsageStats = calcFieldUsageStats;
    }

    private SQLObjectColumn findColumnNameInExpression(SQLExpressionItem expression) {
        SQLExpressionItem ei = Helpers.expressionRemoveBrackets(expression);
        if (ei != null && ei instanceof SQLExpressionColumn && ((SQLExpressionColumn)ei).column != null) {
            return ((SQLExpressionColumn)ei).column;
        }
        return null;
    }

    private void addSelectExpressionColumn(SQLSubQuerySelectExpression unionSubQuery, SQLSelectItemExpression selectItem) {
        SQLObjectColumn c = this.findColumnNameInExpression(selectItem.expression);
        if (c != null) {
            MetadataField f;
            if (c.datasource != null) {
                int i = c.datasource.getFieldList().findFieldByName(c);
                if (i != -1) {
                    f = unionSubQuery.fieldList.add();
                    f.assign(c.datasource.getFieldList().get(i));
                } else {
                    f = unionSubQuery.fieldList.addField(c);
                }
            } else {
                f = unionSubQuery.fieldList.addField(c);
            }
            f.setExpression("");
            if (selectItem.alias != null) {
                f.getName().clear();
                f.getName().addName(selectItem.alias.alias.clone(f.getSQLContext()));
            }
        } else if (selectItem.alias != null) {
            unionSubQuery.fieldList.addField(selectItem.alias.alias);
        }
    }

    private void addAllColumnsOfFromSource(SQLSubQuerySelectExpression unionSubQuery, SQLFromSource fs) {
        for (int i = 0; i < fs.getFieldList().getCount(); ++i) {
            MetadataField mf = fs.getFieldList().get(i);
            if (mf.isVirtualCalculatedField()) continue;
            MetadataField fi = unionSubQuery.fieldList.add();
            fi.assign(mf);
        }
    }

    private void addAllColumnsOfFromItem(SQLSubQuerySelectExpression unionSubQuery, SQLFromGroup fi) {
        for (int i = 0; i < fi.getCount(); ++i) {
            SQLFromSource fs = fi.get(i);
            if (fs instanceof SQLFromGroup) {
                this.addAllColumnsOfFromItem(unionSubQuery, (SQLFromGroup)fs);
                continue;
            }
            this.addAllColumnsOfFromSource(unionSubQuery, fs);
        }
    }

    private void fixupUnionSubQuery(SQLSubQuerySelectExpression unionSubQuery) {
        unionSubQuery.fieldList.clear();
        if (unionSubQuery.selectItems != null) {
            for (int i = 0; i < unionSubQuery.selectItems.getCount(); ++i) {
                SQLSelectItem si = unionSubQuery.selectItems.get(i);
                if (si instanceof SQLSelectItemExpression) {
                    this.addSelectExpressionColumn(unionSubQuery, (SQLSelectItemExpression)si);
                    continue;
                }
                if (si instanceof SQLSelectItemAllTableColumns && unionSubQuery.from != null && ((SQLSelectItemAllTableColumns)si).databaseObject != null && ((SQLSelectItemAllTableColumns)si).databaseObject.datasource != null) {
                    this.addAllColumnsOfFromSource(unionSubQuery, ((SQLSelectItemAllTableColumns)si).databaseObject.datasource);
                    continue;
                }
                if (!(si instanceof SQLSelectItemAllColumns) || unionSubQuery.from == null) continue;
                this.addAllColumnsOfFromItem(unionSubQuery, unionSubQuery.from);
            }
        }
    }

    private void fixupWithItem(SQLWithClauseItem withItem) throws QueryBuilderException {
        withItem.fieldList.clear();
        if (withItem.subQuery != null) {
            SQLSubQuerySelectExpression usq = withItem.subQuery.firstUnionSubQuery();
            withItem.fieldList.assign(usq.fieldList);
        }
        if (withItem.columnNamesList != null) {
            for (int i = 0; i < withItem.columnNamesList.getCount(); ++i) {
                MetadataField f = i < withItem.fieldList.getCount() ? withItem.fieldList.get(i) : withItem.fieldList.add();
                f.setNameAlias(withItem.columnNamesList.get(i));
            }
        }
    }

    private void fixupFromItem(SQLFromSource fromItem, Object nodeParam) throws QueryBuilderException {
        fromItem.calcFieldList(((PrepareAndFixupParam)nodeParam).cteItems, ((PrepareAndFixupParam)nodeParam).fromItems, this.calcFieldUsageStats);
        AstAliasExpressionsList colNames = fromItem.columnNamesList;
        if (colNames != null) {
            for (int i = 0; i < colNames.getCount(); ++i) {
                MetadataField f = i < fromItem.getFieldList().getCount() ? fromItem.getFieldList().get(i) : fromItem.getFieldList().add();
                f.setNameAlias(colNames.get(i));
            }
        }
    }

    private void fixupFromObject(SQLFromObject fromObject, Object nodeParam) throws QueryBuilderException {
        fromObject.setCTEObject(null);
        if (fromObject.getMetadataObject() != null) {
            fromObject.setMetadataObject(null);
        }
        MetadataContainer mc = fromObject.getSQLContext().getMetadataContainer();
        for (int i = ((PrepareAndFixupParam)nodeParam).cteItems.size() - 1; i >= 0; --i) {
            if (fromObject.fromObj == null || fromObject.fromObj.getCount() != 1 || !(fromObject.fromObj.get(0) instanceof AstTokenIdentifier) || fromObject.getSQLContext().compareIdentifiers(((SQLWithClauseItem)((PrepareAndFixupParam)nodeParam).cteItems.get((int)i)).name, (AstTokenIdentifier)fromObject.fromObj.get(0)) != 0) continue;
            fromObject.setCTEObject((SQLWithClauseItem)((PrepareAndFixupParam)nodeParam).cteItems.get(i));
            break;
        }
        if (fromObject.getCTEObject() == null) {
            if (fromObject.fromObj.getCount() == 1 && fromObject.fromObj.get(0) instanceof AstTokenIdentifier) {
                fromObject.setMetadataObject(mc.findObjectByAltName((AstTokenIdentifier)fromObject.fromObj.get(0)));
            }
            if (fromObject.getMetadataObject() == null) {
                fromObject.setMetadataObject(mc.findObjectByFullName(fromObject.fromObj));
            }
        }
        this.fixupFromItem(fromObject, nodeParam);
        if (fromObject.fromObj != null) {
            fromObject.fromObj.datasource = fromObject;
        }
    }

    private void fixupObjectName(SQLDatabaseObject objectName, Object nodeParam) {
        SQLFromSource fs;
        int i;
        if (objectName.datasource != null) {
            return;
        }
        for (i = ((PrepareAndFixupParam)nodeParam).fromItems.size() - 1; i >= 0; --i) {
            fs = (SQLFromSource)((PrepareAndFixupParam)nodeParam).fromItems.get(i);
            if (objectName.getCount() == 1 && fs.alias != null && objectName.get(0) instanceof AstTokenIdentifier && fs.alias.alias != null && objectName.sqlContext.compareIdentifiers(fs.alias.alias, (AstTokenIdentifier)objectName.get(0)) == 0) {
                objectName.datasource = fs;
            } else if (fs.alias == null && objectName.getCount() == 1 && objectName.get(0) instanceof AstTokenIdentifier && fs.getMetadataObject() != null && !Str.IsNullOrEmpty(fs.getMetadataObject().getAltName()) && this.isAltNameToken((AstTokenIdentifier)objectName.get(0), fs.getMetadataObject().getAltNameId())) {
                objectName.datasource = fs;
            } else if (fs instanceof SQLFromObject && fs.alias == null && objectName.sqlContext.isQualifiedNamesEqual(((SQLFromObject)fs).fromObj, objectName)) {
                objectName.datasource = fs;
            } else if (fs instanceof SQLFromFunction && fs.alias == null && objectName.sqlContext.isQualifiedNamesEqual(((SQLFromFunction)fs).name, objectName)) {
                objectName.datasource = fs;
            }
            if (objectName.datasource != null) break;
        }
        if (objectName.datasource == null) {
            for (i = ((PrepareAndFixupParam)nodeParam).fromItems.size() - 1; i >= 0; --i) {
                fs = (SQLFromSource)((PrepareAndFixupParam)nodeParam).fromItems.get(i);
                if (fs instanceof SQLFromObject && objectName.sqlContext.isQualifiedNamesEqual(((SQLFromObject)fs).fromObj, objectName)) {
                    objectName.datasource = fs;
                } else if (fs instanceof SQLFromFunction && objectName.sqlContext.isQualifiedNamesEqual(((SQLFromFunction)fs).name, objectName)) {
                    objectName.datasource = fs;
                }
                if (objectName.datasource != null) break;
            }
        }
        if (objectName.datasource != null) {
            objectName.clear();
        }
    }

    private void fixupFromFunction(SQLFromFunction fromFunction, Object nodeParam) {
        if (fromFunction.getMetadataObject() != null) {
            fromFunction.setMetadataObject(null);
        }
        MetadataContainer mc = fromFunction.sqlContext.getMetadataContainer();
        if (fromFunction.name.getCount() == 1 && fromFunction.name.get(0) instanceof AstTokenIdentifier) {
            fromFunction.setMetadataObject(mc.findObjectByAltName(this.getUnquotedIdentifierString((AstTokenIdentifier)fromFunction.name.get(0))));
        }
        if (fromFunction.getMetadataObject() == null) {
            fromFunction.setMetadataObject(mc.findObjectByFullName(fromFunction.name));
        }
        this.fixupFromItem(fromFunction, nodeParam);
        if (fromFunction.name != null) {
            fromFunction.name.datasource = fromFunction;
        }
    }

    private void fixupColumnName(SQLObjectColumn columnName, Object nodeParam) {
        int j;
        int prefixesToRemove;
        SQLFromSource fs;
        int i;
        if (this.isOrderByAliasItem(columnName)) {
            return;
        }
        BaseSyntaxProvider sp = columnName.getSQLContext().getSyntaxProvider();
        assert (sp != null);
        for (i = ((PrepareAndFixupParam)nodeParam).fromItems.size() - 1; i >= 0; --i) {
            fs = (SQLFromSource)((PrepareAndFixupParam)nodeParam).fromItems.get(i);
            if (columnName.getCount() == 1 & fs.getFieldList().getCount() == 0) break;
            if (columnName.getCount() > 1 && fs.alias != null && columnName.get(columnName.getCount() - 1) instanceof AstTokenIdentifier && columnName.getSQLContext().compareIdentifiers(fs.alias.alias, (AstTokenIdentifier)columnName.get(columnName.getCount() - 1)) == 0) {
                columnName.removeFirstPrefix();
                columnName.datasource = fs;
                break;
            }
            if (fs.alias == null && columnName.getCount() == 2 && columnName.get(columnName.getCount() - 1) instanceof AstTokenIdentifier && fs.getMetadataObject() != null && !Str.IsNullOrEmpty(fs.getMetadataObject().getAltName()) && this.isAltNameToken((AstTokenIdentifier)columnName.get(columnName.getCount() - 1), fs.getMetadataObject().getAltNameId())) {
                columnName.removeFirstPrefix();
                columnName.datasource = fs;
                break;
            }
            if (fs.alias == null && fs instanceof SQLFromObject && ((SQLFromObject)fs).fromObj != null && ((SQLFromObject)fs).fromObj.getCount() > 0 && ((SQLFromObject)fs).fromObj.get(0) instanceof AstTokenIdentifier && columnName.getCount() == 2 && columnName.get(columnName.getCount() - 1) instanceof AstTokenIdentifier && columnName.sqlContext.compareIdentifiers((AstTokenIdentifier)((SQLFromObject)fs).fromObj.get(0), (AstTokenIdentifier)columnName.get(columnName.getCount() - 1)) == 0) {
                columnName.removeFirstPrefix();
                columnName.datasource = fs;
                break;
            }
            if (columnName.getCount() > 1 && fs instanceof SQLFromObject && fs.alias == null) {
                prefixesToRemove = sp.isColumnOfDBObject(columnName, ((SQLFromObject)fs).fromObj);
                if (prefixesToRemove >= 0) {
                    for (j = 0; j < prefixesToRemove; ++j) {
                        columnName.removeFirstPrefix();
                    }
                    columnName.dbLink = null;
                    columnName.datasource = fs;
                    break;
                }
                if (sp.findFieldInFieldList(columnName, fs.getFieldList()) == -1) continue;
                columnName.datasource = fs;
                break;
            }
            if (sp.findFieldInFieldList(columnName, fs.getFieldList()) == -1) continue;
            columnName.datasource = fs;
            break;
        }
        if (columnName.datasource == null) {
            for (i = ((PrepareAndFixupParam)nodeParam).fromItems.size() - 1; i >= 0; --i) {
                fs = (SQLFromSource)((PrepareAndFixupParam)nodeParam).fromItems.get(i);
                if (columnName.getCount() > 1 && fs.alias != null && columnName.get(columnName.getCount() - 1) instanceof AstTokenIdentifier && fs.getMetadataObject() != null && !Str.IsNullOrEmpty(fs.getMetadataObject().getAltName()) && fs.getMetadataObject().getAltName().toUpperCase().equals(columnName.get(columnName.getCount() - 1).getToken().toUpperCase())) {
                    columnName.removeFirstPrefix();
                    columnName.datasource = fs;
                    break;
                }
                if (fs.alias != null && fs instanceof SQLFromObject && ((SQLFromObject)fs).fromObj != null && ((SQLFromObject)fs).fromObj.getCount() > 0 && ((SQLFromObject)fs).fromObj.get(0) instanceof AstTokenIdentifier && columnName.getCount() == 2 && columnName.get(columnName.getCount() - 1) instanceof AstTokenIdentifier && columnName.sqlContext.compareIdentifiers((AstTokenIdentifier)((SQLFromObject)fs).fromObj.get(0), (AstTokenIdentifier)columnName.get(columnName.getCount() - 1)) == 0) {
                    columnName.removeFirstPrefix();
                    columnName.datasource = fs;
                    break;
                }
                if (columnName.getCount() <= 1 || !(fs instanceof SQLFromObject) || fs.alias == null || (prefixesToRemove = sp.isColumnOfDBObject(columnName, ((SQLFromObject)fs).fromObj)) < 0) continue;
                for (j = 0; j < prefixesToRemove; ++j) {
                    columnName.removeFirstPrefix();
                }
                if (columnName.dbLink != null) {
                    columnName.dbLink.dispose();
                    columnName.dbLink = null;
                }
                columnName.datasource = fs;
                break;
            }
        }
        if (columnName.datasource != null && (i = sp.findFieldInFieldList(columnName, columnName.datasource.getFieldList())) != -1) {
            columnName.assign(columnName.datasource.getFieldList().get(i).getName());
            columnName.setMetadataField(columnName.datasource.getFieldList().get(i));
        }
    }

    private void loadParameterProps(SQLExpressionParameter param, String operator, SQLObjectColumn column, MetadataContainer metadataContainer) {
        param.setCompareOperator(operator);
        if (column != null) {
            if (column.datasource != null) {
                if (column.datasource.alias != null) {
                    param.setComparedObject(column.datasource.alias.alias.getSimpleSQL(column.getSQLContext().getSQLBuilderExpressionForServer()));
                } else if (column.datasource instanceof SQLFromObject) {
                    param.setComparedObject(((SQLFromObject)column.datasource).fromObj.getSimpleSQL(column.getSQLContext().getSQLBuilderExpressionForServer()));
                } else if (column.datasource instanceof SQLFromFunction) {
                    param.setComparedObject(((SQLFromFunction)column.datasource).name.getSimpleSQL(column.getSQLContext().getSQLBuilderExpressionForServer()));
                } else {
                    param.setComparedObject("");
                }
                if (column.datasource.getMetadataObject() != null) {
                    param.setMetadataObject(column.datasource.getMetadataObject());
                } else {
                    param.setMetadataObject(null);
                }
                if (column.getMetadataField() != null) {
                    param.setMetadataField(column.getMetadataField());
                } else {
                    param.setMetadataField(null);
                }
                MetadataFieldList fl = column.datasource.getFieldList();
                int i = fl.findFieldByName(column);
                if (i != -1) {
                    param.setDataType(fl.get(i).getFieldType());
                    param.setComparedField(fl.get(i).getName().getSimpleSQL(column.getSQLContext().getSQLBuilderExpressionForServer()));
                } else {
                    param.setComparedField(column.get(0).getSimpleSQL(column.getSQLContext().getSQLBuilderExpressionForServer()));
                }
            } else {
                param.setComparedField(column.get(0).getSimpleSQL(column.getSQLContext().getSQLBuilderExpressionForServer()));
            }
        }
    }

    private void fixupExpressionOperatorBinary(SQLExpressionOperatorBinary expression, Object nodeParam) {
        String op = null;
        if (expression.isLogical()) {
            SQLExpressionItem l = Helpers.expressionRemoveBrackets(expression.lExpression);
            SQLExpressionItem r = Helpers.expressionRemoveBrackets(expression.rExpression);
            if (l != null && r != null && (l instanceof SQLExpressionParameter && r instanceof SQLExpressionColumn || r instanceof SQLExpressionParameter && l instanceof SQLExpressionColumn)) {
                SQLExpressionColumn c;
                SQLExpressionParameter p;
                if (expression.operatorObj != null) {
                    op = expression.operatorObj.operatorName;
                }
                if (l instanceof SQLExpressionParameter) {
                    p = (SQLExpressionParameter)l;
                    c = (SQLExpressionColumn)r;
                    if (!(op.equals("=") || op.equals("<>") || op.equals("!="))) {
                        op = op.equals(">") ? "<" : (op.equals("<") ? ">" : (op.equals(">=") ? "<=" : (op.equals("<=") ? ">=" : "")));
                    }
                } else {
                    p = (SQLExpressionParameter)r;
                    c = (SQLExpressionColumn)l;
                }
                MetadataContainer mc = expression.getSQLContext().getMetadataContainer();
                this.loadParameterProps(p, op, c.column, mc);
            }
        }
    }

    private void fixupExpressionBetween(SQLExpressionBetween expression, Object nodeParam) {
        SQLExpressionItem l = Helpers.expressionRemoveBrackets(expression.lExpression);
        if (l != null && l instanceof SQLExpressionColumn) {
            SQLExpressionParameter p;
            MetadataContainer mc = expression.getSQLContext().getMetadataContainer();
            SQLExpressionColumn c = (SQLExpressionColumn)l;
            SQLExpressionItem r = Helpers.expressionRemoveBrackets(expression.min);
            if (r != null && r instanceof SQLExpressionParameter) {
                p = (SQLExpressionParameter)r;
                if (expression.haveNot) {
                    this.loadParameterProps(p, "<", c.column, mc);
                } else {
                    this.loadParameterProps(p, ">=", c.column, mc);
                }
            }
            if ((r = Helpers.expressionRemoveBrackets(expression.max)) != null && r instanceof SQLExpressionParameter) {
                p = (SQLExpressionParameter)r;
                if (expression.haveNot) {
                    this.loadParameterProps(p, ">", c.column, mc);
                } else {
                    this.loadParameterProps(p, "<=", c.column, mc);
                }
            }
        }
    }

    private void fixupExpressionLike(SQLExpressionLikeTemplate expression, Object nodeParam) {
        SQLExpressionItem l = Helpers.expressionRemoveBrackets(expression.lExpression);
        SQLExpressionItem r = Helpers.expressionRemoveBrackets(expression.like);
        if (l != null && r != null && l instanceof SQLExpressionColumn && r instanceof SQLExpressionParameter) {
            MetadataContainer mc = expression.getSQLContext().getMetadataContainer();
            SQLExpressionColumn c = (SQLExpressionColumn)l;
            SQLExpressionParameter p = (SQLExpressionParameter)r;
            if (expression.haveNot) {
                this.loadParameterProps(p, "Not " + expression.likeOperator, c.column, mc);
            } else {
                this.loadParameterProps(p, expression.likeOperator, c.column, mc);
            }
        }
    }

    private void fixupExpressionIn(SQLExpressionInSet expression, Object nodeParam) {
        SQLExpressionItem l = Helpers.expressionRemoveBrackets(expression.lExpression);
        for (int i = 0; i < expression.setItems.getCount(); ++i) {
            SQLExpressionItem r = Helpers.expressionRemoveBrackets(expression.setItems.get(i));
            if (l == null || r == null || !(l instanceof SQLExpressionColumn) || !(r instanceof SQLExpressionParameter)) continue;
            MetadataContainer mc = expression.getSQLContext().getMetadataContainer();
            SQLExpressionColumn c = (SQLExpressionColumn)l;
            SQLExpressionParameter p = (SQLExpressionParameter)r;
            if (expression.haveNot) {
                this.loadParameterProps(p, "Not In", c.column, mc);
                continue;
            }
            this.loadParameterProps(p, "In", c.column, mc);
        }
    }

    private SQLWithClauseItem findWithClauseItem(PrepareAndFixupParam fixupParam) {
        assert (fixupParam.node instanceof SQLSubQuerySelectExpression);
        PrepareAndFixupParam param = fixupParam;
        while (param != null) {
            AstNodeBase node = param.node;
            if (node instanceof SQLWithClauseItem) {
                return (SQLWithClauseItem)node;
            }
            if (!(node instanceof SQLSubQuerySelectExpression) && !(node instanceof SQLSubQueryExpressions)) break;
            param = param.parentParam;
        }
        return null;
    }

    @Override
    protected List getNodeChildren(AstNodeBase node, Object nodeParam, AstNodeBase parent, Object parentParam) {
        ArrayList<AstNode> result = super.getNodeChildren(node, nodeParam, parent, parentParam);
        if (node instanceof SQLSubSelectStatement) {
            int index;
            if (((SQLSubSelectStatement)node).withClause != null) {
                index = result.indexOf(((SQLSubSelectStatement)node).withClause);
                assert (index != -1);
                Helpers.listMove(result, index, 0);
            }
            if (((SQLSubSelectStatement)node).orderBy != null) {
                index = result.indexOf(((SQLSubSelectStatement)node).orderBy);
                assert (index != -1);
                Helpers.listMove(result, index, 0);
            }
        } else if (node instanceof SQLSubQuerySelectExpression) {
            SQLWithClauseItem wci;
            int index;
            if (((SQLSubQuerySelectExpression)node).from != null) {
                index = result.indexOf(((SQLSubQuerySelectExpression)node).from);
                assert (index != -1);
                Helpers.listMove(result, index, 0);
            }
            if (((SQLSubQuerySelectExpression)node).orderBy != null) {
                index = result.indexOf(((SQLSubQuerySelectExpression)node).orderBy);
                assert (index != -1);
                Helpers.listMove(result, index, result.size() - 1);
            }
            if ((wci = this.findWithClauseItem((PrepareAndFixupParam)nodeParam)) != null) {
                if (this.isWithClauseItemFirstPass(wci)) {
                    if (wci.subQuery.firstUnionSubQuery() != node) {
                        result.clear();
                    }
                } else if (wci.subQuery.firstUnionSubQuery() == node) {
                    result.clear();
                }
            }
        } else if (node instanceof SQLWithClause) {
            if (((SQLWithClause)node).getCount() > 0) {
                int i;
                for (i = 0; i < ((SQLWithClause)node).getCount(); ++i) {
                    int index = result.indexOf(((SQLWithClause)node).get(i));
                    assert (i != -1);
                    Helpers.listMove(result, index, i);
                }
                for (i = 0; i < ((SQLWithClause)node).getCount(); ++i) {
                    result.add(((SQLWithClause)node).get(i));
                }
            }
        } else if (!(node instanceof SQLWithClauseItem) && node instanceof SQLFromSource) {
            SQLFromSource fs = (SQLFromSource)node;
            if (this.isFromSourceFirstPass(fs)) {
                if (fs.joinOn != null) {
                    result.remove(fs.joinOn);
                }
                if (node instanceof SQLFromGroup && ((SQLFromGroup)node).getCount() > 0) {
                    int i;
                    for (i = 0; i < ((SQLFromGroup)node).getCount(); ++i) {
                        int index = result.indexOf(((SQLFromGroup)node).get(i));
                        assert (index != -1);
                        Helpers.listMove(result, index, i);
                    }
                    ArrayList<AstNode> l = result;
                    result = new ArrayList<AstNode>();
                    for (i = 0; i < l.size(); ++i) {
                        Object o = l.get(i);
                        result.add((AstNode)o);
                        if (!(o instanceof SQLFromSource)) continue;
                        result.add((AstNode)o);
                    }
                }
            } else {
                result.clear();
                if (fs.joinOn != null) {
                    result.add(fs.joinOn);
                }
            }
        }
        return result;
    }

    @Override
    protected Object enterIntoNode(AstNodeBase node, AstNodeBase parent, Object parentParam) {
        PrepareAndFixupParam newParam = new PrepareAndFixupParam((PrepareAndFixupParam)parentParam, node);
        try {
            if (node instanceof SQLSubSelectStatement || node instanceof SQLSubQuerySelectExpression) {
                newParam.saveCounters();
            } else if (node instanceof SQLFromObject) {
                this.structuredFixupFromObject((SQLFromObject)node);
            } else if (node instanceof SQLFromFunction) {
                this.structuredFixupFromFunction((SQLFromFunction)node);
            } else if (!(node instanceof SQLFromSource)) {
                if (node.getSQLContext().getSyntaxProvider() != null && node.getSQLContext().getSyntaxProvider().isSupportOrderByAlias() && node instanceof SQLOrderByClause) {
                    if (parent != null) {
                        SQLSubQuerySelectExpression usq;
                        SQLSubQuerySelectExpression sQLSubQuerySelectExpression = usq = parent instanceof SQLSubQuerySelectExpression && ((SQLSubQuerySelectExpression)parent).selectItems != null ? (SQLSubQuerySelectExpression)parent : null;
                        if (usq != null) {
                            newParam.loadExpressionAliases(usq.selectItems);
                        }
                    }
                } else if (node.getSQLContext().getSyntaxProvider() != null && node.getSQLContext().getSyntaxProvider().isSupportOrderByAlias() && node instanceof SQLOrderByItem && ((PrepareAndFixupParam)parentParam).aliasedSelectItems != null) {
                    assert (parent instanceof SQLOrderByClause);
                    if (this.isOrderByAlias((SQLOrderByItem)node, newParam, (SQLOrderByClause)parent, parentParam)) {
                        this.addOrderByAlias(((SQLExpressionColumn)((SQLOrderByItem)node).expression).column);
                    }
                }
            }
        }
        catch (Exception exception) {
            newParam = null;
        }
        return newParam;
    }

    @Override
    protected void exitFromNode(AstNodeBase node, Object nodeParam, AstNodeBase parent, Object parentParam) {
        super.exitFromNode(node, nodeParam, parent, parentParam);
        if (node instanceof SQLSubSelectStatement) {
            ((PrepareAndFixupParam)nodeParam).restoreCounters();
        } else if (node instanceof SQLSubQuerySelectExpression) {
            this.fixupUnionSubQuery((SQLSubQuerySelectExpression)node);
            ((PrepareAndFixupParam)nodeParam).restoreCounters();
        } else if (node instanceof SQLWithClauseItem) {
            try {
                if (this.isWithClauseItemFirstPass((SQLWithClauseItem)node)) {
                    this.withClauseItemPassed((SQLWithClauseItem)node);
                    this.fixupWithItem((SQLWithClauseItem)node);
                    ((PrepareAndFixupParam)nodeParam).cteItems.add(node);
                }
            }
            catch (QueryBuilderException ex) {
                Logger.getLogger(PrepareAndFixupVisitor.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (node instanceof SQLFromGroup) {
            this.fromSourcePassed((SQLFromGroup)node);
        } else if (node instanceof SQLFromObject) {
            try {
                if (this.isFromSourceFirstPass((SQLFromSource)node)) {
                    this.fixupFromObject((SQLFromObject)node, nodeParam);
                    ((PrepareAndFixupParam)nodeParam).addFROMItem((SQLFromSource)node);
                    this.fromSourcePassed((SQLFromSource)node);
                }
            }
            catch (QueryBuilderException ex) {
                Logger.getLogger(PrepareAndFixupVisitor.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (node instanceof SQLFromFunction) {
            try {
                if (this.isFromSourceFirstPass((SQLFromSource)node)) {
                    this.fixupFromFunction((SQLFromFunction)node, nodeParam);
                    ((PrepareAndFixupParam)nodeParam).addFROMItem((SQLFromSource)node);
                    this.fromSourcePassed((SQLFromSource)node);
                }
            }
            catch (QueryBuilderException ex) {
                Logger.getLogger(PrepareAndFixupVisitor.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (node instanceof SQLFromSource) {
            try {
                if (this.isFromSourceFirstPass((SQLFromSource)node)) {
                    this.fixupFromItem((SQLFromSource)node, nodeParam);
                    ((PrepareAndFixupParam)nodeParam).addFROMItem((SQLFromSource)node);
                    this.fromSourcePassed((SQLFromSource)node);
                }
            }
            catch (QueryBuilderException ex) {
                Logger.getLogger(PrepareAndFixupVisitor.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (node instanceof SQLObjectColumn) {
            this.fixupColumnName((SQLObjectColumn)node, nodeParam);
        } else if (node instanceof SQLDatabaseObject) {
            this.fixupObjectName((SQLDatabaseObject)node, nodeParam);
        } else if (node instanceof SQLExpressionOperatorBinary) {
            this.fixupExpressionOperatorBinary((SQLExpressionOperatorBinary)node, nodeParam);
        } else if (node instanceof SQLExpressionBetween) {
            this.fixupExpressionBetween((SQLExpressionBetween)node, nodeParam);
        } else if (node instanceof SQLExpressionLikeTemplate) {
            this.fixupExpressionLike((SQLExpressionLikeTemplate)node, nodeParam);
        } else if (node instanceof SQLExpressionInSet) {
            this.fixupExpressionIn((SQLExpressionInSet)node, nodeParam);
        }
    }

    public void fixup(AstNodeBase rootNode) throws QueryBuilderException {
        assert (rootNode != null);
        assert (rootNode.getSQLContext().getSyntaxProvider() != null);
        assert (rootNode.getSQLContext().getMetadataContainer() != null);
        this.clearDatasourceReferences(rootNode);
        PrepareAndFixupParam rootParam = new PrepareAndFixupParam(null, rootNode);
        this.visit(rootNode, rootParam);
    }

    public void fixupInContext(AstNodeBase rootNode, List cteItems, List fromItems) {
        this.clearDatasourceReferences(rootNode);
        PrepareAndFixupParam rootParam = new PrepareAndFixupParam(null, rootNode);
        rootParam.addCTEItemsFrom(cteItems);
        rootParam.addFROMItemsFrom(fromItems);
        this.visit(rootNode, rootParam);
    }

    private void withClauseItemPassed(SQLWithClauseItem withItem) {
        if (this.withClauseItemList == null) {
            this.withClauseItemList = new ArrayList();
        }
        this.withClauseItemList.add(withItem);
    }

    private boolean isWithClauseItemFirstPass(SQLWithClauseItem withItem) {
        if (this.withClauseItemList == null) {
            return true;
        }
        return this.withClauseItemList.indexOf(withItem) == -1;
    }

    private void fromSourcePassed(SQLFromSource fromSource) {
        if (this.fromSourcesList == null) {
            this.fromSourcesList = new ArrayList();
        }
        this.fromSourcesList.add(fromSource);
    }

    private boolean isFromSourceFirstPass(SQLFromSource fromSource) {
        if (this.fromSourcesList == null) {
            return true;
        }
        return this.fromSourcesList.indexOf(fromSource) == -1;
    }

    private void clearDatasourceReferences(AstNodeBase astNode) {
        assert (astNode != null);
        if (astNode instanceof SQLDatabaseObject) {
            ((SQLDatabaseObject)astNode).datasource = null;
        } else if (astNode instanceof SQLObjectColumn) {
            ((SQLObjectColumn)astNode).datasource = null;
        }
        ArrayList children = new ArrayList();
        astNode.getMyChildren(children);
        for (Object aChildren : children) {
            this.clearDatasourceReferences((AstNodeBase)aChildren);
        }
    }

    private void structuredFixupFromObject(SQLFromObject fromObject) {
        if (fromObject.fromObj != null) {
            fromObject.fromObj.datasource = fromObject;
        }
    }

    private void structuredFixupFromFunction(SQLFromFunction fromFunction) {
        if (fromFunction.name != null) {
            fromFunction.name.datasource = fromFunction;
        }
    }

    private void addOrderByAlias(SQLQualifiedName qualifiedName) {
        if (this.orderByAlias == null) {
            this.orderByAlias = new ArrayList();
        }
        this.orderByAlias.add(qualifiedName);
    }

    private boolean isOrderByAliasItem(SQLQualifiedName qualifiedName) {
        return this.orderByAlias != null && this.orderByAlias.indexOf(qualifiedName) != -1;
    }

    private boolean isOrderByAlias(SQLOrderByItem orderByItem, Object nodeParam, SQLOrderByClause orderByClause, Object orderByClauseParam) {
        if (orderByItem.expression instanceof SQLExpressionColumn && ((SQLExpressionColumn)orderByItem.expression).column.getCount() == 1 && ((SQLExpressionColumn)orderByItem.expression).column.get(0) instanceof AstTokenIdentifier) {
            AstTokenIdentifier orderByItemName = (AstTokenIdentifier)((SQLExpressionColumn)orderByItem.expression).column.get(0);
            ArrayList aliasedSelectItems = ((PrepareAndFixupParam)orderByClauseParam).aliasedSelectItems;
            assert (aliasedSelectItems != null);
            for (int i = aliasedSelectItems.size() - 1; i >= 0; --i) {
                SQLSelectItemExpression si = (SQLSelectItemExpression)aliasedSelectItems.get(i);
                if (si.alias == null || si.alias.alias == null || !(si.alias.alias instanceof AstTokenIdentifier)) continue;
                AstTokenIdentifier selectItemAlias = (AstTokenIdentifier)si.alias.alias;
                if (!orderByItem.getSQLContext().isIdentifiersEqual(orderByItemName, selectItemAlias)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAltNameToken(AstTokenIdentifier token, AstTokenIdentifier altName) {
        return token.getSQLContext().isIdentifiersEqual(token, altName);
    }

    private String getUnquotedIdentifierString(AstTokenIdentifier token) {
        if (token.getCaseSensitive()) {
            return token.getToken();
        }
        if (token.getSQLContext().getSyntaxProvider().isNonQuotedIdentifiersToUpperCase()) {
            return token.getToken().toUpperCase();
        }
        return token.getToken().toLowerCase();
    }
}

