/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.querybuilder.Link;
import com.adbs.querybuilder.LinkCardinality;
import com.adbs.querybuilder.LinkConnectToSide;
import com.adbs.querybuilder.LinkMarkStyle;
import com.adbs.querybuilder.LinkPainter;
import com.adbs.querybuilder.LinkPainterFriendlyName;
import com.adbs.querybuilder.LinkSideType;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.utils.Helpers;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import javax.swing.Icon;

@LinkPainterFriendlyName(value="Access Style")
public class LinkPainterAccess
extends LinkPainter {
    private Color linkLinesColor = Color.BLACK;
    private LinkMarkStyle markStyle = LinkMarkStyle.Access;

    public LinkPainterAccess(QueryBuilder queryBuilder) {
        super(queryBuilder);
    }

    public LinkMarkStyle getMarkStyle() {
        return this.markStyle;
    }

    public void setMarkStyle(LinkMarkStyle value) {
        if (this.markStyle != value) {
            this.markStyle = value;
            if (this.queryBuilder != null) {
                this.queryBuilder.doUpdateControlParams();
            }
        }
    }

    public Color getLinkColor() {
        return this.linkLinesColor;
    }

    public void setLinkColor(Color value) {
        if (this.linkLinesColor != value) {
            this.linkLinesColor = value;
            if (this.queryBuilder != null) {
                this.queryBuilder.doUpdateControlParams();
            }
        }
    }

    protected void paintEndMark(Graphics g, int startX, int startY, int endX, int endY, LinkConnectToSide side, LinkSideType linkType) {
        int factor = side == LinkConnectToSide.Left ? -1 : 1;
        if (linkType == LinkSideType.Inner) {
            g.setColor(this.linkLinesColor);
            if (factor == -1) {
                startX -= 7;
            }
            g.fillOval(startX, startY - 3, 7, 7);
        } else {
            int[] xx = new int[3];
            int[] yy = new int[3];
            xx[0] = startX;
            yy[0] = startY;
            xx[1] = startX + 4 * factor;
            yy[1] = startY - 4;
            xx[2] = xx[1];
            yy[2] = yy[1] + 8;
            g.setColor(this.linkLinesColor);
            g.fillPolygon(xx, yy, 3);
            g.drawPolygon(xx, yy, 3);
        }
    }

    protected void paintCardinalitySymbol(Graphics g, int x, int y, LinkCardinality cardinality) {
        Icon img;
        switch (cardinality) {
            case One: {
                img = Helpers.accessLinkCardinality1;
                break;
            }
            case Many: {
                img = Helpers.accessLinkCardinalityMany;
                break;
            }
            default: {
                img = null;
            }
        }
        if (img != null) {
            img.paintIcon(null, g, x - img.getIconWidth() / 2, y - img.getIconHeight() - 4);
        }
    }

    protected void paintAccessMarks(Graphics g, int[] xPoints, int[] yPoints, boolean focused, LinkConnectToSide firstSide, LinkConnectToSide secondSide, Link link) {
        if (link.getRightType() != LinkSideType.Inner || link.getLeftCardinality() == LinkCardinality.Unknown) {
            this.paintEndMark(g, xPoints[0], yPoints[0], xPoints[1], yPoints[1], firstSide, link.getRightType());
        }
        if (link.getLeftType() != LinkSideType.Inner || link.getRightCardinality() == LinkCardinality.Unknown) {
            this.paintEndMark(g, xPoints[3], yPoints[3], xPoints[2], yPoints[2], secondSide, link.getLeftType());
        }
    }

    private Point middlePoint(int x1, int y1, int x2, int y2) {
        return new Point((x1 + x2) / 2, (y1 + y2) / 2);
    }

    protected void paintMSEMMarks(Graphics g, int[] xPoints, int[] yPoints, boolean focused, LinkConnectToSide firstSide, LinkConnectToSide secondSide, Link link) {
        Color fillColor = focused ? this.getMarkColorFocused() : this.getMarkColor();
        BasicStroke stroke = new BasicStroke(1.0f);
        Point pnt = this.middlePoint(xPoints[1], yPoints[1], xPoints[2], yPoints[2]);
        int factor = xPoints[1] > xPoints[2] ? -1 : 1;
        if (link.getLeftType() == LinkSideType.Outer) {
            this.drawLeftSideMark(link, g, this.getLinkColor(), stroke, fillColor, pnt, 7, factor);
        }
        if (link.getRightType() == LinkSideType.Outer) {
            this.drawRightSideMark(link, g, this.getLinkColor(), stroke, fillColor, pnt, 7, factor);
        }
        this.drawCenterMark(link, g, this.getLinkColor(), stroke, fillColor, pnt, 7);
    }

    @Override
    public void paintLink(Graphics g, int[] xPoints, int[] yPoints, boolean focused, LinkConnectToSide firstSide, LinkConnectToSide secondSide, Link link) {
        if (!focused) {
            this.drawLine(g, xPoints, yPoints, this.getLinkColor(), 0, 1);
        } else {
            this.drawLine(g, xPoints, yPoints, this.getLinkColor(), 0, 2);
        }
        Stroke oldStroke = ((Graphics2D)g).getStroke();
        g.setColor(this.getLinkColor());
        ((Graphics2D)g).setStroke(new BasicStroke(2.0f));
        g.drawLine(xPoints[0], yPoints[0], xPoints[1], yPoints[1]);
        g.drawLine(xPoints[3], yPoints[3], xPoints[2], yPoints[2]);
        if (link.getLeftCardinality() != LinkCardinality.Unknown) {
            this.paintCardinalitySymbol(g, (xPoints[0] + xPoints[1]) / 2, yPoints[0], link.getLeftCardinality());
        }
        if (link.getRightCardinality() != LinkCardinality.Unknown) {
            this.paintCardinalitySymbol(g, (xPoints[3] + xPoints[2]) / 2, yPoints[3], link.getRightCardinality());
        }
        switch (this.markStyle) {
            case Access: {
                this.paintAccessMarks(g, xPoints, yPoints, focused, firstSide, secondSide, link);
                break;
            }
            case EnterpriseManager: {
                this.paintMSEMMarks(g, xPoints, yPoints, focused, firstSide, secondSide, link);
            }
        }
        ((Graphics2D)g).setStroke(oldStroke);
    }
}

