/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.commands;

import com.fasterxml.jackson.core.TreeCodec;
import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.stree.JacksonJrsTreeCodec;
import com.fasterxml.jackson.jr.stree.JrsArray;
import com.fasterxml.jackson.jr.stree.JrsBoolean;
import com.fasterxml.jackson.jr.stree.JrsValue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.GeneralSecurityException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import oracle.dbtools.commands.CSCommon;
import oracle.dbtools.commands.CommandMessages;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.http.CloudStorageUrl;
import oracle.dbtools.oci.OCIProfiles;
import oracle.dbtools.oci.OCIRESTClient;
import oracle.dbtools.oci.OCIRequest;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public class OCICommand
extends CommandListener
implements IHelp {
    private static final String OCI_CMD = "oci";
    private static final String OCI_CMDU = "OCI";
    private static final String OCI_PROFILE_NAME = "oci.profile.name";
    private static final String OCI_REGION_NAME = "oci.region.name";
    private static final String OCI_SQLCL_CONFIG_FILE = "OCI_SQLCL_CONFIG_FILE";
    private static final String DELETE = "delete";
    private static final String GET = "get";
    private static final String PUT = "put";
    private static final String CLEAR = "clear";
    private static final String NL = "\n";
    private static boolean region_set = false;
    private static ArrayList<String> subsRegions = new ArrayList();
    private static int homeRegionIndex = -1;
    private static boolean r1 = false;

    public String getCommand() {
        return OCI_CMDU;
    }

    public String getHelp() {
        return CommandMessages.getString("OCI_CMD_HELP");
    }

    public boolean isSqlPlus() {
        return false;
    }

    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String[] parts = cmd.getSql().replace(NL, "").split("\\s+");
        if (parts.length == 2 && parts[1].equalsIgnoreCase(OCI_CMD)) {
            ctx.write(CommandMessages.getString("OCI_INCORRECT_SYNTAX"));
            ctx.write(CommandMessages.getString("OCI_CONN_HELP"));
            return true;
        }
        if (parts.length == 2 && parts[1].equalsIgnoreCase("-rest")) {
            ctx.write(CommandMessages.getString("OCI_INCORRECT_SYNTAX"));
            ctx.write(CommandMessages.getString("OCI_CONN_REST_HELP"));
            return true;
        }
        if (OCICommand.matches((String)OCI_CMD, (String)cmd.getSql())) {
            block63: {
                OCIProfiles p;
                if (parts.length == 2 && parts[1].equalsIgnoreCase(CLEAR)) {
                    ctx.write(CommandMessages.getString("OCI_PROFILE_CLEARED") + NL);
                    ctx.write(CommandMessages.getString("OCI_REGION_CLEARED"));
                    ctx.removeProperty(OCI_PROFILE_NAME);
                    ctx.removeProperty(OCI_REGION_NAME);
                    subsRegions.clear();
                    this.OCIConnClear(ctx);
                    ctx.write(CommandMessages.getString("OCI_CONNECTION_CLEARED"));
                    homeRegionIndex = -1;
                    Map csProps = (Map)ctx.getProperty("cloud.storage");
                    if (csProps != null) {
                        csProps.remove(OCI_PROFILE_NAME);
                    }
                    return true;
                }
                if (parts.length > 1 && parts[1].equalsIgnoreCase("compartments")) {
                    String profile = (String)ctx.getProperty(OCI_PROFILE_NAME);
                    String region = (String)ctx.getProperty(OCI_REGION_NAME);
                    if (profile == null) {
                        ctx.write(CommandMessages.getString("OCI_PROFILE_NOT_SET"));
                    } else if (region == null) {
                        this.set_region_home(profile, ctx);
                    } else if (parts.length == 3 && parts[2].equalsIgnoreCase("list")) {
                        try {
                            this.compartments(profile, ctx);
                        }
                        catch (IOException | GeneralSecurityException | ParseException e) {
                            ctx.write(e.getLocalizedMessage() + NL);
                            return true;
                        }
                    }
                    return true;
                }
                if (parts.length > 1 && parts[1].equalsIgnoreCase("region")) {
                    String profile = (String)ctx.getProperty(OCI_PROFILE_NAME);
                    if (profile == null) {
                        ctx.write(CommandMessages.getString("OCI_PROFILE_NOT_SET"));
                    } else {
                        if (parts.length != 3 && !region_set) {
                            this.set_region_home(profile, ctx);
                            return true;
                        }
                        if (parts.length == 3) {
                            if (parts[2].equalsIgnoreCase("list")) {
                                for (int i = 0; i < subsRegions.size(); ++i) {
                                    if (i == homeRegionIndex) {
                                        ctx.write(subsRegions.get(i) + "\t(HOME REGION)\n");
                                        continue;
                                    }
                                    ctx.write(subsRegions.get(i) + NL);
                                }
                                return true;
                            }
                            if (subsRegions.contains(parts[2])) {
                                ctx.putProperty(OCI_REGION_NAME, (Object)parts[2]);
                                region_set = true;
                                ctx.write(CommandMessages.format("OCI_REGION_SET", parts[2]));
                                return true;
                            }
                            ctx.write(CommandMessages.format("OCID_REGION_SUBSCRIBED", parts[2]));
                            return true;
                        }
                        ctx.write(CommandMessages.format("OCI_REGION_SET", ctx.getProperty(OCI_REGION_NAME)));
                        return true;
                    }
                }
                if (parts.length > 1 && parts[1].equalsIgnoreCase("profile") && parts.length != 3 && parts.length != 4) {
                    try {
                        p = new OCIProfiles();
                        ctx.write(CommandMessages.getString("OCI_PROFILES"));
                        for (String profile : p.getProfiles()) {
                            ctx.write("\t" + profile + NL);
                        }
                    }
                    catch (Exception e) {
                        ctx.write(e.getMessage() + NL);
                    }
                    return true;
                }
                if ((parts.length == 3 || parts.length == 4) && parts[1].equalsIgnoreCase("profile")) {
                    if (parts[2].contains("r1")) {
                        r1 = true;
                    }
                    if (parts.length == 4) {
                        ctx.removeProperty(OCI_PROFILE_NAME);
                        ctx.removeProperty(OCI_REGION_NAME);
                        ctx.putProperty(OCI_SQLCL_CONFIG_FILE, (Object)parts[3]);
                        System.setProperty(OCI_SQLCL_CONFIG_FILE, parts[3]);
                    }
                    try {
                        p = new OCIProfiles();
                        if (p.getProfiles().contains(parts[2])) {
                            ctx.removeProperty(OCI_REGION_NAME);
                            ctx.putProperty(OCI_PROFILE_NAME, (Object)parts[2]);
                            HashMap csProps = (HashMap)ctx.getProperty("cloud.storage");
                            if (csProps == null) {
                                csProps = new HashMap();
                                ctx.putProperty("cloud.storage", csProps);
                            }
                            this.set_region_home(parts[2], ctx);
                            this.regionSubscriptions(parts[2], ctx);
                            CSCommon.setProfileAndWarn(ctx, parts[2], true);
                        } else {
                            ctx.write(CommandMessages.getString("OCI_PROFILE_INVALID"));
                        }
                    }
                    catch (IOException | IllegalArgumentException | GeneralSecurityException | ParseException e) {
                        ctx.write(CommandMessages.getString("OCI_PEMFILE_INVALID"));
                        return true;
                    }
                    return true;
                }
                if (ctx.getProperty(OCI_PROFILE_NAME) != null && parts.length > 1 && parts.length < 6) {
                    String host = null;
                    String method = null;
                    String bodyFile = null;
                    String qualifier = null;
                    String target = null;
                    try {
                        String ct;
                        if (parts[1].equalsIgnoreCase(DELETE) || parts[1].equalsIgnoreCase(GET) || parts[1].equalsIgnoreCase(PUT)) {
                            method = parts[1].toLowerCase();
                            Map props = (Map)ctx.getProperty("cloud.storage");
                            if (props == null || (CloudStorageUrl)props.get("cloud_url") == null) {
                                return true;
                            }
                            if (!method.equals(PUT) && parts.length == 3) {
                                qualifier = parts[2];
                            } else if (method.equals(PUT) && parts.length == 3) {
                                bodyFile = parts[2];
                            } else if (method.equals(PUT) && parts.length == 4) {
                                bodyFile = parts[2];
                                qualifier = parts[3];
                            }
                            CloudStorageUrl csUrl = new CloudStorageUrl(((CloudStorageUrl)props.get("cloud_url")).getFinalUrl());
                            if (qualifier != null) {
                                csUrl.qualifiedUrl(qualifier);
                            }
                            URL url = csUrl.getFinalUrlAsOCI();
                            if (method.equalsIgnoreCase(DELETE) || method.equalsIgnoreCase(GET) || method.equalsIgnoreCase(PUT)) {
                                csUrl.validateUrlAsObject();
                            }
                            host = url.getHost();
                            target = url.getPath();
                            csUrl.dropQualifiedUrl();
                        } else if (parts.length == 4) {
                            host = parts[1];
                            method = parts[2];
                            target = parts[3];
                        } else if (parts.length == 5) {
                            host = parts[1];
                            method = parts[2];
                            bodyFile = parts[3];
                            target = parts[4];
                        } else {
                            ctx.write(CommandMessages.getString("OCI_CMD_HELP") + NL);
                            return true;
                        }
                        OCIProfiles p2 = new OCIProfiles();
                        OCIRESTClient client = p2.getOciClient((String)ctx.getProperty(OCI_PROFILE_NAME));
                        OCIRequest req = null;
                        if (bodyFile == null) {
                            req = new OCIRequest.Builder().host(host).method(method).target(target).build();
                        } else if (bodyFile != null && !bodyFile.isEmpty()) {
                            File srcFile = new File(bodyFile = ctx.prependCD(bodyFile));
                            if (!srcFile.isFile()) {
                                throw new IOException(bodyFile + " is not a file");
                            }
                            req = new OCIRequest.Builder().host(host).method(method).bodyFile(new File(bodyFile)).target(target).build();
                        }
                        CloseableHttpResponse response = client.getResponse(req);
                        ctx.write("Status:" + response.getCode() + " " + response.getReasonPhrase() + NL);
                        HttpEntity ent = response.getEntity();
                        String string = ct = ent != null && ent.getContentType() != null ? ent.getContentType() : "application/octect";
                        if (ct.equals("application/json")) {
                            String ret = response != null && response.getEntity() != null ? EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8") : "";
                            ctx.write(ret + NL);
                            break block63;
                        }
                        if (ent == null || ent.getContentLength() == 0L) break block63;
                        String responseFileName = req.getFinalPath() == null || req.getFinalPath().trim().equals("") ? "response.oci" : req.getFinalPath();
                        Path responsePath = FileUtils.getNewOrExistingPath((ScriptRunnerContext)ctx, (String)responseFileName);
                        ctx.write(CommandMessages.format("OCI_FILE_SAVED", responsePath.toAbsolutePath()));
                        try (InputStream inputStream = ent.getContent();){
                            Files.copy(inputStream, responsePath, StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                    catch (IOException | GeneralSecurityException | ParseException e) {
                        ctx.write(NL + e.getLocalizedMessage() + NL);
                    }
                } else {
                    ctx.write(CommandMessages.getString("OCI_CMD_HELP") + NL);
                }
            }
            return true;
        }
        return false;
    }

    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    private String set_region_home(String profile, ScriptRunnerContext ctx) {
        OCIProfiles profiles = new OCIProfiles();
        String region = null;
        try {
            Properties pProps = profiles.getProperties();
            region = pProps.getProperty(profile + "/region");
            ctx.putProperty(OCI_REGION_NAME, (Object)region);
            ctx.write("Region set to: " + region + NL);
            region_set = true;
        }
        catch (IOException e) {
            ctx.write(e.getLocalizedMessage() + NL);
        }
        return region;
    }

    private Iterator<JrsValue> callOCIEndpoint(String profile, String path, ScriptRunnerContext ctx) throws IOException, GeneralSecurityException, ParseException, IllegalArgumentException {
        OCIProfiles p = new OCIProfiles();
        Iterator elements = null;
        OCIRESTClient client = p.getOciClient(profile);
        Object host = null;
        host = r1 ? "identity.r1.oracleiaas.com" : "identity." + ctx.getProperty(OCI_REGION_NAME) + ".oraclecloud.com";
        OCIRequest request = new OCIRequest.Builder().host((String)host).method(GET).target(path).contentType("application/json").build();
        CloseableHttpResponse response = client.getResponse(request);
        HttpEntity entity = response.getEntity();
        String entityStr = EntityUtils.toString((HttpEntity)entity);
        try {
            JSON json = JSON.std.with((TreeCodec)new JacksonJrsTreeCodec());
            JrsArray array = (JrsArray)json.treeFrom((Object)entityStr);
            elements = array.elements();
        }
        catch (ClassCastException ex) {
            throw new IOException(entityStr);
        }
        return elements;
    }

    private void compartments(String profile, ScriptRunnerContext ctx) throws ParseException, GeneralSecurityException, IOException {
        String tenancyID = null;
        OCIProfiles p = new OCIProfiles();
        Properties profiles = p.getProperties();
        tenancyID = profiles.getProperty(profile + "/tenancy");
        String path = "/20160918/compartments/?compartmentId=" + tenancyID;
        Iterator<JrsValue> elements = this.callOCIEndpoint(profile, path, ctx);
        while (elements.hasNext()) {
            JrsValue element = elements.next();
            String compartmentName = element.get("name").asText();
            ctx.write(compartmentName + NL);
        }
    }

    private void regionSubscriptions(String profile, ScriptRunnerContext ctx) throws ParseException, GeneralSecurityException, IOException {
        OCIProfiles p = new OCIProfiles();
        String tenancyID = null;
        subsRegions.clear();
        Properties profiles = p.getProperties();
        tenancyID = profiles.getProperty(profile + "/tenancy");
        String path = "/20160918/tenancies/" + tenancyID + "/regionSubscriptions";
        int i = 0;
        Iterator<JrsValue> elements = this.callOCIEndpoint(profile, path, ctx);
        if (r1) {
            subsRegions.add("r1.oci.oracleiaas.com");
            ++i;
        }
        while (elements.hasNext()) {
            JrsValue element = elements.next();
            String region = element.get("regionName").asText();
            if (((JrsBoolean)element.get("isHomeRegion")).booleanValue()) {
                homeRegionIndex = i;
            }
            subsRegions.add(region);
            ++i;
        }
    }

    private void OCIConnClear(ScriptRunnerContext ctx) {
        ScriptExecutor sqlcl = (ScriptExecutor)ctx.getProperty("runner");
        sqlcl.setConn(null);
        ctx.setCurrentConnection(null);
        ctx.setBaseConnection(null);
        ctx.putProperty("script.runner.sqlplus.nolog", (Object)Boolean.TRUE);
        ctx.putProperty("cli.conn.props", null);
    }
}

