/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.usages.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBox;
import oracle.dbtools.raptor.usages.UsagesPrefs;
import oracle.dbtools.raptor.usages.res.Messages;
import oracle.ide.net.URLFactory;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ide.webbrowser.BrowserRunner;
import oracle.javatools.ui.RichHintLabel;

public final class UsagesPrefsPanel
extends DefaultTraversablePanel {
    private static final String HELP_TOPIC_ID = "f1_preferences_usagetracking_html";
    private final JCheckBox _trackUsages = new JCheckBox();
    private final RichHintLabel _label = new RichHintLabel();
    private boolean _isPrefs = true;

    public UsagesPrefsPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public UsagesPrefsPanel(boolean bl) {
        this();
        this._isPrefs = bl;
    }

    public void onEntry(TraversableContext traversableContext) {
        UsagesPrefs usagesPrefs = UsagesPrefsPanel.getPrefs(traversableContext);
        this._trackUsages.setSelected(usagesPrefs.isTrackUsages());
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        UsagesPrefs usagesPrefs = UsagesPrefsPanel.getPrefs(traversableContext);
        usagesPrefs.setTrackUsages(this._trackUsages.isSelected());
    }

    public String getHelpID() {
        return HELP_TOPIC_ID;
    }

    public Component getDefaultFocusComponent() {
        return this._trackUsages;
    }

    private static UsagesPrefs getPrefs(TraversableContext traversableContext) {
        return UsagesPrefs.getInstance(traversableContext.getPropertyStorage());
    }

    private void jbInit() throws Exception {
        ResourceUtils.resButton((AbstractButton)this._trackUsages, (String)Messages.getString("USAGES_PREFS_OPT_IN_LABEL"));
        this.configureLinkLabel();
        this.setLayout(new GridBagLayout());
        this.add((Component)this._label, this.gbc(0, -1, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 0, 0, 0)));
        this.add(this._trackUsages, this.gbc(0, -1, 1, 1, 0.0, 1.0, 18, 2, new Insets(12, 0, 0, 0)));
    }

    private void configureLinkLabel() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Messages.getString("USAGES_PREFS_HTML_LABEL_PREFIX"));
        stringBuilder.append("<a href=\"http:");
        stringBuilder.append("usages-reporting-link-action");
        stringBuilder.append("\">");
        stringBuilder.append(Messages.getString("USAGES_PREFS_HTML_LABEL_LINK_TEXT"));
        stringBuilder.append("</a>");
        stringBuilder.append(Messages.getString("USAGES_PREFS_HTML_LABEL_SUFFIX"));
        if (!this._isPrefs) {
            stringBuilder.append(Messages.getString("USAGES_NOT_PREFS_HTML_LABEL_SUFFIX"));
        }
        this._label.setHtmlText(stringBuilder.toString());
        this._label.registerAction("usages-reporting-link-action", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    URL uRL = URLFactory.newURL((String)"http://www.oracle.com/html/privacy-policy.html");
                    if (uRL != null) {
                        BrowserRunner browserRunner = BrowserRunner.getBrowserRunner();
                        browserRunner.runBrowserOnURL(uRL, null, null);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }
}

