/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.connections.db.ora;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.connections.ConnectionConstants;
import oracle.dbtools.connections.db.ora.OracleSubtypeConfigurator;
import oracle.dbtools.jdbc.configurators.ConfigurationException;
import oracle.dbtools.jdbc.configurators.OracleConnectionConstants;
import oracle.dbtools.jdbc.tns.TNSEntry;
import oracle.dbtools.jdbc.wallet.DatabaseToolsProperties;
import oracle.dbtools.jdbc.wallet.OracleWalletArchive;
import oracle.dbtools.util.Logger;

public class CloudSupport
implements OracleSubtypeConfigurator<OracleWalletArchive>,
ConnectionConstants,
OracleConnectionConstants {
    public static final String CONFIG_FILE = "sqldev.cloud.configfile";
    public static final String PROXY_MODE = "sqldev.http.proxymode";
    public static final String PROXY_HOST = "sqldev.http.proxy.host";
    public static final String PROXY_PORT = "sqldev.http.proxy.port";
    private static final String LEGACY_USE_PROXY = "sqldev.cloud.useproxy";
    private static final String LEGACY_PROXY_HOST = "sqldev.cloud.proxy.host";
    private static final String LEGACY_PROXY_PORT = "sqldev.cloud.proxy.port";
    private static final Pattern PORT_PATTERN = Pattern.compile("\\(\\s*PORT\\s*=\\s*([^\\s)]+)\\s*\\)");
    private static final Pattern HOST_PATTERN = Pattern.compile("\\(\\s*HOST\\s*=\\s*([^\\s)]+)\\s*\\)");

    @Override
    public OracleWalletArchive createConfigurator(Properties props) throws ConfigurationException {
        OracleWalletArchive.Builder walletBuilder;
        DatabaseToolsProperties.Builder propsBuilder = DatabaseToolsProperties.builder();
        String servicename = props.getProperty("customUrl");
        propsBuilder.serviceAlias(servicename);
        try {
            String walletPath = props.getProperty(CONFIG_FILE);
            URI uri = URI.create(walletPath);
            InputStream is = uri.toURL().openStream();
            walletBuilder = OracleWalletArchive.builder(is);
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
        String v = props.getProperty(PROXY_MODE);
        ProxyMode mode = v != null ? ProxyMode.valueOf(v) : (Boolean.valueOf(props.getProperty(LEGACY_USE_PROXY)) != false ? ProxyMode.CUSTOM : ProxyMode.NONE);
        switch (mode) {
            case IDE: {
                String copy;
                Matcher matcher;
                String desc;
                String hostname = null;
                String port = null;
                OracleWalletArchive owa = walletBuilder.build();
                TNSEntry entry = owa.getTNSNames().getTNSEntry(servicename);
                if (entry != null && (desc = entry.getConnectionDescriptor()) != null && (matcher = HOST_PATTERN.matcher(copy = desc.toUpperCase())).find()) {
                    hostname = desc.substring(matcher.start(1), matcher.end(1));
                    matcher = PORT_PATTERN.matcher(copy);
                    if (matcher.find()) {
                        port = desc.substring(matcher.start(1), matcher.end(1));
                    }
                }
                if (!ModelUtil.hasLength(hostname) || !ModelUtil.hasLength(port)) break;
                try {
                    URI uri = new URI("https://" + hostname + ":" + port);
                    ProxySelector ps = ProxySelector.getDefault();
                    List<Proxy> proxies = ps.select(uri);
                    if (proxies == null) break;
                    for (Proxy p : proxies) {
                        SocketAddress address;
                        if (p.type() != Proxy.Type.HTTP || !((address = p.address()) instanceof InetSocketAddress)) continue;
                        String proxyHost = ((InetSocketAddress)address).getHostString();
                        int proxyPort = ((InetSocketAddress)address).getPort();
                        if (proxyHost == null || proxyPort <= 0) continue;
                        URI proxy = URI.create("https://" + proxyHost + ":" + proxyPort);
                        propsBuilder.httpsProxy(proxy);
                    }
                }
                catch (URISyntaxException e) {
                    Logger.warn(CloudSupport.class, e.getLocalizedMessage(), e);
                }
                break;
            }
            case CUSTOM: {
                String proxyPort;
                String proxyHost = props.getProperty(PROXY_HOST);
                if (proxyHost == null) {
                    proxyHost = props.getProperty(LEGACY_PROXY_HOST);
                }
                if ((proxyPort = props.getProperty(PROXY_PORT)) == null) {
                    proxyPort = props.getProperty(LEGACY_PROXY_PORT);
                }
                if (!ModelUtil.hasLength(proxyHost) || !ModelUtil.hasLength(proxyPort)) break;
                URI proxy = URI.create("https://" + proxyHost + ":" + proxyPort);
                propsBuilder.httpsProxy(proxy);
                break;
            }
        }
        walletBuilder.databaseToolsProperties(propsBuilder.build());
        return walletBuilder.build();
    }

    @Override
    public String getConnectionURL(Properties props) throws ConfigurationException {
        return null;
    }

    @Override
    public Set<String> pathProperties() {
        return Collections.singleton(CONFIG_FILE);
    }

    public static enum ProxyMode {
        NONE,
        IDE,
        CUSTOM;

    }
}

