/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.formattors;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.data.formattors.CharFormattor;
import oracle.dbtools.data.formattors.DateFormattor;
import oracle.dbtools.data.formattors.ITypeFormattor;
import oracle.dbtools.data.formattors.NumberFormattor;

public class DataTypeFormatterRegistry {
    private HashMap<String, DataTypeDef> _fmtMap = new HashMap();
    private static DataTypeFormatterRegistry INSTANCE;

    public synchronized void registerFormattor(String type, Class<? extends ITypeFormattor> formater, boolean isPrecisionAllowed, boolean isScaleAllowed, boolean isScaleImported) {
        if (this._fmtMap == null) {
            this._fmtMap = new HashMap();
        }
        DataTypeDef dataType = new DataTypeDef(formater, isPrecisionAllowed, isScaleAllowed, isScaleImported);
        this._fmtMap.put(type, dataType);
    }

    public synchronized void unregisterFormattor(String type) {
        if (this._fmtMap != null) {
            this._fmtMap.remove(type);
        }
    }

    public ITypeFormattor getFormattor(String type) {
        if (this._fmtMap != null && type != null) {
            try {
                DataTypeDef dataType = this._fmtMap.get(type);
                if (dataType == null) {
                    return null;
                }
                ITypeFormattor formattor = dataType.getHandler().newInstance();
                formattor.isPrecisionAllowed(dataType.isPrecisionAllowed());
                formattor.isScaleAllowed(dataType.isScaleAllowed());
                formattor.isScaleImported(dataType.isScaleImported());
                return formattor;
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
        return null;
    }

    private DataTypeFormatterRegistry() {
        this.registerFormattor("NUMBER", NumberFormattor.class, true, true, true);
        this.registerFormattor("INTEGER", NumberFormattor.class, false, false, false);
        this.registerFormattor("LONG", NumberFormattor.class, false, false, false);
        this.registerFormattor("FLOAT", NumberFormattor.class, false, false, true);
        this.registerFormattor("CHAR", CharFormattor.class, true, false, false);
        this.registerFormattor("NCHAR", CharFormattor.class, true, false, false);
        this.registerFormattor("VARCHAR2", CharFormattor.class, true, false, false);
        this.registerFormattor("NVARCHAR2", CharFormattor.class, true, false, false);
        this.registerFormattor("DATE", DateFormattor.class, false, false, false);
        this.registerFormattor("TIMESTAMP WITH TIME ZONE", DateFormattor.class, true, false, false);
        this.registerFormattor("TIMESTAMP WITH LOCAL TIME ZONE", DateFormattor.class, true, false, false);
        this.registerFormattor("TIMESTAMP", DateFormattor.class, true, false, false);
    }

    public static DataTypeFormatterRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DataTypeFormatterRegistry();
        }
        return INSTANCE;
    }

    public class DataTypeDef {
        boolean m_isPrecisionAllowed;
        boolean m_isScaleAllowed;
        boolean m_isScaleImported;
        Class<? extends ITypeFormattor> m_handler;

        public DataTypeDef(Class<? extends ITypeFormattor> handler, boolean isPrecisionAllowed, boolean isScaleAllowed, boolean isScaleImported) {
            this.m_handler = handler;
            this.m_isPrecisionAllowed = isPrecisionAllowed;
            this.m_isScaleAllowed = isScaleAllowed;
            this.m_isScaleImported = isScaleImported;
        }

        Class<? extends ITypeFormattor> getHandler() {
            return this.m_handler;
        }

        public boolean isPrecisionAllowed() {
            return this.m_isPrecisionAllowed;
        }

        public void isPrecisionAllowed(boolean isPrecisionAllowed) {
            this.m_isPrecisionAllowed = isPrecisionAllowed;
        }

        public boolean isScaleAllowed() {
            return this.m_isScaleAllowed;
        }

        public void isScaleAllowed(boolean isScaleAllowed) {
            this.m_isScaleAllowed = isScaleAllowed;
        }

        public boolean isScaleImported() {
            return this.m_isScaleImported;
        }

        public void isScaleImported(boolean isScaleImported) {
            this.m_isScaleImported = isScaleImported;
        }
    }
}

