/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.features;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.LSP;
import oracle.dbtools.lsp.features.MultilineToken;
import oracle.dbtools.lsp.features.SemanticToken;
import oracle.dbtools.lsp.features.SimpleToken;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.json.Jsonable;

public class SemanticTokens
implements Jsonable {
    public static String[] semanticTokenTypes = new String[]{"namespace", "type", "class", "enum", "interface", "struct", "typeParameter", "parameter", "variable", "property", "enumMember", "event", "function", "method", "macro", "keyword", "modifier", "comment", "string", "number", "regexp", "operator"};
    public static int keyword = -1;
    public static int macro = -1;
    public static int variable = -1;
    public static int number = -1;
    public static int string = -1;
    public static int operator = -1;
    public static int paren = -1;
    public static int comment = -1;
    public static String[] semanticTokenModifiers = new String[]{"declaration", "definition", "readonly", "static", "deprecated", "abstract", "async", "modification", "documentation", "defaultLibrary"};
    List<SemanticToken> tokens = new LinkedList<SemanticToken>();
    BackgroundParser parser;

    int keyword() {
        if (keyword == -1) {
            keyword = Arrays.asList(semanticTokenTypes).indexOf("keyword");
        }
        return keyword;
    }

    int macro() {
        if (macro == -1) {
            macro = Arrays.asList(semanticTokenTypes).indexOf("macro");
        }
        return macro;
    }

    int variable() {
        if (variable == -1) {
            variable = Arrays.asList(semanticTokenTypes).indexOf("variable");
        }
        return variable;
    }

    int number() {
        if (number == -1) {
            number = Arrays.asList(semanticTokenTypes).indexOf("number");
        }
        return number;
    }

    int string() {
        if (string == -1) {
            string = Arrays.asList(semanticTokenTypes).indexOf("string");
        }
        return string;
    }

    int operator() {
        if (operator == -1) {
            operator = Arrays.asList(semanticTokenTypes).indexOf("regexp");
        }
        return operator;
    }

    int paren() {
        if (paren == -1) {
            paren = Arrays.asList(semanticTokenTypes).indexOf("macro");
        }
        return paren;
    }

    int comment() {
        if (comment == -1) {
            comment = Arrays.asList(semanticTokenTypes).indexOf("comment");
        }
        return comment;
    }

    private boolean isKeyword(int pos, LexerToken token) {
        if (token == null || token.content == null) {
            return false;
        }
        Object candidateKeyword = "'" + token.content.toUpperCase() + "'";
        Integer code = (Integer)this.parser.earley.symbolIndexes.get(candidateKeyword);
        if (code == null) {
            return false;
        }
        ParseNode root = this.parser.root;
        if (root != null) {
            ParseNode leaf = root.leafAtPos(pos);
            if (((String)candidateKeyword).equals("'ON'")) {
                candidateKeyword = "'ON'";
            }
            if (leaf != null) {
                return leaf.contains(code);
            }
        }
        return code != null;
    }

    public SemanticTokens(BackgroundParser parser) {
        long t2;
        long time;
        this.parser = parser;
        int startOffset = 0;
        int endOffset = 99999999;
        long t1 = System.currentTimeMillis();
        int to = 0;
        MultilineToken prior = null;
        int i = -1;
        for (LexerToken t : parser.allSrc) {
            ++i;
            to = t.begin + t.content.length();
            if (t.type == Token.COMMENT) {
                to = t.end;
            }
            if (endOffset <= t.begin) break;
            int startLine = parser.charPos2LineNo0(t.begin);
            int startChar = t.begin - parser.lineNo2CharPos0(startLine);
            int endLine = parser.charPos2LineNo0(to - 1);
            int endChar = to - parser.lineNo2CharPos0(endLine);
            SemanticToken token = null;
            if (startOffset <= to) {
                switch (t.type) {
                    case OPERATION: {
                        if ("(".equals(t.content) || ")".equals(t.content)) {
                            token = new SimpleToken(prior, startLine, startChar, to - t.begin, this.paren(), 0);
                            break;
                        }
                        token = new SimpleToken(prior, startLine, startChar, to - t.begin, this.operator(), 7);
                        break;
                    }
                    case IDENTIFIER: 
                    case DQUOTED_STRING: {
                        if (this.isKeyword(i, t)) {
                            token = new SimpleToken(prior, startLine, startChar, to - t.begin, this.keyword(), 0);
                            break;
                        }
                        if (t.content.charAt(0) == '$') {
                            token = new SimpleToken(prior, startLine, startChar, to - t.begin, this.macro(), 0);
                            break;
                        }
                        token = new SimpleToken(prior, startLine, startChar, to - t.begin, this.variable(), 0);
                        break;
                    }
                    case DIGITS: {
                        token = new SimpleToken(prior, startLine, startChar, to - t.begin, this.number(), 0);
                        break;
                    }
                    case QUOTED_STRING: {
                        token = new MultilineToken(prior, startLine, startChar, endLine, endChar, this.string(), 0);
                        break;
                    }
                    case LINE_COMMENT: {
                        --i;
                        token = new SimpleToken(prior, startLine, startChar, to - t.begin, this.comment(), 0);
                        break;
                    }
                    case COMMENT: {
                        --i;
                        token = new MultilineToken(prior, startLine, startChar, endLine, endChar, this.comment(), 0);
                        break;
                    }
                    case WS: 
                    case MACRO_SKIP: 
                    case SQLPLUSLINECONTINUE_SKIP: {
                        --i;
                        break;
                    }
                }
            }
            if (token == null) continue;
            this.tokens.add(token);
            prior = token;
        }
        if (30L < (time = (t2 = System.currentTimeMillis()) - t1)) {
            LSP.Log.info("renderRegion time = " + time);
        }
    }

    @Override
    public String toJson() {
        StringBuilder ret = new StringBuilder("{ \"data\": [ ");
        boolean i = false;
        for (SemanticToken t : this.tokens) {
            ret.append(t.toString());
        }
        ret.append(" ] }");
        return ret.toString();
    }
}

