/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.List;
import oracle.sql.Datum;

public abstract class OraIntervalDatum
implements Cloneable,
Comparable<OraIntervalDatum> {
    public static final int ALL_FIELDS = 255;
    public static final int NULL_FIELD = -1;
    public static final int SIGN = 0;
    public static final int YEARS = 1;
    public static final int MONTHS = 2;
    public static final int DAYS = 1;
    public static final int HOURS = 2;
    public static final int MINUTES = 3;
    public static final int SECONDS = 4;
    public static final int NANOS = 5;
    public static final String LEADINGPRECISION = "LEADINGPRECISION";
    public static final String FRACTIONALPRECISION = "FRACTIONALPRECISION";
    protected OraIntervalDatumImpl datumImpl;

    protected static boolean areEqual(Object obj1, Object obj2) {
        return obj1 == obj2 || obj1 != null && obj2 != null && obj1.equals(obj2);
    }

    protected OraIntervalDatum(OraIntervalDatumImpl datumImpl) {
        this.datumImpl = datumImpl;
    }

    public final void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.datumImpl.addPropertyChangeListener(pcl);
    }

    public final void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.datumImpl.removePropertyChangeListener(pcl);
    }

    public abstract Datum getDatum();

    public MetaData getMetaData() {
        return this.datumImpl.getMetaData();
    }

    public void clear() {
        this.datumImpl.clear();
    }

    public void normalize() {
        this.datumImpl.normalize();
    }

    public int get(int field) {
        return this.datumImpl.get(field);
    }

    public void set(int field, int value) {
        this.datumImpl.set(field, value);
    }

    public int getFromField() {
        return this.datumImpl.getFromField();
    }

    public int getToField() {
        return this.datumImpl.getToField();
    }

    public final int getLeadingPrecision() {
        return this.datumImpl.getLeadingPrecision();
    }

    public final void setLeadingPrecision(int precision) {
        this.datumImpl.setLeadingPrecision(precision);
    }

    public final int getFractionalPrecision() {
        return this.datumImpl.getFractionalPrecision();
    }

    public final void setFractionalPrecision(int precision) {
        this.datumImpl.setFractionalPrecision(precision);
    }

    public abstract boolean nanosSupported();

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        OraIntervalDatum another = (OraIntervalDatum)obj;
        return OraIntervalDatum.areEqual(this.datumImpl, another.datumImpl);
    }

    public int hashCode() {
        int hash = 7;
        hash = hash * 31 + (this.datumImpl == null ? 0 : this.datumImpl.hashCode());
        return hash;
    }

    @Override
    public int compareTo(OraIntervalDatum another) {
        int ret = 0;
        if (this != another) {
            ret = this.datumImpl.compareTo(another.datumImpl);
        }
        return ret;
    }

    public Object clone() {
        try {
            OraIntervalDatum other = (OraIntervalDatum)super.clone();
            other.datumImpl = (OraIntervalDatumImpl)this.datumImpl.clone();
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public final void replicate(OraIntervalDatum value) {
        if (value.getClass() == this.getClass()) {
            this.datumImpl.replicate(value.datumImpl);
        }
    }

    public final void setValue(OraIntervalDatum value) {
        if (value.getClass() == this.getClass()) {
            this.datumImpl.setValue(value.datumImpl);
        }
    }

    protected static abstract class OraIntervalDatumImpl
    implements Cloneable,
    Comparable<OraIntervalDatumImpl> {
        protected int[] fields;
        protected MetaData metadata;
        private int leadingPrecision;
        private int fractionalPrecision;
        private int fromField;
        private int toField;
        private PropertyChangeSupport changesSupport = new PropertyChangeSupport(this);

        protected void addPropertyChangeListener(PropertyChangeListener pcl) {
            this.changesSupport.addPropertyChangeListener(pcl);
        }

        protected void removePropertyChangeListener(PropertyChangeListener pcl) {
            this.changesSupport.removePropertyChangeListener(pcl);
        }

        private void fireFieldChange(int field, int oldValue, int newValue) {
            this.changesSupport.firePropertyChange(this.metadata.getFieldId(field), oldValue, newValue);
        }

        private void fireLeadingPrecisionChange(int oldPrecision, int newPrecision) {
            this.changesSupport.firePropertyChange(OraIntervalDatum.LEADINGPRECISION, oldPrecision, newPrecision);
        }

        private void fireFractionalPrecisionChange(int oldFractionPrecision, int newFractionalPrecision) {
            this.changesSupport.firePropertyChange(OraIntervalDatum.FRACTIONALPRECISION, oldFractionPrecision, newFractionalPrecision);
        }

        protected OraIntervalDatumImpl(MetaData metadata, int[] fields, int fromField, int leadingPrecision, int toField, int fractionalPrecision) {
            this.metadata = metadata;
            this.fields = fields;
            this.fromField = fromField;
            this.toField = toField;
            this.leadingPrecision = leadingPrecision;
            this.fractionalPrecision = fractionalPrecision;
            this.set(0, 1);
            for (int i = 1; i < fields.length; ++i) {
                int field = fields[i];
                if (field == 0) continue;
                if (field < 0) {
                    this.set(0, -1);
                }
                for (int j = i; j < fields.length; ++j) {
                    this.set(j, Math.abs(fields[j]));
                }
            }
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            OraIntervalDatumImpl another = (OraIntervalDatumImpl)obj;
            return Arrays.equals(this.fields, another.fields);
        }

        @Override
        public int compareTo(OraIntervalDatumImpl obj) {
            int ret = 0;
            if (this != obj) {
                int sign = this.fields[0];
                int objSign = obj.fields[0];
                for (int i = 1; ret == 0 && i < this.fields.length; ++i) {
                    int thisField = this.fields[i] * sign;
                    int objField = obj.fields[i] * objSign;
                    if (thisField == objField) continue;
                    if (thisField < objField) {
                        ret = -1;
                        continue;
                    }
                    if (thisField <= objField) continue;
                    ret = 1;
                }
            }
            return ret;
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + Arrays.hashCode(this.fields);
            return hash;
        }

        public Object clone() {
            try {
                OraIntervalDatumImpl other = (OraIntervalDatumImpl)super.clone();
                other.metadata = (MetaData)this.metadata.clone();
                other.fields = (int[])this.fields.clone();
                other.fromField = this.fromField;
                other.toField = this.toField;
                other.leadingPrecision = this.leadingPrecision;
                other.fractionalPrecision = this.fractionalPrecision;
                return other;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }

        public void replicate(OraIntervalDatumImpl impl) {
            this.fromField = impl.fromField;
            this.toField = impl.toField;
            this.setLeadingPrecision(this.getLeadingPrecision());
            this.setFractionalPrecision(this.getFractionalPrecision());
            this.setValue(impl);
        }

        public void setValue(OraIntervalDatumImpl impl) {
            for (int i = 0; i < this.fields.length; ++i) {
                if (i == 0 || i >= this.fromField && i <= this.toField) {
                    this.set(i, impl.fields[i]);
                    if (i != 4) continue;
                    this.set(5, impl.fields[5]);
                    ++i;
                    continue;
                }
                this.set(i, 0);
            }
        }

        public MetaData getMetaData() {
            return this.metadata;
        }

        public int getFromField() {
            return this.fromField;
        }

        public int getToField() {
            return this.toField;
        }

        public void setLeadingPrecision(int precision) {
            int oldPrecision = this.leadingPrecision;
            if (precision != oldPrecision) {
                this.leadingPrecision = precision;
                if (oldPrecision > precision) {
                    this.leading_precision_changed(oldPrecision, precision);
                }
                this.fireLeadingPrecisionChange(oldPrecision, precision);
                if (oldPrecision < precision) {
                    this.leading_precision_changed(oldPrecision, precision);
                }
            }
        }

        public final int getLeadingPrecision() {
            return this.leadingPrecision;
        }

        protected void leading_precision_changed(int oldPrecision, int precision) {
        }

        public final void setFractionalPrecision(int precision) {
            int oldPrecision = this.fractionalPrecision;
            if (precision != oldPrecision) {
                this.fractionalPrecision = precision;
                if (oldPrecision > precision) {
                    this.fractional_precision_changed(oldPrecision, precision);
                }
                this.fireFractionalPrecisionChange(oldPrecision, precision);
                if (oldPrecision < precision) {
                    this.fractional_precision_changed(oldPrecision, precision);
                }
            }
        }

        public final int getFractionalPrecision() {
            return this.fractionalPrecision;
        }

        protected void fractional_precision_changed(int oldPrecision, int precision) {
        }

        protected int get(int field) {
            return this.fields[field];
        }

        protected void set(int field, int newValue) {
            int oldValue = this.fields[field];
            if (oldValue != newValue) {
                this.fields[field] = newValue;
                this.fireFieldChange(field, oldValue, newValue);
            }
        }

        protected abstract byte[] getDatumBytes();

        public void clear() {
            this.set(0, 1);
            for (int i = 1; i < this.fields.length; ++i) {
                this.set(i, 0);
            }
        }

        public abstract void normalize();
    }

    public static enum Field {
        SIGN(0, 1, 1, 1),
        YEARS(0, 999999999, 2, 9),
        MONTHS(0, 11, 2, 2),
        DAYS(0, 999999999, 2, 9),
        HOURS(0, 23, 2, 2),
        MINUTES(0, 59, 2, 2),
        SECONDS(0, 59, 2, 2),
        NANOS(0, 999999999, -1, -1);

        private int minValue;
        private int maxValue;
        private int minDisplayPrecision;
        private int maxDisplayPrecision;

        private Field(int minValue, int maxValue, int minDisplayPrecision, int maxDisplayPrecision) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.minDisplayPrecision = minDisplayPrecision;
            this.maxDisplayPrecision = maxDisplayPrecision;
        }

        public int getMinValue() {
            return this.minValue;
        }

        public int getMaxValue() {
            return this.maxValue;
        }

        public int getMinDisplayPrecision() {
            return this.minDisplayPrecision;
        }

        public int getMaxDisplayPrecision() {
            return this.maxDisplayPrecision;
        }
    }

    public static abstract class MetaData
    implements Cloneable {
        protected abstract List<Field> getFieldList();

        public Field[] getFields() {
            return this.getFieldList().toArray(new Field[this.getFieldList().size()]);
        }

        public Field getField(int ordinal) {
            return this.getFields()[ordinal];
        }

        public Field getField(String id) {
            Field field = Field.valueOf(id);
            return this.getFieldList().contains((Object)field) ? field : null;
        }

        public int getFieldOrdinal(Field field) {
            return this.getFieldList().indexOf((Object)field);
        }

        public String getFieldId(Field field) {
            return this.getFieldList().contains((Object)field) ? field.toString() : null;
        }

        public int getFieldOrdinal(String id) {
            return this.getFieldOrdinal(this.getField(id));
        }

        public String getFieldId(int ordinal) {
            return this.getFieldId(this.getField(ordinal));
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }
    }
}

