/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extendedtype;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.extendedtype.AbstractExtendedType;

public class GenericBlobType
extends AbstractExtendedType
implements Blob {
    protected InputStream in = null;
    protected OutputStream out = null;

    protected GenericBlobType(int sqlType, Blob origValue) {
        super(sqlType, origValue);
    }

    public GenericBlobType() {
        this(null);
    }

    public GenericBlobType(Blob blob) {
        this(2004, blob);
    }

    @Override
    public Blob getOrigValue() {
        return (Blob)super.getOrigValue();
    }

    public Blob getOrigBlob() {
        return this.getOrigValue();
    }

    @Override
    public void duplicate() throws SQLException {
        if (this.getOrigValue() != null) {
            this.in = this.getOrigValue().getBinaryStream();
        }
    }

    @Override
    public InputStream getBinaryStream(Boolean orig) throws Exception {
        if (orig == null && this.getLoadFromURL() != null || orig != null && !orig.booleanValue()) {
            return super.getBinaryStream(orig);
        }
        if (this.getOrigValue() != null) {
            return this.getOrigValue().getBinaryStream();
        }
        return null;
    }

    @Override
    public InputStream getCharStream() throws SQLException {
        return null;
    }

    @Override
    public boolean saveToDb(Connection conn, String tableName, String columnName, String rowId, String rowScn, boolean dataIntegrity, List<String> log) throws SQLException, IOException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveToDisk(String tableName, String columnName, String rowId, String rowScn, boolean dataIntegrity) throws SQLException, IOException {
        Blob origBlob;
        OutputStream out = this.out;
        RaptorTaskDescriptor taskDescriptor = this.getToDiskTaskDescriptor();
        if (taskDescriptor != null) {
            this.setToDiskTaskProgress(taskDescriptor, 0);
        }
        if ((origBlob = this.getOrigValue()) != null && out != null) {
            InputStream blobStream = null;
            try {
                long expectedLength = origBlob.length();
                blobStream = origBlob.getBinaryStream();
                if (blobStream != null && expectedLength > 0L) {
                    long written = 0L;
                    blobStream = new BufferedInputStream(blobStream, 16384);
                    byte[] buffer = new byte[8192];
                    int nbytes = 0;
                    while (!(out != this.out || taskDescriptor != null && taskDescriptor.isCancelled() || (nbytes = blobStream.read(buffer)) == -1)) {
                        out.write(buffer, 0, nbytes);
                        written += (long)nbytes;
                        if (taskDescriptor == null) continue;
                        int percentage = (int)(written * 100L / expectedLength);
                        this.setToDiskTaskProgress(taskDescriptor, percentage);
                    }
                    if (taskDescriptor != null) {
                        this.setToDiskTaskProgress(taskDescriptor, 100);
                    }
                    boolean bl = out == this.out;
                    return bl;
                }
            }
            finally {
                try {
                    out.close();
                }
                catch (Exception exception) {}
                try {
                    if (blobStream != null) {
                        blobStream.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    @Override
    public boolean isToDiskInDeterministic() {
        return false;
    }

    @Override
    public void setLoadFromURL(URL url) {
        if (url == null) {
            this.setSuperLoadFromURL(null);
        }
    }

    protected void setSuperLoadFromURL(URL url) {
        super.setLoadFromURL(url);
    }

    @Override
    public void setToDiskStream(OutputStream out) {
        this.out = out == null || out instanceof BufferedOutputStream ? out : new BufferedOutputStream(out, 65536);
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        return this.getOrigValue().getBytes(pos, length);
    }

    @Override
    public long length() throws SQLException {
        return this.getOrigValue().length();
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        return this.getOrigValue().position(pattern, start);
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        return this.getOrigValue().position(pattern, start);
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        return this.getOrigValue().setBinaryStream(pos);
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.getOrigValue().setBytes(pos, bytes);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        return this.getOrigValue().setBytes(pos, bytes, offset, len);
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.getOrigValue().truncate(len);
    }

    public boolean equals(Object o) {
        return o == this;
    }

    public int hashCode() {
        return this.getOrigValue().hashCode();
    }

    public String toString() {
        return "(Blob)";
    }

    @Override
    public void free() throws SQLException {
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        return null;
    }
}

