/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.raptor.format.ANSIConsoleFormatter;
import oracle.dbtools.raptor.format.CSVFormatter;
import oracle.dbtools.raptor.format.DelimitedFormatter;
import oracle.dbtools.raptor.format.FixedFormatter;
import oracle.dbtools.raptor.format.HTMLFormatter;
import oracle.dbtools.raptor.format.IResultFormatter;
import oracle.dbtools.raptor.format.InsertFormatter;
import oracle.dbtools.raptor.format.JSONFormatter;
import oracle.dbtools.raptor.format.JSONPrettyFormatter;
import oracle.dbtools.raptor.format.LoaderFormatter;
import oracle.dbtools.raptor.format.T2Formatter;
import oracle.dbtools.raptor.format.TxtFormatter;
import oracle.dbtools.raptor.format.XMLFormatter;

public class FormatRegistry {
    private static Map<String, Class> s_registry = new TreeMap<String, Class>();
    private static ArrayList<String> s_internalOnly = new ArrayList();
    private static String m_lineTerminator = System.getProperty("line.terminator");

    public static synchronized void registerFormater(IResultFormatter clazz) {
        s_registry.put(clazz.getType().toLowerCase(), clazz.getClass());
        if (clazz.isInternalOnly()) {
            s_internalOnly.add(clazz.getType().toLowerCase());
        }
    }

    public static synchronized void unregisterFormater(IResultFormatter clazz) {
        s_registry.remove(clazz.getType().toLowerCase());
    }

    public static synchronized IResultFormatter getFormatter(String type) {
        if (s_registry.isEmpty()) {
            FormatRegistry.registerBasics();
        }
        try {
            return (IResultFormatter)s_registry.get(type.toLowerCase()).newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static synchronized List<String> getTypes() {
        if (s_registry.isEmpty()) {
            FormatRegistry.registerBasics();
        }
        ArrayList<String> types = new ArrayList<String>();
        Set<String> keys = s_registry.keySet();
        for (String key : keys) {
            if (FormatRegistry.isInternal(key)) continue;
            types.add(key);
        }
        return types;
    }

    private static boolean isInternal(String key) {
        for (String internalOnly : s_internalOnly) {
            if (!internalOnly.equals(key)) continue;
            return true;
        }
        return false;
    }

    public static synchronized List<String> getAllTypes() {
        if (s_registry.isEmpty()) {
            FormatRegistry.registerBasics();
        }
        ArrayList<String> types = new ArrayList<String>();
        types.addAll(s_registry.keySet());
        return types;
    }

    public static void setLineTerminator(String terminator) {
        m_lineTerminator = terminator;
    }

    public static String getLineTerminator() {
        return m_lineTerminator;
    }

    public static void registerBasics() {
        if (s_registry.isEmpty()) {
            try {
                FormatRegistry.registerFormater(new TxtFormatter());
                FormatRegistry.registerFormater(new CSVFormatter());
                FormatRegistry.registerFormater(new DelimitedFormatter());
                FormatRegistry.registerFormater(new InsertFormatter());
                FormatRegistry.registerFormater(new FixedFormatter());
                FormatRegistry.registerFormater(new XMLFormatter());
                FormatRegistry.registerFormater(new HTMLFormatter());
                FormatRegistry.registerFormater(new LoaderFormatter());
                FormatRegistry.registerFormater(new ANSIConsoleFormatter());
                FormatRegistry.registerFormater(new JSONFormatter());
                FormatRegistry.registerFormater(new JSONPrettyFormatter());
                FormatRegistry.registerFormater(new T2Formatter());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

