/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.help;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import oracle.dbtools.raptor.newscriptrunner.util.help.CommandPageAssemblers;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpBundleBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpContainer;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPages;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpStringExtension;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpStrings;
import oracle.dbtools.raptor.newscriptrunner.util.help.PageAssembler;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;

public class HelpPagesBuilder {
    private int lineSize;
    private boolean alphaSort;
    private final Map<HelpStringExtension, String> extensionMap = new HashMap<HelpStringExtension, String>();
    private final Map<String, String> helpPageRenames = new HashMap<String, String>();
    private final List<HelpContainer> helpContainers = new ArrayList<HelpContainer>();
    private final List<PageAssembler> pageAssemblers = new ArrayList<PageAssembler>();

    public HelpPagesBuilder lineSize(int lineSize) {
        this.lineSize = lineSize;
        return this;
    }

    public HelpPagesBuilder alphaSort() {
        this.alphaSort = true;
        return this;
    }

    public HelpPagesBuilder addHelpIdExtension(HelpStringExtension extension, String extensionString) {
        this.extensionMap.put(extension, extensionString);
        return this;
    }

    public HelpPagesBuilder addHelpPageRename(String oldPagePath, String newPagePath) {
        this.helpPageRenames.put(oldPagePath, newPagePath);
        return this;
    }

    public HelpPagesBuilder addHelpContainer(HelpContainer container) {
        this.helpContainers.add(container);
        return this;
    }

    public HelpPagesBuilder addHelpContainerFor(Object forObject) {
        this.helpContainers.add(new HelpBundleBuilder(forObject.getClass().getPackageName() + ".Help").classLoader(forObject.getClass().getClassLoader()).build());
        return this;
    }

    public HelpPagesBuilder addPage(PageAssembler page) {
        this.pageAssemblers.add(page);
        return this;
    }

    public HelpPagesBuilder addPages(Iterable<PageAssembler> pages) {
        for (PageAssembler page : pages) {
            this.pageAssemblers.add(page);
        }
        return this;
    }

    public HelpPagesBuilder addPagesFor(Type type) {
        return this.addPages(new CommandPageAssemblers(type, new Type[0]));
    }

    public HelpPages build() {
        return new HelpPagesImpl(this);
    }

    private static class AggregatingHelpStrings
    implements HelpStrings {
        private final Map<HelpStringExtension, String> extensionMap;
        private final List<HelpContainer> helpContainers;

        private AggregatingHelpStrings(Map<HelpStringExtension, String> extensionMap, List<HelpContainer> helpContainer) {
            this.extensionMap = extensionMap;
            this.helpContainers = helpContainer;
        }

        @Override
        public String get(String id) {
            Object helpString = this.lookup(id);
            if (helpString == null) {
                helpString = "!" + id + "!";
            }
            return helpString;
        }

        @Override
        public String get(HelpStringExtension extension, String id) {
            String defaultString;
            String key;
            Object helpString;
            String extensionString = this.extensionMap.get(extension);
            if (extensionString == null) {
                extensionString = extension.getDefault();
            }
            if ((helpString = this.lookup(key = id + "_" + extensionString)) == null && extension == Extensions.SUMMARY && (defaultString = this.lookup(id)) != null) {
                int period = defaultString.indexOf(46);
                helpString = period > 0 ? defaultString.substring(0, period) : defaultString;
            }
            if (helpString == null) {
                helpString = "!" + key + "!";
            }
            return helpString;
        }

        private String lookup(String key) {
            for (HelpContainer helpContainer : this.helpContainers) {
                Optional<String> textOpt = helpContainer.get(key);
                if (!textOpt.isPresent()) continue;
                return textOpt.get();
            }
            return null;
        }
    }

    private static class HelpPagesImpl
    implements HelpPages {
        private final int lineSize;
        private final boolean alphaSort;
        private final HelpStrings helpStrings;
        private final List<String> helpPaths = new ArrayList<String>();
        private final Map<String, PageAssembler> pageAssemblerMap = new HashMap<String, PageAssembler>();

        private HelpPagesImpl(HelpPagesBuilder builder) {
            this.lineSize = builder.lineSize;
            this.alphaSort = builder.alphaSort;
            this.helpStrings = new AggregatingHelpStrings(builder.extensionMap, builder.helpContainers);
            for (PageAssembler assembler : builder.pageAssemblers) {
                String pagePath = assembler.getPagePath();
                if (builder.helpPageRenames.containsKey(pagePath)) {
                    pagePath = builder.helpPageRenames.get(pagePath);
                }
                this.helpPaths.add(pagePath);
                if (this.pageAssemblerMap.containsKey(pagePath)) {
                    throw new IllegalArgumentException("duplicate page path '" + pagePath + "' detected for page of class '" + assembler.getClass().getSimpleName());
                }
                this.pageAssemblerMap.put(pagePath, assembler);
            }
        }

        @Override
        public Optional<String> get(String pagePath) {
            PageAssembler pageAssembler = this.pageAssemblerMap.get(pagePath);
            if (pageAssembler != null) {
                return Optional.of(pageAssembler.getPage(this.lineSize, this.alphaSort, this.helpStrings, this.getMoreHelpTopics(pagePath)));
            }
            return Optional.empty();
        }

        private List<String> getMoreHelpTopics(String pagePath) {
            ArrayList<String> moreHelpTopics = new ArrayList<String>();
            String[] pathComponents = null;
            for (String otherPath : this.helpPaths) {
                String tail;
                if (otherPath.length() <= pagePath.length() || !otherPath.startsWith(pagePath) || (tail = otherPath.replace(pagePath + "/", "")).contains("/")) continue;
                if (pathComponents == null) {
                    pathComponents = pagePath.split("/");
                }
                StringBuilder buff = new StringBuilder();
                for (String pathComponent : pathComponents) {
                    buff.append(pathComponent).append(' ');
                }
                buff.append(tail);
                moreHelpTopics.add(buff.toString());
            }
            return moreHelpTopics;
        }
    }

    public static enum Extensions implements HelpStringExtension
    {
        SUMMARY{

            @Override
            public String getDefault() {
                return "SH";
            }
        };

    }
}

