/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.transformer;

import java.util.function.Function;
import oracle.dbtools.raptor.newscriptrunner.util.parser.PrimitiveTransformers;

public abstract class AbstractRangeTransformer<N extends Number>
implements Function<String, N> {
    private final Function<String, N> numberTransformer;
    private final N lower;
    private final N upper;

    protected AbstractRangeTransformer(Class<N> cls, N lower, N upper) {
        this.numberTransformer = PrimitiveTransformers.get(cls);
        this.lower = lower;
        this.upper = upper;
    }

    @Override
    public N apply(String value) {
        Number number = (Number)this.numberTransformer.apply(value);
        if (this.checkRange(number, this.lower, this.upper)) {
            return (N)number;
        }
        throw new IllegalArgumentException();
    }

    protected abstract boolean checkRange(N var1, N var2, N var3);
}

