/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class QuotedStringTokenizer
extends StringTokenizer {
    private static final String __delim = " \t\n\r";
    private String _string;
    private String _delim = " \t\n\r";
    private boolean _returnQuotes = false;
    private boolean _returnDelimiters = false;
    private StringBuilder _token;
    private boolean _hasToken = false;
    private int _i = 0;
    private int _lastStart = 0;
    private boolean _double = true;
    private boolean _single = true;
    private static final String ESCAPABLE_CHARS = "\\\"' ";

    public static String[] tokenize(String str) {
        return new QuotedStringTokenizer(str).toArray();
    }

    public static String[] tokenize(String str, String delimiters) {
        return new QuotedStringTokenizer(str, delimiters).toArray();
    }

    public QuotedStringTokenizer(String str, String delim, boolean returnDelimiters, boolean returnQuotes) {
        super("");
        this._string = str;
        if (delim != null) {
            this._delim = delim;
        }
        this._returnDelimiters = returnDelimiters;
        this._returnQuotes = returnQuotes;
        if (this._delim.indexOf(39) >= 0 || this._delim.indexOf(34) >= 0) {
            throw new Error("Can't use quotes as delimiters: " + this._delim);
        }
        this._token = new StringBuilder(this._string.length() > 1024 ? 512 : this._string.length() / 2);
    }

    public QuotedStringTokenizer(String str, String delim, boolean returnDelimiters) {
        this(str, delim, returnDelimiters, false);
    }

    public QuotedStringTokenizer(String str, String delim) {
        this(str, delim, false, false);
    }

    public QuotedStringTokenizer(String str) {
        this(str, null, false, false);
    }

    public String[] toArray() {
        ArrayList<String> r = new ArrayList<String>();
        while (this.hasMoreTokens()) {
            r.add(this.nextToken());
        }
        return r.toArray(new String[r.size()]);
    }

    @Override
    public boolean hasMoreTokens() {
        if (this._hasToken) {
            return true;
        }
        this._lastStart = this._i;
        int state = 0;
        boolean escape = false;
        block6: while (this._i < this._string.length()) {
            char c = this._string.charAt(this._i++);
            switch (state) {
                case 0: {
                    if (this._delim.indexOf(c) >= 0) {
                        if (!this._returnDelimiters) continue block6;
                        this._token.append(c);
                        this._hasToken = true;
                        return true;
                    }
                    if (c == '\'' && this._single) {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        state = 2;
                        continue block6;
                    }
                    if (c == '\"' && this._double) {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        state = 3;
                        continue block6;
                    }
                    this._token.append(c);
                    this._hasToken = true;
                    state = 1;
                    continue block6;
                }
                case 1: {
                    this._hasToken = true;
                    if (escape) {
                        escape = false;
                        if (ESCAPABLE_CHARS.indexOf(c) < 0) {
                            this._token.append('\\');
                        }
                        this._token.append(c);
                        continue block6;
                    }
                    if (this._delim.indexOf(c) >= 0) {
                        if (this._returnDelimiters) {
                            --this._i;
                        }
                        return this._hasToken;
                    }
                    if (c == '\'' && this._single) {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        state = 2;
                        continue block6;
                    }
                    if (c == '\"' && this._double) {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        state = 3;
                        continue block6;
                    }
                    if (c == '\\') {
                        escape = true;
                        continue block6;
                    }
                    this._token.append(c);
                    continue block6;
                }
                case 2: {
                    this._hasToken = true;
                    if (escape) {
                        escape = false;
                        if (ESCAPABLE_CHARS.indexOf(c) < 0) {
                            this._token.append('\\');
                        }
                        this._token.append(c);
                        continue block6;
                    }
                    if (c == '\'') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        state = 1;
                        continue block6;
                    }
                    if (c == '\\') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        escape = true;
                        continue block6;
                    }
                    this._token.append(c);
                    continue block6;
                }
                case 3: {
                    this._hasToken = true;
                    if (escape) {
                        escape = false;
                        if (ESCAPABLE_CHARS.indexOf(c) < 0) {
                            this._token.append('\\');
                        }
                        this._token.append(c);
                        continue block6;
                    }
                    if (c == '\"') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        state = 1;
                        continue block6;
                    }
                    if (c == '\\') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        escape = true;
                        continue block6;
                    }
                    this._token.append(c);
                    continue block6;
                }
            }
        }
        return this._hasToken;
    }

    public String peekNextToken() {
        if (!this.hasMoreTokens() || this._token == null) {
            throw new NoSuchElementException();
        }
        return this._token.toString();
    }

    @Override
    public String nextToken() throws NoSuchElementException {
        if (!this.hasMoreTokens() || this._token == null) {
            throw new NoSuchElementException();
        }
        String t = this._token.toString();
        this._token.setLength(0);
        this._hasToken = false;
        return t;
    }

    @Override
    public String nextToken(String delim) throws NoSuchElementException {
        this._delim = delim;
        this._i = this._lastStart;
        this._token.setLength(0);
        this._hasToken = false;
        return this.nextToken();
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    @Override
    public Object nextElement() throws NoSuchElementException {
        return this.nextToken();
    }

    @Override
    public int countTokens() {
        return -1;
    }

    public static String quote(String s, String delim) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return "\"\"";
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '\\' && c != '\"' && c != '\'' && !Character.isWhitespace(c) && delim.indexOf(c) < 0) continue;
            StringBuffer b = new StringBuffer(s.length() + 8);
            QuotedStringTokenizer.quote(b, s);
            return b.toString();
        }
        return s;
    }

    public static String quote(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return "\"\"";
        }
        StringBuffer b = new StringBuffer(s.length() + 8);
        QuotedStringTokenizer.quote(b, s);
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void quote(StringBuffer buf, String s) {
        StringBuffer stringBuffer = buf;
        synchronized (stringBuffer) {
            buf.append('\"');
            block12: for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                switch (c) {
                    case '\"': {
                        buf.append("\\\"");
                        continue block12;
                    }
                    case '\\': {
                        buf.append("\\\\");
                        continue block12;
                    }
                    case '\n': {
                        buf.append("\\n");
                        continue block12;
                    }
                    case '\r': {
                        buf.append("\\r");
                        continue block12;
                    }
                    case '\t': {
                        buf.append("\\t");
                        continue block12;
                    }
                    case '\f': {
                        buf.append("\\f");
                        continue block12;
                    }
                    case '\b': {
                        buf.append("\\b");
                        continue block12;
                    }
                    default: {
                        buf.append(c);
                        continue block12;
                    }
                }
            }
            buf.append('\"');
        }
    }

    public static String unquote(String s) {
        char last;
        if (s == null) {
            return null;
        }
        if (s.length() < 2) {
            return s;
        }
        char first = s.charAt(0);
        if (first != (last = s.charAt(s.length() - 1)) || first != '\"' && first != '\'') {
            return s;
        }
        StringBuilder b = new StringBuilder(s.length() - 2);
        boolean escape = false;
        for (int i = 1; i < s.length() - 1; ++i) {
            char c = s.charAt(i);
            if (escape) {
                escape = false;
                switch (c) {
                    case 'n': {
                        b.append('\n');
                        break;
                    }
                    case 'r': {
                        b.append('\r');
                        break;
                    }
                    case 't': {
                        b.append('\t');
                        break;
                    }
                    case 'f': {
                        b.append('\f');
                        break;
                    }
                    case 'b': {
                        b.append('\b');
                        break;
                    }
                    case 'u': {
                        b.append((char)((QuotedStringTokenizer.convertHexDigit((byte)s.charAt(i++)) << 24) + (QuotedStringTokenizer.convertHexDigit((byte)s.charAt(i++)) << 16) + (QuotedStringTokenizer.convertHexDigit((byte)s.charAt(i++)) << 8) + QuotedStringTokenizer.convertHexDigit((byte)s.charAt(i++))));
                        break;
                    }
                    default: {
                        b.append(c);
                        break;
                    }
                }
                continue;
            }
            if (c == '\\') {
                escape = true;
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public boolean getDouble() {
        return this._double;
    }

    public void setDouble(boolean d) {
        this._double = d;
    }

    public boolean getSingle() {
        return this._single;
    }

    public void setSingle(boolean single) {
        this._single = single;
    }

    public static byte convertHexDigit(byte b) {
        if (b >= 48 && b <= 57) {
            return (byte)(b - 48);
        }
        if (b >= 97 && b <= 102) {
            return (byte)(b - 97 + 10);
        }
        if (b >= 65 && b <= 70) {
            return (byte)(b - 65 + 10);
        }
        return 0;
    }
}

