/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scripting;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import oracle.dbtools.scripting.GlobalMap;

public class Scripting {
    public ScriptEngine engine = null;
    public GlobalMap globals = null;

    public ScriptEngine getEngine() {
        if (this.engine == null) {
            try {
                String version = System.getProperty("java.version");
                int dotPos = version.indexOf(46);
                String majorVersion = version.substring(0, dotPos);
                if (11 <= Integer.parseInt(majorVersion)) {
                    System.setProperty("nashorn.args", "--no-deprecation-warning");
                }
            }
            catch (Throwable version) {
                // empty catch block
            }
            System.setProperty("polyglot.js.nashorn-compat", "true");
            ClassLoader myClassLoader = this.getClass().getClassLoader();
            ClassLoader myContextClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(myClassLoader);
            ScriptEngineManager mgr = new ScriptEngineManager();
            this.engine = mgr.getEngineByExtension("js");
            Thread.currentThread().setContextClassLoader(myContextClassLoader);
        }
        return this.engine;
    }

    public GlobalMap getGlobals() {
        if (this.globals == null) {
            ScriptEngine tmp = this.getEngine();
            if (tmp == null) {
                return null;
            }
            this.globals = new GlobalMap(tmp.createBindings());
            this.globals.put("polyglot.js.allowHostAccess", (Object)true);
            this.globals.put("polyglot.js.allowNativeAccess", (Object)true);
            this.globals.put("polyglot.js.allowCreateThread", (Object)true);
            this.globals.put("polyglot.js.allowIO", (Object)true);
            this.globals.put("polyglot.js.allowHostClassLoading", (Object)true);
            this.globals.put("polyglot.js.allowHostClassLookup", s -> true);
            this.globals.put("polyglot.js.allowAllAccess", (Object)true);
            tmp.setBindings(this.globals, 100);
        }
        return this.globals;
    }
}

