/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.xml;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import oracle.dbtools.util.Logger;

public final class MetadataManifest {
    public static final String METADATA_FILE = "META-INF/metadata.json";
    private Collection<String> types;
    private Collection<String> actions;
    private Collection<String> connections;
    private Collection<String> viewers;
    private Collection<String> reports;
    private Collection<String> commonQueries;
    private Collection<DDLInfo> oracleddlinfo;

    public static MetadataManifest createManifest(InputStream in) throws IOException {
        MetadataManifest mf = null;
        JSON json = JSON.std.with(new JSON.Feature[]{JSON.Feature.FAIL_ON_UNKNOWN_BEAN_PROPERTY});
        try {
            mf = (MetadataManifest)json.beanFrom(MetadataManifest.class, (Object)in);
        }
        catch (JsonProcessingException e) {
            Logger.severe(MetadataManifest.class, e.getLocalizedMessage());
        }
        return mf;
    }

    private void setTypes(Collection<String> types) {
        this.types = types;
    }

    private void setActions(Collection<String> actions) {
        this.actions = actions;
    }

    private void setConnections(Collection<String> connections) {
        this.connections = connections;
    }

    private void setViewers(Collection<String> viewers) {
        this.viewers = viewers;
    }

    private void setReports(Collection<String> reports) {
        this.reports = reports;
    }

    private void setCommonQueries(Collection<String> commonQueries) {
        this.commonQueries = commonQueries;
    }

    private void setOracleddlinfo(Collection<DDLInfo> oracleddlinfo) {
        this.oracleddlinfo = oracleddlinfo;
    }

    public Collection<String> types() {
        return this.types;
    }

    public Collection<String> actions() {
        return this.actions;
    }

    public Collection<String> connections() {
        return this.connections;
    }

    public Collection<String> viewers() {
        return this.viewers;
    }

    public Collection<String> reports() {
        return this.reports;
    }

    public Collection<String> commonQueries() {
        return this.commonQueries;
    }

    public Collection<DDLInfo> getOracleDDLInfo() {
        return this.oracleddlinfo;
    }

    public static class DDLInfo
    implements Comparable<DDLInfo> {
        String clazz;
        String objectType;
        String ddlId;
        String queryXML;
        Collection<Bind> binds;

        private void setClazz(String clazz) {
            this.clazz = clazz;
        }

        private void setObjectType(String objectType) {
            this.objectType = objectType;
        }

        private void setDdlId(String ddlId) {
            this.ddlId = ddlId;
        }

        private void setQueryXML(String queryXML) {
            this.queryXML = queryXML;
        }

        private void setBinds(Collection<Bind> binds) {
            this.binds = binds;
        }

        public String getObjectType() {
            return this.objectType;
        }

        public String getQueryXML() {
            return this.queryXML;
        }

        public String getClazz() {
            return this.clazz;
        }

        public String getDdlId() {
            return this.ddlId;
        }

        public Collection<Bind> getBinds() {
            return this.binds;
        }

        public String toString() {
            return this.getObjectType();
        }

        public int hashCode() {
            return this.getObjectType().hashCode();
        }

        @Override
        public int compareTo(DDLInfo ddlInfo) {
            return this.getObjectType().compareTo(ddlInfo.getObjectType());
        }
    }

    public static class Bind
    implements Comparable<Bind> {
        String name;
        String value;

        private void setName(String name) {
            this.name = name;
        }

        private void setValue(String value) {
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getName() + "->" + this.getValue();
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        @Override
        public int compareTo(Bind bind) {
            return this.toString().compareTo(bind.toString());
        }
    }
}

