/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.plaf.TextUI;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class WrappingTextPane
extends JTextPane {
    private boolean lineWrap = true;

    public boolean getLineWrap() {
        return this.lineWrap;
    }

    public void setLineWrap(boolean lineWrap) {
        this.lineWrap = lineWrap;
        this.revalidate();
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.getLineWrap()) {
            return super.getScrollableTracksViewportWidth();
        }
        Container parent = this.getParent();
        if (parent != null) {
            TextUI ui = this.getUI();
            int preferredWidth = ui.getPreferredSize((JComponent)this).width;
            int parentWidth = parent.getWidth();
            if (preferredWidth <= parentWidth) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected EditorKit createDefaultEditorKit() {
        return new WrapEditorKit();
    }

    private class WrapLabelView
    extends LabelView {
        public WrapLabelView(Element elem) {
            super(elem);
        }

        @Override
        public float getMinimumSpan(int axis) {
            switch (axis) {
                case 0: {
                    return 0.0f;
                }
                case 1: {
                    return super.getMinimumSpan(axis);
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + axis);
        }
    }

    private class WrapColumnFactory
    implements ViewFactory {
        private WrapColumnFactory() {
        }

        @Override
        public View create(Element elem) {
            String kind = elem.getName();
            if (kind != null) {
                if (kind.equals("content")) {
                    return new WrapLabelView(elem);
                }
                if (kind.equals("paragraph")) {
                    return new ParagraphView(elem);
                }
                if (kind.equals("section")) {
                    return new BoxView(elem, 1);
                }
                if (kind.equals("component")) {
                    return new ComponentView(elem);
                }
                if (kind.equals("icon")) {
                    return new IconView(elem);
                }
            }
            return new LabelView(elem);
        }
    }

    private class WrapEditorKit
    extends StyledEditorKit {
        ViewFactory defaultFactory;

        private WrapEditorKit() {
            this.defaultFactory = new WrapColumnFactory();
        }

        @Override
        public ViewFactory getViewFactory() {
            return this.defaultFactory;
        }
    }
}

