/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.performance.PerformanceLogger;
import oracle.javatools.util.CopyOnWriteList;

public class IdeSubject
implements Subject {
    final CopyOnWriteList _observers = new CopyOnWriteList(Observer.class);
    private static final Logger _logger = Logger.getLogger(IdeSubject.class.getName());

    @Override
    public final void attach(Observer observer) {
        if (observer != null) {
            this._observers.addIfAbsent((Object)observer);
        }
    }

    @Override
    public final void detach(Observer observer) {
        if (observer != null) {
            this._observers.remove((Object)observer);
        }
    }

    @Override
    public final void notifyObservers(Object observed, UpdateMessage change) {
        Object origin = change != null ? change.getOrigin() : null;
        Object[] observers = this._observers.getItems();
        int n = observers.length;
        for (int i = 0; i < n; ++i) {
            Observer observer = (Observer)observers[i];
            try {
                if (observer == origin) continue;
                long startTime = System.nanoTime();
                observer.update(observed, change);
                long endTime = System.nanoTime();
                PerformanceLogger.get().log("Observer.update", observer.getClass().getName(), endTime - startTime);
                continue;
            }
            catch (Throwable t) {
                _logger.log(Level.SEVERE, "Exception while updating observer[" + i + "]: " + observer, t);
            }
        }
    }
}

