/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl;

import oracle.ide.IdeArgs;
import oracle.ide.IdeRunner;
import oracle.ide.IdeStarter;
import oracle.ide.performance.PerformanceLogger;
import oracle.ideimpl.DefaultIdeCore;
import oracle.ideimpl.DefaultIdeStarter;
import oracle.ideri.util.Product;

public final class Main {
    private Main() {
    }

    public static void main(String[] args) {
        long start = System.nanoTime();
        new Main().start(args);
        PerformanceLogger.get().log("startupTime", "", System.nanoTime() - start);
    }

    private void start(String[] arguments) {
        try {
            IdeStarter starter;
            String productID = Product.getProductID();
            if (productID == null) {
                productID = "oracle.ide";
            }
            String command = System.getProperty("ide.command");
            String starterTypeName = System.getProperty("ide.starter.class");
            if (starterTypeName != null) {
                Class<?> type = Class.forName(starterTypeName);
                starter = (IdeStarter)type.newInstance();
            } else {
                starter = new DefaultIdeStarter();
            }
            DefaultIdeCore ideCore = new DefaultIdeCore(new IdeArgs(arguments), productID);
            starter.startIde(command, arguments, ideCore);
            String runnerTypeName = System.getProperty("ide.runner.class");
            if (runnerTypeName != null) {
                ClassLoader extensionClassLoader = Thread.currentThread().getContextClassLoader();
                Class<?> type = Class.forName(runnerTypeName, true, extensionClassLoader);
                IdeRunner runner = (IdeRunner)type.newInstance();
                runner.runCommand(starter);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }
}

