/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.text.MessageFormat;
import java.util.logging.Level;
import javax.ide.extension.Extension;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.controls.ProgressTrackedTask;
import oracle.ide.extension.ExtensionQueue;
import oracle.ide.extension.feature.Feature;
import oracle.ide.resource.IdeArb;
import oracle.ide.task.Task;
import oracle.ide.task.TaskMonitor;
import oracle.ide.task.event.ProgressEvent;
import oracle.ide.task.event.TaskExitCode;
import oracle.ideimpl.extension.ExtensionManagerImpl;

class ExtensionLoadingTask
extends Task<Object>
implements ProgressTrackedTask {
    private final ExtensionQueue m_extensionQueue;
    private volatile int m_counter;
    private volatile String m_message;

    public ExtensionLoadingTask(ExtensionQueue extensionQueue) {
        super(ExtensionLoadingTask.class.getName(), extensionQueue.size());
        this.m_extensionQueue = extensionQueue;
        this.m_counter = 0;
        this.m_message = IdeArb.getString(527);
    }

    @Override
    public int getTimeLeftSeconds() {
        return 0;
    }

    @Override
    public Object getResult() {
        return null;
    }

    @Override
    public TaskExitCode performTask(TaskMonitor tc) throws Exception {
        for (Extension ext : this.m_extensionQueue) {
            ExtensionRegistry registry;
            Feature feature = ExtensionRegistry.getExtensionRegistry().getFeatureRegistry().getFeatureForExtension(ext.getID());
            this.m_message = MessageFormat.format(IdeArb.getString(526), feature != null ? feature.getDisplayName() : ext.getName());
            if (tc != null) {
                tc.fireProgress(new ProgressEvent(this, ++this.m_counter, 3L, new String[]{this.m_message}));
            }
            if (!((registry = ExtensionRegistry.getExtensionRegistry()) instanceof ExtensionManagerImpl)) continue;
            ((ExtensionManagerImpl)registry).__loadExtensionHooks(ext);
        }
        return TaskExitCode.COMPLETED;
    }

    @Override
    public boolean isIndeterminate() {
        return false;
    }

    @Override
    public int getCurrentValue() {
        return this.m_counter;
    }

    @Override
    public int getMinimum() {
        return 0;
    }

    @Override
    public int getMaximum() {
        return this.m_extensionQueue.size();
    }

    @Override
    public String getCurrentText() {
        return this.m_message;
    }

    @Override
    public String getTaskDescription() {
        return MessageFormat.format(IdeArb.getString(525), Ide.getProgramShortName());
    }

    @Override
    public void run() {
        try {
            this.performTask(null);
        }
        catch (Exception e) {
            ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "Failed while loading extensions in the background");
        }
    }
}

