/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.awt.Color;
import java.util.ArrayList;
import oracle.dss.gauge.BaseGaugeComponent;
import oracle.dss.gauge.CommonGauge;
import oracle.dss.gauge.GaugeDefaultValues;
import oracle.dss.gauge.SFX;
import oracle.javatools.annotations.Concealed;

public class Indicator
extends BaseGaugeComponent {
    private static final Attributes ATTR_TYPE = new Attributes("IndicatorType", GaugeDefaultValues.getIndicatorType());
    private static final Attributes ATTR_USETHRESHOLDFILLCOLOR = new Attributes("IndicatorUseThresholdFillColor", GaugeDefaultValues.isIndicatorUseThresholdFillColor());
    private static final Attributes ATTR_FILLCOLOR = new Attributes("IndicatorFillColor", GaugeDefaultValues.getIndicatorFillColor());
    private static final Attributes ATTR_BORDERCOLOR = new Attributes("IndicatorBorderColor", GaugeDefaultValues.getIndicatorBorderColor());
    private static final Attributes ATTR_BARFILLCOLOR = new Attributes("IndicatorBarFillColor", GaugeDefaultValues.getIndicatorBarFillColor());
    private static final Attributes ATTR_BARBORDERCOLOR = new Attributes("IndicatorBarBorderColor", GaugeDefaultValues.getIndicatorBarBorderColor());
    private static final Attributes ATTR_BASEFILLCOLOR = new Attributes("IndicatorBaseFillColor", GaugeDefaultValues.getIndicatorBaseFillColor());
    private static final Attributes ATTR_BASEBORDERCOLOR = new Attributes("IndicatorBaseBorderColor", GaugeDefaultValues.getIndicatorBaseBorderColor());
    private static final Attributes ATTR_BASEVISIBLE = new Attributes("IndicatorBaseVisible", GaugeDefaultValues.isIndicatorBaseVisible());
    private int size = 0;
    @Concealed
    protected static final String it_line = "IT_LINE";
    @Concealed
    protected static final String it_fill = "IT_FILL";
    @Concealed
    protected static final String it_needle = "IT_NEEDLE";
    @Concealed
    protected static final String a_line = "line";
    @Concealed
    protected static final String a_fill = "fill";
    @Concealed
    protected static final String a_needle = "needle";
    @Concealed
    protected ArrayList<SFX> m_sfx = new ArrayList();
    protected SFX m_base_sfx = null;
    protected ArrayList<SFX> m_bar_sfx = new ArrayList();

    public Indicator(CommonGauge gauge) {
        super(gauge, 14);
    }

    @Concealed
    private Object getFromMap(int index, Attributes attr) {
        Object obj = null;
        if (index >= 0) {
            ArrayList attributeList = (ArrayList)this.m_commonGauge.getAttribute(attr.getName());
            if (attributeList != null && index < attributeList.size()) {
                obj = attributeList.get(index);
            }
        } else if (index == -1) {
            obj = this.m_commonGauge.getAttribute(attr.getName());
        }
        if (obj != null) {
            return obj;
        }
        return attr.getDefaultValue();
    }

    @Concealed
    private void setToMap(int index, Attributes attr, Object objectToSet) {
        if (index >= 0) {
            ArrayList<Object> attributeList;
            if (this.size <= index) {
                this.size = index + 1;
            }
            if ((attributeList = (ArrayList<Object>)this.m_commonGauge.getAttribute(attr.getName())) == null) {
                attributeList = new ArrayList<Object>();
            }
            if (attributeList.size() <= index) {
                for (int i = attributeList.size(); i <= index; ++i) {
                    attributeList.add(null);
                }
            }
            attributeList.set(index, objectToSet);
            this.m_commonGauge.setAttribute(attr.getName(), attributeList);
        } else if (index == -1) {
            this.m_commonGauge.setAttribute(attr.getName(), objectToSet);
        }
    }

    @Concealed
    protected int size() {
        return this.size;
    }

    public Color getFillColor() {
        return this.getFillColor(0);
    }

    public Color getFillColor(int index) {
        return (Color)this.getFromMap(index, ATTR_FILLCOLOR);
    }

    public void setFillColor(Color color) {
        this.setFillColor(color, 0);
    }

    public void setFillColor(Color color, int index) {
        this.setToMap(index, ATTR_FILLCOLOR, color);
    }

    public Color getBorderColor() {
        return this.getBorderColor(0);
    }

    public Color getBorderColor(int index) {
        return (Color)this.getFromMap(index, ATTR_BORDERCOLOR);
    }

    public void setBorderColor(Color color) {
        this.setBorderColor(color, 0);
    }

    public void setBorderColor(Color color, int index) {
        this.setToMap(index, ATTR_BORDERCOLOR, color);
    }

    public int getType() {
        return this.getType(0);
    }

    public int getType(int index) {
        return (Integer)this.getFromMap(index, ATTR_TYPE);
    }

    public void setType(int type) {
        this.setType(new Integer(type), 0);
    }

    public void setType(int type, int index) {
        if (type < 0 || type > 2) {
            this.m_commonGauge.getErrorHandler().log("invalid type", this.getClass().getName(), "setIndicatorType");
            return;
        }
        this.setToMap(index, ATTR_TYPE, new Integer(type));
    }

    public boolean isUseThresholdFillColor() {
        return this.isUseThresholdFillColor(0);
    }

    public boolean isUseThresholdFillColor(int index) {
        return (Boolean)this.getFromMap(index, ATTR_USETHRESHOLDFILLCOLOR);
    }

    public void setUseThresholdFillColor(boolean use) {
        this.setUseThresholdFillColor(use, 0);
    }

    public void setUseThresholdFillColor(boolean use, int index) {
        this.setToMap(index, ATTR_USETHRESHOLDFILLCOLOR, use);
    }

    public Color getBarFillColor() {
        return this.getBarFillColor(0);
    }

    public Color getBarFillColor(int index) {
        return (Color)this.getFromMap(index, ATTR_BARFILLCOLOR);
    }

    public void setBarFillColor(Color color) {
        this.setBarFillColor(color, 0);
    }

    public void setBarFillColor(Color color, int index) {
        this.setToMap(index, ATTR_BARFILLCOLOR, color);
    }

    public Color getBarBorderColor() {
        return this.getBarBorderColor(0);
    }

    public Color getBarBorderColor(int index) {
        return (Color)this.getFromMap(index, ATTR_BARBORDERCOLOR);
    }

    public void setBarBorderColor(Color color) {
        this.setBarBorderColor(color, 0);
    }

    public void setBarBorderColor(Color color, int index) {
        this.setToMap(index, ATTR_BARBORDERCOLOR, color);
    }

    public Color getBaseFillColor() {
        return (Color)this.getFromMap(-1, ATTR_BASEFILLCOLOR);
    }

    public void setBaseFillColor(Color color) {
        this.setToMap(-1, ATTR_BASEFILLCOLOR, color);
    }

    public Color getBaseBorderColor() {
        return (Color)this.getFromMap(-1, ATTR_BASEBORDERCOLOR);
    }

    public void setBaseBorderColor(Color color) {
        this.setToMap(-1, ATTR_BASEBORDERCOLOR, color);
    }

    public boolean isBaseVisible() {
        return (Boolean)this.getFromMap(-1, ATTR_BASEVISIBLE);
    }

    public void setBaseVisible(boolean visible) {
        this.setToMap(-1, ATTR_BASEVISIBLE, visible);
    }

    @Concealed
    public static int convertTypeToInt(String type) {
        int iType = 0;
        if (type.equals(it_fill) || type.equalsIgnoreCase(a_fill)) {
            iType = 1;
        } else if (type.equals(it_needle) || type.equalsIgnoreCase(a_needle)) {
            iType = 2;
        }
        return iType;
    }

    @Concealed
    public static String convertTypeToString(int type) {
        String iType = it_line;
        if (type == 1) {
            iType = it_fill;
        } else if (type == 2) {
            iType = it_needle;
        }
        return iType;
    }

    @Concealed
    private SFX getSpecificSFX(int index, ArrayList<SFX> theSFX, int compID) {
        if (index >= 0) {
            if (this.size <= index) {
                this.size = index + 1;
            }
            if (theSFX.size() <= index) {
                for (int i = theSFX.size(); i <= index; ++i) {
                    theSFX.add(null);
                }
            }
            if (theSFX.get(index) == null) {
                SFX newSFX = new SFX(this.m_commonGauge, compID, index);
                theSFX.set(index, newSFX);
            }
            return theSFX.get(index);
        }
        return null;
    }

    public SFX getSFX() {
        return this.getSFX(0);
    }

    public SFX getSFX(int index) {
        return this.getSpecificSFX(index, this.m_sfx, 14);
    }

    public SFX getBaseSFX() {
        if (this.m_base_sfx == null) {
            this.m_base_sfx = new SFX(this.m_commonGauge, 30);
        }
        return this.m_base_sfx;
    }

    public SFX getBarSFX() {
        return this.getBarSFX(0);
    }

    public SFX getBarSFX(int index) {
        return this.getSpecificSFX(index, this.m_bar_sfx, 31);
    }

    private static class Attributes {
        private String nameFromMap = null;
        private Object defaultValue = null;

        public Attributes(String nameFromMap, Object defaultValue) {
            this.nameFromMap = nameFromMap;
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.nameFromMap;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }
    }
}

