/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.renderers.utils;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.List;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.graph.SFX;
import oracle.dss.presutil.GradientObj;
import oracle.dss.presutil.GradientStopObj;
import oracle.dss.presutil.XMLWriter;

public class GradientUtils {
    public static final String VAL_GD_RADIAL = "gdR";
    public static final String VAL_GD_RIGHT = "gdRi";
    public static final String VAL_GD_DOWN = "gdD";
    public static final String VAL_GD_DIAGONAL_45 = "gdD45";
    public static final String VAL_GD_DIAGONAL_135 = "gdD135";
    public static final String ATTR_COLOR = "c";
    public static final String ATTR_POSITION = "p";

    public static String convertGradientDirectionToXMLString(int direction) {
        switch (direction) {
            case 1: {
                return VAL_GD_RIGHT;
            }
            case 3: {
                return VAL_GD_DOWN;
            }
            case 5: {
                return VAL_GD_DIAGONAL_45;
            }
            case 7: {
                return VAL_GD_DIAGONAL_135;
            }
            case 9: {
                return VAL_GD_RADIAL;
            }
        }
        return null;
    }

    protected static void writeGradientStopAttributes(GradientObj gradient, boolean bReverseStops, XMLWriter writer) throws IOException, Exception {
        if (gradient == null) {
            return;
        }
        int pinCount = 0;
        List<GradientStopObj> pins = null;
        if (gradient != null) {
            pins = gradient.getStopList();
            pinCount = pins.size();
        }
        if (!bReverseStops) {
            StringBuilder pos = DataviewUtils.getSharedStringBuilder();
            StringBuilder c = DataviewUtils.getSharedStringBuilder2();
            for (int pin = 0; pin < pinCount; ++pin) {
                if (pos.length() > 0) {
                    pos.append(",");
                }
                if (c.length() > 0) {
                    c.append(",");
                }
                GradientStopObj colorPinObj = null;
                if (pins != null) {
                    colorPinObj = pins.get(pin);
                }
                double offset = 0.5;
                if (colorPinObj != null) {
                    offset = colorPinObj.getPosition();
                }
                Color color = null;
                if (colorPinObj != null) {
                    color = colorPinObj.getColor();
                }
                pos.append(offset);
                c.append(XMLWriter.colorToHexWithAlpha(color));
            }
            writer.writeAttribute(ATTR_POSITION, pos.toString());
            writer.writeAttribute(ATTR_COLOR, c.toString());
        } else {
            StringBuilder pos = DataviewUtils.getSharedStringBuilder();
            StringBuilder c = DataviewUtils.getSharedStringBuilder2();
            for (int pin = pinCount - 1; pin >= 0; --pin) {
                if (pos.length() > 0) {
                    pos.append(",");
                }
                if (c.length() > 0) {
                    c.append(",");
                }
                GradientStopObj colorPinObj = null;
                if (pins != null) {
                    colorPinObj = pins.get(pin);
                }
                double offset = 0.5;
                if (colorPinObj != null) {
                    offset = colorPinObj.getPosition();
                }
                Color color = null;
                if (colorPinObj != null) {
                    color = colorPinObj.getColor();
                }
                pos.append(1.0 - offset);
                c.append(XMLWriter.colorToHexWithAlpha(color));
            }
            writer.writeAttribute(ATTR_POSITION, pos.toString());
            writer.writeAttribute(ATTR_COLOR, c.toString());
        }
    }

    public static void writeGradientElement(GradientObj gradient, Rectangle rect, String elemType, String id, XMLWriter writer) throws IOException, Exception {
        if (gradient == null) {
            return;
        }
        int direction = gradient.getDirectionConstant();
        boolean bReverseStops = false;
        boolean bRadialCorner = false;
        int oldDirection = direction;
        switch (direction) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                direction = SFX._calcReversedGradientDirection(direction);
                bReverseStops = true;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                direction = 9;
                bRadialCorner = true;
                break;
            }
        }
        String sDirection = GradientUtils.convertGradientDirectionToXMLString(direction);
        if (sDirection == null || sDirection.length() == 0) {
            sDirection = GradientUtils.convertGradientDirectionToXMLString(1);
        }
        if (sDirection != null) {
            writer.startElement(elemType);
            writer.writeAttribute("id", id);
            writer.writeAttribute("dir", sDirection);
            if (rect != null) {
                writer.writeAttribute("b", rect.x + "," + rect.y + "," + rect.width + "," + rect.height);
                if (direction == 9) {
                    if (!bRadialCorner) {
                        int cx = rect.x + rect.width / 2;
                        int cy = rect.y + rect.height / 2;
                        writer.writeAttribute("cx", cx);
                        writer.writeAttribute("cy", cy);
                        if (rect.width == rect.height) {
                            writer.writeAttribute("r", rect.width / 2);
                        } else {
                            writer.writeAttribute("rx", rect.width / 2);
                            writer.writeAttribute("ry", rect.height / 2);
                        }
                    } else {
                        int cx = 0;
                        int cy = 0;
                        switch (oldDirection) {
                            case 12: {
                                cx = rect.x;
                                cy = rect.y + rect.height;
                                break;
                            }
                            case 13: {
                                cx = rect.x + rect.width;
                                cy = rect.y + rect.height;
                                break;
                            }
                            case 10: {
                                cx = rect.x;
                                cy = rect.y;
                                break;
                            }
                            case 11: {
                                cx = rect.x + rect.width;
                                cy = rect.y;
                            }
                        }
                        writer.writeAttribute("cx", cx);
                        writer.writeAttribute("cy", cy);
                        double scale = 1.41;
                        if (rect.width == rect.height) {
                            writer.writeAttribute("r", Math.round(scale * (double)rect.width));
                        } else {
                            writer.writeAttribute("rx", Math.round(scale * (double)rect.width));
                            writer.writeAttribute("ry", Math.round(scale * (double)rect.height));
                        }
                    }
                }
            }
            GradientUtils.writeGradientStopAttributes(gradient, bReverseStops, writer);
            writer.endElement();
        }
    }
}

