/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.raptor.ssh.SshSupportResources;
import oracle.dbtools.raptor.ssh.core.Client;
import oracle.dbtools.raptor.ssh.core.HostDescriptor;
import oracle.dbtools.raptor.ssh.core.Store;
import oracle.dbtools.raptor.ssh.core.TunnelDescriptor;
import oracle.dbtools.raptor.ssh.ui.SSHDefinitionPanel;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.ide.Ide;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;

public abstract class TunnelDefinitionPanel
extends SSHDefinitionPanel {
    static final String TYPE_KEY = "Tunnel.Type";
    static final String NAMES_KEY = "SSHDefinition.Names";
    static final String DESC_KEY = "SSHDefinition.TunnelDescriptor";
    private JTextField mFldName = new JTextField();
    private JTextField mFldRHost = new JTextField();
    private WholeNumberField mFldRPort = new WholeNumberField(5);
    private JRadioButton mRadAutoAssignPort = new JRadioButton();
    private JRadioButton mRadCustomPort = new JRadioButton();
    private WholeNumberField mFldLPort = new WholeNumberField(5);

    protected static boolean runDialog(String string, TunnelDefinitionPanel tunnelDefinitionPanel, Namespace namespace) {
        TDialogLauncher tDialogLauncher = new TDialogLauncher((Component)Ide.getMainWindow(), string, (Traversable)tunnelDefinitionPanel, namespace);
        tDialogLauncher.setPackDialog(true);
        JEWTDialog jEWTDialog = tDialogLauncher.initDialog();
        jEWTDialog.setInitialFocus(tunnelDefinitionPanel.getInitialFocusComponent());
        jEWTDialog.getAccessibleContext().setAccessibleName(string);
        return tDialogLauncher.showDialog();
    }

    public static void createTunnelDefinition(Client client, HostDescriptor hostDescriptor, TunnelDescriptor.Type type) {
        TunnelDescriptor tunnelDescriptor;
        TunnelDefinitionPanel tunnelDefinitionPanel;
        String string;
        if (type == TunnelDescriptor.Type.LOCAL) {
            string = SshSupportResources.format("TUNNEL_TITLE_NEW", SshSupportResources.getString("TUNNEL_TITLE_TYPE_LOCAL"));
            tunnelDefinitionPanel = new LocalTunnelDefinitionPanel();
        } else {
            string = SshSupportResources.format("TUNNEL_TITLE_NEW", SshSupportResources.getString("TUNNEL_TITLE_TYPE_REMOTE"));
            tunnelDefinitionPanel = new RemoteTunnelDefinitionPanel();
        }
        Namespace namespace = TunnelDefinitionPanel.createNamespace(type, hostDescriptor, null);
        if (TunnelDefinitionPanel.runDialog(string, tunnelDefinitionPanel, namespace) && (tunnelDescriptor = (TunnelDescriptor)namespace.get(DESC_KEY)) != null) {
            client.getStore().addTunnel(hostDescriptor, tunnelDescriptor);
        }
    }

    private static Namespace createNamespace(TunnelDescriptor.Type type, HostDescriptor hostDescriptor, String string) {
        Namespace namespace = new Namespace();
        namespace.put(TYPE_KEY, (Object)type);
        Store store = Client.getInstance().getStore();
        HashSet hashSet = new HashSet(store.listTunnels(hostDescriptor.getName()));
        if (string != null) {
            hashSet.remove(string);
        }
        namespace.put(NAMES_KEY, hashSet);
        return namespace;
    }

    public static void editTunnelDefinition(Client client, HostDescriptor hostDescriptor, TunnelDescriptor tunnelDescriptor) {
        TunnelDescriptor tunnelDescriptor2;
        TunnelDefinitionPanel tunnelDefinitionPanel;
        String string;
        TunnelDescriptor.Type type = tunnelDescriptor.getType();
        if (type == TunnelDescriptor.Type.LOCAL) {
            string = SshSupportResources.format("TUNNEL_TITLE_EDIT", SshSupportResources.getString("TUNNEL_TITLE_TYPE_LOCAL"));
            tunnelDefinitionPanel = new LocalTunnelDefinitionPanel();
        } else {
            string = SshSupportResources.format("TUNNEL_TITLE_EDIT", SshSupportResources.getString("TUNNEL_TITLE_TYPE_REMOTE"));
            tunnelDefinitionPanel = new RemoteTunnelDefinitionPanel();
        }
        Namespace namespace = TunnelDefinitionPanel.createNamespace(type, hostDescriptor, tunnelDescriptor.getName());
        namespace.put(DESC_KEY, (Object)tunnelDescriptor);
        if (TunnelDefinitionPanel.runDialog(string, tunnelDefinitionPanel, namespace) && (tunnelDescriptor2 = (TunnelDescriptor)namespace.get(DESC_KEY)) != null && ModelUtil.areDifferent((Object)tunnelDescriptor, (Object)tunnelDescriptor2)) {
            client.getStore().updateTunnel(hostDescriptor, tunnelDescriptor, tunnelDescriptor2);
        }
    }

    static TunnelDefinitionPanel createTunnelDefinitionPanel(TunnelDescriptor.Type type) {
        TunnelDefinitionPanel tunnelDefinitionPanel = null;
        if (type == TunnelDescriptor.Type.LOCAL) {
            tunnelDefinitionPanel = new LocalTunnelDefinitionPanel();
        } else if (type == TunnelDescriptor.Type.REMOTE) {
            tunnelDefinitionPanel = new RemoteTunnelDefinitionPanel();
        }
        return tunnelDefinitionPanel;
    }

    public TunnelDefinitionPanel() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.mRadAutoAssignPort);
        buttonGroup.add(this.mRadCustomPort);
        this.mRadCustomPort.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                TunnelDefinitionPanel.this.mFldLPort.setEnabled(itemEvent.getStateChange() == 1);
            }
        });
        this.mFldLPort.setEnabled(false);
    }

    public void setEnabled(boolean bl) {
        this.mFldName.setEnabled(bl);
        this.mFldRHost.setEnabled(bl);
        this.mFldRPort.setEnabled(bl);
        this.mRadAutoAssignPort.setEnabled(bl);
        this.mRadCustomPort.setEnabled(bl);
        this.mFldLPort.setEnabled(bl & this.mRadCustomPort.isSelected());
    }

    public String getHelpID() {
        return "f1_sshportforward_html";
    }

    protected abstract String getLabelType();

    protected Component createComponent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = 0;
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.mFldName, (String)SshSupportResources.getString("TUNNEL_LABEL_NAME"));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        jPanel.add((Component)this.mFldName, LayoutControl.GBC.gbc((int)1, (int)n, (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.mFldRHost, (String)SshSupportResources.getString("TUNNEL_LABEL_RHOST"));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel.add((Component)this.mFldRHost, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.mFldRPort, (String)SshSupportResources.getString("TUNNEL_LABEL_RPORT"));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)2, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2CONTROL_COMP));
        jPanel.add((Component)this.mFldRPort, LayoutControl.GBC.gbc((int)3, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        ResourceUtils.resButton((AbstractButton)this.mRadAutoAssignPort, (String)SshSupportResources.format("TUNNEL_LABEL_AUTO_LPORT", this.getLabelType()));
        jPanel.add((Component)this.mRadAutoAssignPort, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        ResourceUtils.resButton((AbstractButton)this.mRadCustomPort, (String)SshSupportResources.format("TUNNEL_LABEL_SPECIFIC_LPORT", this.getLabelType()));
        jPanel.add((Component)this.mRadCustomPort, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)this.mFldLPort, LayoutControl.GBC.gbc((int)3, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        return jPanel;
    }

    public Component getInitialFocusComponent() {
        return this.mFldName;
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        TunnelDescriptor.Type type = (TunnelDescriptor.Type)traversableContext.get(TYPE_KEY);
        Set set = (Set)traversableContext.get(NAMES_KEY);
        TunnelDescriptor tunnelDescriptor = this.commit(type, set);
        traversableContext.put(DESC_KEY, (Object)tunnelDescriptor);
    }

    protected TunnelDescriptor commit(TunnelDescriptor.Type type, Set<String> set) throws TraversalException {
        int n;
        int n2;
        String string = this.mFldName.getText();
        if (!ModelUtil.hasLength((String)string)) {
            throw new TraversalException(SshSupportResources.getString("TUNNEL_ERROR_NAME"));
        }
        if (set.contains(string)) {
            throw new TraversalException(SshSupportResources.format("TUNNEL_ERROR_DUPLICATE_NAME", string));
        }
        String string2 = this.mFldRHost.getText();
        if (!ModelUtil.hasLength((String)string2)) {
            throw new TraversalException(SshSupportResources.getString("SSH_ERROR_HOST"));
        }
        Number number = this.mFldRPort.getNumber();
        int n3 = n2 = number != null ? number.intValue() : -1;
        if (n2 <= 0 || n2 > 65535) {
            throw new TraversalException(SshSupportResources.get("SSH_ERROR_PORT"));
        }
        if (this.mRadAutoAssignPort.isSelected()) {
            n = 0;
        } else {
            number = this.mFldLPort.getNumber();
            int n4 = n = number != null ? number.intValue() : 0;
            if (n <= 0 || n > 65535) {
                throw new TraversalException(SshSupportResources.get("SSH_ERROR_PORT"));
            }
        }
        TunnelDescriptor.Builder builder = new TunnelDescriptor.Builder(string, type);
        builder.host(string2).hostPort(n2).port(n);
        return builder.getDescriptor();
    }

    public void onEntry(TraversableContext traversableContext) {
        TunnelDescriptor tunnelDescriptor = (TunnelDescriptor)traversableContext.get(DESC_KEY);
        this.init(tunnelDescriptor);
    }

    protected void init(TunnelDescriptor tunnelDescriptor) {
        String string = SshSupportResources.getString("DEFAULT_NAME");
        String string2 = "localhost";
        int n = 1521;
        int n2 = 0;
        if (tunnelDescriptor != null) {
            string = tunnelDescriptor.getName();
            string2 = tunnelDescriptor.getHostname();
            n = tunnelDescriptor.getHostport();
            n2 = tunnelDescriptor.getPort();
        }
        this.mFldName.setText(string);
        this.mFldRHost.setText(string2);
        this.mFldRPort.setNumber((Number)n);
        if (n2 > 0) {
            this.mRadCustomPort.setSelected(true);
            this.mFldLPort.setNumber((Number)n2);
        } else {
            this.mRadAutoAssignPort.setSelected(true);
        }
    }

    private static class RemoteTunnelDefinitionPanel
    extends TunnelDefinitionPanel {
        private RemoteTunnelDefinitionPanel() {
        }

        @Override
        protected String getLabelType() {
            return SshSupportResources.getString("TUNNEL_TYPE_REMOTE");
        }
    }

    private static class LocalTunnelDefinitionPanel
    extends TunnelDefinitionPanel {
        private LocalTunnelDefinitionPanel() {
        }

        @Override
        protected String getLabelType() {
            return SshSupportResources.getString("TUNNEL_TYPE_LOCAL");
        }
    }
}

