/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.actions.Messages;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorManager;
import oracle.dbtools.migration.workbench.core.navigator.nodes.MigrationProjectNode;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskUtils;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.MessageDialog;

public class MigrationMoveToProject
extends AbstractMenuAction {
    private JPanel optionsPanel = null;
    private ArrayList<Long> conId = new ArrayList();
    private ArrayList<String> projName = new ArrayList();
    private ArrayList<Long> pIdArray = new ArrayList();
    private ArrayList<String> conType = new ArrayList();
    private ArrayList<Long> catId = new ArrayList();
    private ArrayList<String[]> projectNameUnique = new ArrayList();
    private ArrayList<String[]> projectNameAllPlugins = new ArrayList();
    private ArrayList<String> projectPluginString = new ArrayList();
    private ArrayList<String> conName = new ArrayList();
    private ArrayList<Long> minConId = new ArrayList();
    private JLabel jLabelFromProject = new JLabel();
    private JComboBox jComboFromConn = new JComboBox();
    private JComboBox jComboToProj = new JComboBox();
    private JComboBox jComboToConn = new JComboBox();
    private String finalRealName = null;
    private ArrayList<String> comboFromConnName = new ArrayList();
    private ArrayList<Long> comboFromConnId = new ArrayList();
    private ArrayList<String> comboToConnName = new ArrayList();
    private ArrayList<Long> comboToConnId = new ArrayList();
    private DatabaseQueryTask<ArrayList<String[]>> populateJCombo = null;

    public boolean isEnabled(Context context) {
        return true;
    }

    private void kickOffTask(final DBObject dBObject, final MigrationPlugin.ProjectMergeLevel projectMergeLevel) {
        this.populateJCombo = new DatabaseQueryTask<ArrayList<String[]>>(Messages.getString("Name"), IRaptorTaskRunMode.NO_GUI, false, false){
            String sqlCatalog;
            String sql;
            {
                super(string, iRaptorTaskRunMode, bl, bl2);
                this.sqlCatalog = "SELECT con.id,    p.project_name,   p.id,   con.type,   addprop.value, -1, -1, con.name  FROM md_connections con,   md_projects p, md_additional_properties addprop  WHERE p.id     =con.project_id_fk AND (con.type IS NULL  OR con.type    = 'CONVERTED') AND addprop.prop_key='PLUGIN_ID'  AND addprop.REF_TYPE='MD_CONNECTIONS' AND addprop.ref_id_fk = con.id      order by p.project_name, con.id desc";
                this.sql = "Select i.mid, i.pname pname, i.pid pid, i.ctype ctype, i.avalue avalue, i.minid minid,  (select MAX(innercat.id) from  md_catalogs innercat where innercat.connection_id_fk = i.mid) maxcatid, i.ciname cname FROM (SELECT con.id mid,    p.project_name pname,   p.id pid,   con.type ctype,   addprop.value avalue, -1 minid, con.name ciname  FROM md_connections con,    md_projects p, md_additional_properties addprop  WHERE p.id     =con.project_id_fk AND (con.type IS NULL  OR con.type    = 'CONVERTED') AND addprop.prop_key='PLUGIN_ID'  AND addprop.REF_TYPE='MD_CONNECTIONS' AND addprop.ref_id_fk = con.id    ) i order by i.pname, i.mid desc";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected ArrayList<String[]> doWork() throws TaskException {
                block19: {
                    String string = null;
                    MigrationProjectNode migrationProjectNode = null;
                    try {
                        Statement statement = null;
                        HashSet<String> hashSet = new HashSet<String>();
                        ResultSet resultSet = null;
                        String string2 = "";
                        Connection connection = dBObject.getConnection();
                        if (!Connections.getInstance().lock(connection)) break block19;
                        try {
                            if (dBObject.getNode() instanceof MigrationProjectNode) {
                                migrationProjectNode = (MigrationProjectNode)dBObject.getNode();
                                MigrationMoveToProject.this.finalRealName = string = migrationProjectNode.getMdProject().getObjectName();
                            }
                            statement = connection.createStatement();
                            resultSet = projectMergeLevel.equals((Object)MigrationPlugin.ProjectMergeLevel.PROJECT_MERGE_LEVEL_CATALOG) ? statement.executeQuery(this.sqlCatalog) : statement.executeQuery(this.sql);
                            Long l = -1L;
                            while (resultSet.next()) {
                                String string3 = "";
                                String string4 = "";
                                MigrationMoveToProject.this.conId.add(resultSet.getLong(1));
                                string3 = resultSet.getString(2);
                                MigrationMoveToProject.this.projName.add(string3);
                                l = resultSet.getLong(3);
                                MigrationMoveToProject.this.pIdArray.add(l);
                                string4 = resultSet.getString(4);
                                String string5 = resultSet.getString(5);
                                MigrationMoveToProject.this.minConId.add(resultSet.getLong(6));
                                MigrationMoveToProject.this.conType.add(string4);
                                MigrationMoveToProject.this.catId.add(resultSet.getLong(7));
                                MigrationMoveToProject.this.conName.add(resultSet.getString(8));
                                if (string3.equals(string)) {
                                    string2 = string5;
                                }
                                if (string4 != null && !string4.equals("") || string3.equals(string) || hashSet.contains(string3)) continue;
                                MigrationMoveToProject.this.projectNameAllPlugins.add(new String[]{string3, l.toString()});
                                MigrationMoveToProject.this.projectPluginString.add(string5);
                                hashSet.add(string3);
                            }
                            for (int i = 0; i < MigrationMoveToProject.this.projectNameAllPlugins.size(); ++i) {
                                if (!MigrationMoveToProject.this.projectPluginString.get(i).equals(string2)) continue;
                                MigrationMoveToProject.this.projectNameUnique.add(MigrationMoveToProject.this.projectNameAllPlugins.get(i));
                            }
                        }
                        finally {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (SQLException sQLException) {
                                    Logger.info(((Object)((Object)this)).getClass(), (String)sQLException.getMessage());
                                }
                            }
                            if (statement != null) {
                                try {
                                    statement.close();
                                }
                                catch (SQLException sQLException) {
                                    Logger.info(((Object)((Object)this)).getClass(), (String)sQLException.getMessage());
                                }
                            }
                            Connections.getInstance().unlock(connection);
                        }
                    }
                    catch (Exception exception) {
                        throw new TaskException((Throwable)exception);
                    }
                }
                return MigrationMoveToProject.this.projectNameUnique;
            }

            public String getQuery() {
                if (projectMergeLevel.equals((Object)MigrationPlugin.ProjectMergeLevel.PROJECT_MERGE_LEVEL_CATALOG)) {
                    return this.sqlCatalog;
                }
                return this.sql;
            }

            public String getConnectionName() {
                return dBObject.getConnectionName();
            }
        };
        RaptorTaskManager.getInstance().addTask(this.populateJCombo);
        this.populateJCombo.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.error(null, (Object)raptorTaskEvent.getThrowable().getMessage(), (String)Messages.getString("ProjecMergeTaskFailed"), null);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeLater(runnable);
                }
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                Logger.severe(((Object)((Object)this)).getClass(), (String)Messages.getString("ProjecMergeTaskCancelled"));
                Logger.severe(((Object)((Object)this)).getClass(), (String)RaptorTaskUtils.getErrorMessage((Throwable)raptorTaskEvent.getThrowable()));
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                try {
                    final ArrayList arrayList = (ArrayList)MigrationMoveToProject.this.populateJCombo.getResult();
                    if (arrayList != null && arrayList.size() > 0 && MigrationMoveToProject.this.finalRealName != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MigrationMoveToProject.this.comboFromConnName = new ArrayList();
                                MigrationMoveToProject.this.comboFromConnId = new ArrayList();
                                MigrationMoveToProject.this.comboToConnName = new ArrayList();
                                MigrationMoveToProject.this.comboToConnId = new ArrayList();
                                MigrationMoveToProject.this.jLabelFromProject.setText(MigrationMoveToProject.this.finalRealName);
                                for (int i = 0; i < MigrationMoveToProject.this.projName.size(); ++i) {
                                    if (!MigrationMoveToProject.this.projName.get(i).equals(MigrationMoveToProject.this.finalRealName) || MigrationMoveToProject.this.conType.get(i) != null && !MigrationMoveToProject.this.conType.equals("")) continue;
                                    MigrationMoveToProject.this.comboFromConnName.add(MigrationMoveToProject.this.conName.get(i));
                                    MigrationMoveToProject.this.comboFromConnId.add(MigrationMoveToProject.this.conId.get(i));
                                }
                                MigrationMoveToProject.this.jComboFromConn.setModel(new DefaultComboBoxModel<String>(MigrationMoveToProject.this.comboFromConnName.toArray(new String[MigrationMoveToProject.this.comboFromConnName.size()])));
                                ArrayList<String> arrayList2 = new ArrayList<String>();
                                int n = -1;
                                int n2 = -1;
                                for (int i = 0; i < arrayList.size(); ++i) {
                                    arrayList2.add(((String[])arrayList.get(i))[0]);
                                    if (n >= Integer.parseInt(((String[])arrayList.get(i))[1])) continue;
                                    n = Integer.parseInt(((String[])arrayList.get(i))[1]);
                                    n2 = i;
                                }
                                MigrationMoveToProject.this.jComboToProj.setModel(new DefaultComboBoxModel<String>(arrayList2.toArray(new String[arrayList2.size()])));
                                MigrationMoveToProject.this.jComboToProj.setSelectedIndex(n2);
                                this.resetToConn();
                                MigrationMoveToProject.this.jComboToProj.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent actionEvent) {
                                        this.resetToConn();
                                    }
                                });
                            }

                            private void resetToConn() {
                                String string = (String)MigrationMoveToProject.this.jComboToProj.getSelectedItem();
                                MigrationMoveToProject.this.comboToConnName = new ArrayList();
                                MigrationMoveToProject.this.comboToConnId = new ArrayList();
                                for (int i = 0; i < MigrationMoveToProject.this.projName.size(); ++i) {
                                    if (!MigrationMoveToProject.this.projName.get(i).equals(string) || MigrationMoveToProject.this.conType.get(i) != null && !MigrationMoveToProject.this.conType.equals("")) continue;
                                    MigrationMoveToProject.this.comboToConnName.add(MigrationMoveToProject.this.conName.get(i));
                                    MigrationMoveToProject.this.comboToConnId.add(MigrationMoveToProject.this.conId.get(i));
                                }
                                MigrationMoveToProject.this.jComboToConn.setModel(new DefaultComboBoxModel<String>(MigrationMoveToProject.this.comboToConnName.toArray(new String[MigrationMoveToProject.this.comboToConnName.size()])));
                            }
                        });
                    }
                }
                catch (InterruptedException interruptedException) {
                    Logger.ignore(((Object)((Object)this)).getClass(), (Throwable)interruptedException);
                }
                catch (ExecutionException executionException) {
                    Logger.warn(((Object)((Object)this)).getClass(), (Throwable)executionException);
                }
            }
        });
    }

    protected JComponent getOptionsPanel(DBObject dBObject) {
        if (null == this.optionsPanel) {
            this.optionsPanel = LayoutControl.GBC.createPanel();
            this.jLabelFromProject = new JLabel();
            this.jComboFromConn = new JComboBox();
            this.jComboToProj = new JComboBox();
            this.jComboToConn = new JComboBox();
            JLabel jLabel = new JLabel(StringUtils.stripMnemonic((String)Messages.getString("ConnectionTag")));
            JLabel jLabel2 = new JLabel(StringUtils.stripMnemonic((String)Messages.getString("ConnectionTag2")));
            JLabel jLabel3 = new JLabel(StringUtils.stripMnemonic((String)Messages.getString("ProjectTag2")));
            this.optionsPanel.add((Component)new JLabel(Messages.getString("FromTag")), LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
            this.optionsPanel.add((Component)new JLabel(Messages.getString("ProjectTag")), LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
            this.optionsPanel.add((Component)this.jLabelFromProject, LayoutControl.GBC.gbc((int)1, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            this.optionsPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
            this.optionsPanel.add((Component)this.jComboFromConn, LayoutControl.GBC.gbc((int)1, (int)2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            this.optionsPanel.add((Component)new JLabel(Messages.getString("ToTag")), LayoutControl.GBC.gbc((int)0, (int)3, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
            this.optionsPanel.add((Component)jLabel3, LayoutControl.GBC.gbc((int)0, (int)4, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
            this.optionsPanel.add((Component)this.jComboToProj, LayoutControl.GBC.gbc((int)1, (int)4, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            this.optionsPanel.add((Component)jLabel2, LayoutControl.GBC.gbc((int)0, (int)5, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
            this.optionsPanel.add((Component)this.jComboToConn, LayoutControl.GBC.gbc((int)1, (int)5, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            jLabel.setLabelFor(this.jComboFromConn);
            jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("ConnectionTag")));
            jLabel2.setLabelFor(this.jComboToConn);
            jLabel2.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("ConnectionTag2")));
            jLabel3.setLabelFor(this.jComboToProj);
            jLabel3.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("ProjectTag2")));
        }
        return this.optionsPanel;
    }

    public void launch() {
        DBObject dBObject = this.getDBObject();
        if (dBObject.getConnection() == null) {
            return;
        }
        new MigrationMoveToProject().validatePlugin(dBObject);
    }

    protected String getSelectedProject() {
        return (String)this.jComboToProj.getSelectedItem();
    }

    protected DatabaseQueryTask<String> getTask(String string, DBObject dBObject, MigrationPlugin.ProjectMergeLevel projectMergeLevel, PersistenceManager persistenceManager, Long l, Long l2) {
        MigrationMoveToProjectTask migrationMoveToProjectTask = new MigrationMoveToProjectTask(this.conId, this.projName, this.pIdArray, this.conType, this.minConId, Messages.getString("MoveToProject"), string, dBObject, projectMergeLevel, this.catId, persistenceManager, l, l2);
        return migrationMoveToProjectTask;
    }

    private void validatePlugin(final DBObject dBObject) {
        DatabaseQueryTask<MigrationPlugin.ProjectMergeLevel> databaseQueryTask = new DatabaseQueryTask<MigrationPlugin.ProjectMergeLevel>(Messages.getString("Name"), IRaptorTaskRunMode.NO_GUI, false, false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected MigrationPlugin.ProjectMergeLevel doWork() throws TaskException {
                Enum enum_;
                block14: {
                    String string = null;
                    MigrationProjectNode migrationProjectNode = null;
                    enum_ = null;
                    try {
                        Connection connection = dBObject.getConnection();
                        if (!Connections.getInstance().lock(connection)) break block14;
                        try {
                            if (dBObject.getNode() instanceof MigrationProjectNode) {
                                migrationProjectNode = (MigrationProjectNode)dBObject.getNode();
                                string = migrationProjectNode.getMdProject().getObjectName();
                            }
                            if (migrationProjectNode != null) {
                                try (CloseableIterator closeableIterator = null;){
                                    closeableIterator = PersistenceUtility.getInstance(migrationProjectNode.getPersistenceManager()).getCapturedConnectionsForProjectId(migrationProjectNode.getMdProject().getKey());
                                    if (closeableIterator.hasNext()) {
                                        MdConnection mdConnection = (MdConnection)closeableIterator.next();
                                        mdConnection = MdConnection.retrieveExistingInstance(migrationProjectNode.getPersistenceManager(), mdConnection.getKey());
                                        String string2 = mdConnection.getProperty("PLUGIN_ID");
                                        if (string2 != null) {
                                            enum_ = MigrationAddin.getPlugin(string2).getMergeProjectSupportLevel();
                                        }
                                    }
                                }
                            }
                            if (enum_ == null || enum_.equals((Object)MigrationPlugin.ProjectMergeLevel.PROJECT_MERGE_LEVEL_NONE)) {
                                throw new Exception(Messages.getString("PluginNotSuitable"));
                            }
                        }
                        finally {
                            Connections.getInstance().unlock(connection);
                        }
                    }
                    catch (Exception exception) {
                        throw new TaskException((Throwable)exception);
                    }
                }
                return enum_;
            }

            public String getQuery() {
                return Messages.getString("Name");
            }

            public String getConnectionName() {
                return dBObject.getConnectionName();
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)databaseQueryTask);
        databaseQueryTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter((DatabaseQueryTask)databaseQueryTask, dBObject){
            final /* synthetic */ DatabaseQueryTask val$validation;
            final /* synthetic */ DBObject val$selectedObject;
            {
                this.val$validation = databaseQueryTask;
                this.val$selectedObject = dBObject;
            }

            public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.error(null, (Object)raptorTaskEvent.getThrowable().getMessage(), (String)Messages.getString("ProjecMergeTaskFailed"), null);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeLater(runnable);
                }
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                Logger.severe(((Object)((Object)this)).getClass(), (String)Messages.getString("ProjecMergeTaskCancelled"));
                Logger.severe(((Object)((Object)this)).getClass(), (String)RaptorTaskUtils.getErrorMessage((Throwable)raptorTaskEvent.getThrowable()));
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                try {
                    final MigrationPlugin.ProjectMergeLevel projectMergeLevel = (MigrationPlugin.ProjectMergeLevel)((Object)this.val$validation.getResult());
                    if (projectMergeLevel != null) {
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                MigrationMoveToProject.this.launchReal(val$selectedObject, projectMergeLevel);
                            }
                        };
                        if (SwingUtilities.isEventDispatchThread()) {
                            runnable.run();
                        } else {
                            SwingUtilities.invokeLater(runnable);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    Logger.ignore(((Object)((Object)this)).getClass(), (Throwable)interruptedException);
                }
                catch (ExecutionException executionException) {
                    Logger.warn(((Object)((Object)this)).getClass(), (Throwable)executionException);
                }
            }
        });
    }

    public void launchReal(DBObject dBObject, MigrationPlugin.ProjectMergeLevel projectMergeLevel) {
        String string;
        boolean bl = true;
        JComponent jComponent = this.getOptionsPanel(dBObject);
        if (jComponent != null) {
            string = OnePageWizardDialogFactory.createJEWTDialog((Component)jComponent, (Component)jComponent, (String)Messages.getString("ConnectionToMoveTo"), (int)7);
            string.setSize(jComponent.getPreferredSize().width + 30, jComponent.getPreferredSize().height + 30);
            string.setDefaultCloseOperation(2);
            HelpSystem.getHelpSystem().registerTopic(jComponent, "f1_mergemigrprojects_html");
            this.kickOffTask(dBObject, projectMergeLevel);
            bl = string.runDialog();
        }
        if (bl && (string = this.getSelectedProject()) != null && !string.equals("")) {
            final DatabaseQueryTask<String> databaseQueryTask = this.getTask(string, dBObject, projectMergeLevel, ((MigrationProjectNode)dBObject.getNode()).getPersistenceManager(), this.comboFromConnId.get(this.jComboFromConn.getSelectedIndex()), this.comboToConnId.get(this.jComboToConn.getSelectedIndex()));
            jComponent = this.getOptionsPanel(dBObject);
            databaseQueryTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.error(null, (Object)raptorTaskEvent.getThrowable().getMessage(), (String)Messages.getString("ProjecMergeTaskFailed"), null);
                        }
                    };
                    if (SwingUtilities.isEventDispatchThread()) {
                        runnable.run();
                    } else {
                        SwingUtilities.invokeLater(runnable);
                    }
                }

                public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                    Logger.severe(((Object)((Object)this)).getClass(), (String)Messages.getString("ProjecMergeTaskCancelled"));
                    Logger.severe(((Object)((Object)this)).getClass(), (String)RaptorTaskUtils.getErrorMessage((Throwable)raptorTaskEvent.getThrowable()));
                }

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    try {
                        String string = (String)databaseQueryTask.getResult();
                        if (string == null || !string.equals("OK")) {
                            Logger.severe(((Object)((Object)this)).getClass(), (String)(Messages.getString("InvalidReturnValue") + string));
                        } else {
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    MessageDialog.information(null, (Object)Messages.getString("MergeSucceeded"), (String)Messages.getString("MergeSucceeded"), null);
                                }
                            };
                            if (SwingUtilities.isEventDispatchThread()) {
                                runnable.run();
                            } else {
                                SwingUtilities.invokeLater(runnable);
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        Logger.ignore(((Object)((Object)this)).getClass(), (Throwable)interruptedException);
                    }
                    catch (ExecutionException executionException) {
                        Logger.warn(((Object)((Object)this)).getClass(), (Throwable)executionException);
                    }
                }
            });
            RaptorTaskManager.getInstance().addTask(databaseQueryTask);
        }
    }

    public static class MigrationMoveToProjectTask
    extends DatabaseQueryTask<String> {
        private DBObject selectedObject2;
        private String destinationProject;
        private ArrayList<Long> pIdArray;
        private ArrayList<Long> catId;
        private ArrayList<Long> conId;
        private ArrayList<String> projName;
        private ArrayList<String> conType;
        private ArrayList<Long> taskMinConId;
        private String realName = null;
        private Long fromConnId = null;
        private Long toConnId = null;
        private MigrationPlugin.ProjectMergeLevel mergeLevel;
        private PersistenceManager pMan;

        public MigrationMoveToProjectTask(ArrayList<Long> arrayList, ArrayList<String> arrayList2, ArrayList<Long> arrayList3, ArrayList<String> arrayList4, ArrayList<Long> arrayList5, String string, String string2, DBObject dBObject, MigrationPlugin.ProjectMergeLevel projectMergeLevel, ArrayList<Long> arrayList6, PersistenceManager persistenceManager, Long l, Long l2) {
            super(string, IRaptorTaskRunMode.NO_GUI, false, false);
            this.selectedObject2 = dBObject;
            this.conId = arrayList;
            this.projName = arrayList2;
            this.conType = arrayList4;
            this.destinationProject = string2;
            this.mergeLevel = projectMergeLevel;
            this.pMan = persistenceManager;
            this.catId = arrayList6;
            this.pIdArray = arrayList3;
            this.taskMinConId = arrayList5;
            this.fromConnId = l;
            this.toConnId = l2;
            if (dBObject.getNode() instanceof MigrationProjectNode) {
                MigrationProjectNode migrationProjectNode = (MigrationProjectNode)dBObject.getNode();
                this.realName = migrationProjectNode.getMdProject().getObjectName();
            }
            this.setMessage(this.getDescriptor().getName());
        }

        public String getConnectionName() {
            return this.selectedObject2.getConnectionName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void mergeIds(PersistenceManager persistenceManager, Connection connection, Long l, Long l2, MigrationPlugin.ProjectMergeLevel projectMergeLevel) throws SQLException, PersistenceException, NoSuchObjectException {
            Statement statement = null;
            try {
                String[] stringArray;
                String string = "";
                String string2 = "";
                String string3 = "";
                String string4 = "";
                if (projectMergeLevel.equals((Object)MigrationPlugin.ProjectMergeLevel.PROJECT_MERGE_LEVEL_SCHEMA)) {
                    string2 = " and REF_TYPE != 'MD_CATALOGS' ";
                    string = " and DERIVED_TYPE != 'MD_CATALOGS' ";
                    string3 = " and PARENT_OBJECT_TYPE != 'MD_CATALOGS' and CHILD_OBJECT_TYPE != 'MD_CATALOGS' ";
                    string4 = " and PARENT_TYPE != 'MD_CATALOGS' and CHILD_TYPE != 'MD_CATALOGS' ";
                }
                for (String string5 : stringArray = new String[]{"update MD_ADDITIONAL_PROPERTIES set CONNECTION_ID_FK=:thenewid where CONNECTION_ID_FK=:theoldid and REF_TYPE!='MD_CONNECTIONS' " + string2, "update MD_MIGR_DEPENDENCY set CONNECTION_ID_FK=:thenewid where CONNECTION_ID_FK=:theoldid  and PARENT_OBJECT_TYPE != 'MD_CONNECTIONS' and CHILD_OBJECT_TYPE != 'MD_CONNECTIONS' " + string3, "update MD_MIGR_PARAMETER set CONNECTION_ID_FK=:thenewid where CONNECTION_ID_FK=:theoldid", "update MD_MIGR_WEAKDEP set CONNECTION_ID_FK=:thenewid where CONNECTION_ID_FK=:theoldid and PARENT_TYPE != 'MD_CONNECTIONS' and CHILD_TYPE != 'MD_CONNECTIONS' " + string4, "update MIGRLOG set CONNECTION_ID_FK=:thenewid where CONNECTION_ID_FK=:theoldid", "DECLARE \n  innew NUMBER:=:thenewid; \n  inold NUMBER:=:theoldid; \n  maxexisting NUMBER:=-1; \nBEGIN \n  select max (generation_order) into maxexisting from migr_generation_order o where o.connection_id_fk=innew; \n  if (maxexisting is not null) then \n    update migr_generation_order set generation_order = generation_order + maxexisting + 1 where connection_id_fk=inold; \n  end if; \n  update migr_generation_order set CONNECTION_ID_FK=innew where CONNECTION_ID_FK=inold; \nEND;", "update MD_DERIVATIVES set DERIVED_CONNECTION_ID_FK=:thenewid where DERIVED_CONNECTION_ID_FK=:theoldid and DERIVED_TYPE != 'MD_CONNECTIONS' " + string}) {
                    if (l2 == -1L || l == -1L) continue;
                    statement = connection.prepareStatement(string5);
                    statement.setLong(1, l2);
                    statement.setLong(2, l);
                    statement.execute();
                    statement.close();
                }
                if (projectMergeLevel.equals((Object)MigrationPlugin.ProjectMergeLevel.PROJECT_MERGE_LEVEL_SCHEMA)) {
                    // empty if block
                }
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        Logger.warn(((Object)((Object)this)).getClass(), (Throwable)sQLException);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public String doWork() throws TaskException {
            String string = "NOT OK";
            try {
                Long l;
                Long l2;
                Long l3;
                Long l4;
                Long l5;
                Long l6;
                Long l7;
                Long l8;
                int n;
                block112: {
                    n = 0;
                    l8 = -1L;
                    l7 = -1L;
                    l6 = -1L;
                    l5 = -1L;
                    l4 = -1L;
                    l3 = -1L;
                    l2 = -1L;
                    l = -1L;
                    Long l9 = -1L;
                    Long l10 = -1L;
                    Long l11 = -1L;
                    Long l12 = -1L;
                    Long l13 = -1L;
                    Long l14 = -1L;
                    Long l15 = -1L;
                    Long l16 = -1L;
                    Long l17 = -1L;
                    Long l18 = -1L;
                    Long l19 = -1L;
                    Long l20 = -1L;
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    for (int i = 0; i < this.conId.size(); ++i) {
                        if (this.projName.get(i).equals(this.destinationProject) && (this.conType.get(i) == null || this.conType.get(i).equals(""))) {
                            if (this.conId.get(i) > l17 || l17 == -1L) {
                                l17 = this.conId.get(i);
                                l8 = this.conId.get(i);
                                l9 = this.pIdArray.get(i);
                                l4 = this.catId.get(i);
                            }
                            if (this.conId.get(i) >= l13 && l13 != -1L) continue;
                            l13 = this.conId.get(i);
                            continue;
                        }
                        if (this.projName.get(i).equals(this.destinationProject) && this.conType.get(i) != null && this.conType.get(i).equals("CONVERTED")) {
                            if (this.conId.get(i) > l19 || l19 == -1L) {
                                l19 = this.conId.get(i);
                                l6 = this.conId.get(i);
                                l11 = this.pIdArray.get(i);
                                l2 = this.catId.get(i);
                            }
                            if (this.conId.get(i) >= l15 && l15 != -1L) continue;
                            l15 = this.conId.get(i);
                            continue;
                        }
                        if (this.projName.get(i).equals(this.realName) && (this.conType.get(i) == null || this.conType.get(i).equals(""))) {
                            if (this.conId.get(i) > l18 || l18 == -1L) {
                                l18 = this.conId.get(i);
                                l7 = this.conId.get(i);
                                l10 = this.pIdArray.get(i);
                                l3 = this.catId.get(i);
                            }
                            if (this.conId.get(i) >= l14 && l14 != -1L) continue;
                            l14 = this.conId.get(i);
                            continue;
                        }
                        if (!this.projName.get(i).equals(this.realName) || this.conType.get(i) == null || !this.conType.get(i).equals("CONVERTED")) continue;
                        if (this.conId.get(i) > l20 || l20 == -1L) {
                            l20 = this.conId.get(i);
                            l5 = this.conId.get(i);
                            l12 = this.pIdArray.get(i);
                            l = this.catId.get(i);
                        }
                        if (this.conId.get(i) >= l16 && l16 != -1L) continue;
                        l16 = this.conId.get(i);
                    }
                    bl3 = l17 == l13;
                    bl4 = l19 == l15;
                    bl = l18 == l14;
                    boolean bl5 = bl2 = l20 == l16;
                    if (l17 == -1L || l19 == -1L || l18 == -1L || l20 == -1L || this.fromConnId == null || this.fromConnId == -1L || this.toConnId == null || this.toConnId == -1L) {
                        throw new Exception(Messages.getString("MissingInformation"));
                    }
                    Statement statement = null;
                    DBObjectId dBObjectId = null;
                    if (Connections.getInstance().lock(this.selectedObject2.getConnection())) {
                        Object object;
                        block111: {
                            Object object2;
                            object = "Select derived_id from md_derivatives where src_id=:1 and DERIVED_TYPE='MD_CONNECTIONS' and src_id!=derived_id";
                            ResultSet resultSet = null;
                            long l21 = -1L;
                            long l22 = -1L;
                            try {
                                statement = this.selectedObject2.getConnection().prepareStatement((String)object);
                                statement.setLong(1, this.fromConnId);
                                resultSet = statement.executeQuery();
                                if (resultSet.next()) {
                                    l21 = resultSet.getLong(1);
                                }
                                if (l21 == 0L || l21 == -1L) {
                                    throw new Exception(Messages.getString("LatestCapturedDestination"));
                                }
                                resultSet.close();
                                statement.close();
                                statement = this.selectedObject2.getConnection().prepareStatement((String)object);
                                statement.setLong(1, this.toConnId);
                                resultSet = statement.executeQuery();
                                if (resultSet.next()) {
                                    l22 = resultSet.getLong(1);
                                }
                                if (l22 == 0L || l22 == -1L) {
                                    throw new Exception(Messages.getString("LatestCapturedSource"));
                                }
                                object2 = MdConnection.retrieveExistingInstance(this.pMan, new DBObjectId(this.toConnId)).getProperty("PLUGIN_ID");
                                String string2 = MdConnection.retrieveExistingInstance(this.pMan, new DBObjectId(this.fromConnId)).getProperty("PLUGIN_ID");
                                if (object2 == null || string2 == null || !((String)object2).equals(string2)) {
                                    throw new Exception(Messages.getString("PluginTypes"));
                                }
                                for (int i = 0; i < this.conId.size(); ++i) {
                                    if (this.conId.get(i).equals(this.toConnId)) {
                                        l17 = this.conId.get(i);
                                        l8 = this.conId.get(i);
                                        l9 = this.pIdArray.get(i);
                                        l4 = this.catId.get(i);
                                        continue;
                                    }
                                    if (this.conId.get(i).equals(l22)) {
                                        l19 = this.conId.get(i);
                                        l6 = this.conId.get(i);
                                        l11 = this.pIdArray.get(i);
                                        l2 = this.catId.get(i);
                                        continue;
                                    }
                                    if (this.conId.get(i).equals(this.fromConnId)) {
                                        l18 = this.conId.get(i);
                                        l7 = this.conId.get(i);
                                        l10 = this.pIdArray.get(i);
                                        l3 = this.catId.get(i);
                                        continue;
                                    }
                                    if (!this.conId.get(i).equals(l21)) continue;
                                    l20 = this.conId.get(i);
                                    l5 = this.conId.get(i);
                                    l12 = this.pIdArray.get(i);
                                    l = this.catId.get(i);
                                }
                            }
                            catch (SQLException sQLException) {
                                Logger.severe(((Object)((Object)this)).getClass(), (Throwable)sQLException);
                                throw sQLException;
                            }
                            finally {
                                if (resultSet != null) {
                                    try {
                                        resultSet.close();
                                    }
                                    catch (SQLException sQLException) {
                                        Logger.warn(((Object)((Object)this)).getClass(), (Throwable)sQLException);
                                    }
                                }
                                if (statement != null) {
                                    try {
                                        statement.close();
                                    }
                                    catch (SQLException sQLException) {
                                        Logger.warn(((Object)((Object)this)).getClass(), (Throwable)sQLException);
                                    }
                                }
                            }
                            this.selectedObject2.getConnection().commit();
                            if (this.mergeLevel.equals((Object)MigrationPlugin.ProjectMergeLevel.PROJECT_MERGE_LEVEL_CATALOG)) {
                                if (l8 != -1L && l7 != -1L) {
                                    statement = this.selectedObject2.getConnection().prepareStatement("UPDATE md_catalogs c  SET c.connection_id_fk  = (:notconverteddestination)  WHERE c.connection_id_fk= (:notconvertedsource)");
                                    statement.setLong(1, l8);
                                    statement.setLong(2, l7);
                                    statement.execute();
                                    dBObjectId = MdConnection.retrieveExistingInstance(this.pMan, new DBObjectId(l7)).getProjectId();
                                    this.mergeIds(this.pMan, this.selectedObject2.getConnection(), l7, l8, this.mergeLevel);
                                    n = 1;
                                    if (statement != null) {
                                        try {
                                            statement.close();
                                        }
                                        catch (SQLException sQLException) {
                                            Logger.warn(((Object)((Object)this)).getClass(), (Throwable)sQLException);
                                        }
                                    }
                                } else {
                                    Logger.warn(((Object)((Object)this)).getClass(), (String)Messages.getString("CapturerNotOk"));
                                }
                                if (l6 != -1L && l5 != -1L) {
                                    statement = this.selectedObject2.getConnection().prepareStatement("UPDATE md_catalogs c  SET c.connection_id_fk  = (:converteddestination)  WHERE c.connection_id_fk= (:convertedsource)");
                                    statement.setLong(1, l6);
                                    statement.setLong(2, l5);
                                    dBObjectId = MdConnection.retrieveExistingInstance(this.pMan, new DBObjectId(l5)).getProjectId();
                                    statement.execute();
                                    this.mergeIds(this.pMan, this.selectedObject2.getConnection(), l5, l6, this.mergeLevel);
                                    n += 2;
                                    if (statement != null) {
                                        try {
                                            statement.close();
                                        }
                                        catch (SQLException sQLException) {
                                            Logger.warn(((Object)((Object)this)).getClass(), (Throwable)sQLException);
                                        }
                                    }
                                } else {
                                    Logger.warn(((Object)((Object)this)).getClass(), (String)Messages.getString("ConvertedNotOk"));
                                }
                            } else if (this.mergeLevel.equals((Object)MigrationPlugin.ProjectMergeLevel.PROJECT_MERGE_LEVEL_SCHEMA)) {
                                if (l8 != -1L && l7 != -1L && l4 != 0L && l3 != 0L) {
                                    statement = this.selectedObject2.getConnection().prepareStatement("UPDATE md_schemas s  SET s.catalog_id_fk  = (:notconvertedCatdestination)  WHERE s.catalog_id_fk= (:notconvertedCatsource)");
                                    statement.setLong(1, l4);
                                    statement.setLong(2, l3);
                                    statement.execute();
                                    this.mergeIds(this.pMan, this.selectedObject2.getConnection(), l7, l8, this.mergeLevel);
                                    n = 1;
                                    if (statement != null) {
                                        try {
                                            statement.close();
                                        }
                                        catch (SQLException sQLException) {
                                            Logger.warn(((Object)((Object)this)).getClass(), (Throwable)sQLException);
                                        }
                                    }
                                } else {
                                    Logger.warn(((Object)((Object)this)).getClass(), (String)Messages.getString("CapturerNotOk"));
                                }
                                if (l6 != -1L && l5 != -1L && l2 != 0L && l != 0L) {
                                    statement = this.selectedObject2.getConnection().prepareStatement("UPDATE md_schemas s  SET s.catalog_id_fk  = (:convertedCatdestination)  WHERE s.catalog_id_fk= (:convertedCatsource)");
                                    statement.setLong(1, l2);
                                    statement.setLong(2, l);
                                    statement.execute();
                                    this.mergeIds(this.pMan, this.selectedObject2.getConnection(), l5, l6, this.mergeLevel);
                                    n += 2;
                                    if (statement != null) {
                                        try {
                                            statement.close();
                                        }
                                        catch (SQLException sQLException) {
                                            Logger.warn(((Object)((Object)this)).getClass(), (Throwable)sQLException);
                                        }
                                    }
                                } else {
                                    Logger.warn(((Object)((Object)this)).getClass(), (String)Messages.getString("ConvertedNotOk"));
                                }
                            }
                            if ((n == 3 && bl && bl2 || n == 1 && bl && !bl2 || n == 2 && !bl && bl2) && n == 3 && l12.equals(l10)) {
                                object2 = (MigrationProjectNode)this.selectedObject2.getNode();
                                long l23 = -1L;
                                ResultSet resultSet2 = null;
                                PreparedStatement preparedStatement = null;
                                try {
                                    preparedStatement = this.selectedObject2.getConnection().prepareStatement("select count(*) from md_applications where project_id_fk = :1");
                                    preparedStatement.setLong(1, l12);
                                    resultSet2 = preparedStatement.executeQuery();
                                    if (resultSet2.next()) {
                                        l23 = resultSet2.getLong(1);
                                    }
                                }
                                finally {
                                    if (resultSet2 != null) {
                                        try {
                                            resultSet2.close();
                                        }
                                        catch (SQLException sQLException) {
                                            Logger.warn(((Object)((Object)this)).getClass(), (Throwable)sQLException);
                                        }
                                    }
                                    if (preparedStatement != null) {
                                        try {
                                            preparedStatement.close();
                                        }
                                        catch (SQLException sQLException) {
                                            Logger.warn(((Object)((Object)this)).getClass(), (Throwable)sQLException);
                                        }
                                    }
                                }
                                if (l23 == 0L) {
                                    MdConnection.retrieveExistingInstance(this.pMan, new DBObjectId(l7)).delete(this.pMan);
                                    MdConnection.retrieveExistingInstance(this.pMan, new DBObjectId(l5)).delete(this.pMan);
                                    ((MigrationProjectNode)object2).getPersistableObject().delete(((MigrationProjectNode)object2).getPersistenceManager());
                                    ((MigrationProjectNode)object2).getPersistenceManager().commit();
                                }
                            }
                            if (n == 3) {
                                this.selectedObject2.getConnection().commit();
                            } else {
                                this.selectedObject2.getConnection().rollback();
                            }
                            this.pMan.commit();
                            if (statement == null) break block111;
                            try {
                                statement.close();
                            }
                            catch (SQLException sQLException) {
                                Logger.warn(((Object)((Object)this)).getClass(), (Throwable)sQLException);
                            }
                        }
                        try {
                            this.selectedObject2.getConnection().rollback();
                        }
                        catch (SQLException sQLException) {
                            Logger.severe(((Object)((Object)this)).getClass(), (Throwable)sQLException);
                        }
                        Connections.getInstance().unlock(this.selectedObject2.getConnection());
                        try {
                            object = new Runnable(this){
                                final /* synthetic */ MigrationMoveToProjectTask this$0;
                                {
                                    this.this$0 = migrationMoveToProjectTask;
                                }

                                @Override
                                public void run() {
                                    MigrationProjectNode migrationProjectNode = (MigrationProjectNode)this.this$0.selectedObject2.getNode();
                                    MigrationProjectNavigatorManager.getInstance().refreshElement(migrationProjectNode.getParentElement());
                                }
                            };
                            if (SwingUtilities.isEventDispatchThread()) {
                                object.run();
                                break block112;
                            }
                            SwingUtilities.invokeLater((Runnable)object);
                        }
                        catch (Exception exception) {
                            Logger.severe(((Object)((Object)this)).getClass(), (Throwable)exception);
                        }
                        break block112;
                        catch (Exception exception) {
                            block113: {
                                try {
                                    string = "notok";
                                    n += 4;
                                    Logger.warn(((Object)((Object)this)).getClass(), (Throwable)exception);
                                    if (statement == null) break block113;
                                }
                                catch (Throwable throwable) {
                                    if (statement != null) {
                                        try {
                                            statement.close();
                                        }
                                        catch (SQLException sQLException) {
                                            Logger.warn(((Object)((Object)this)).getClass(), (Throwable)sQLException);
                                        }
                                    }
                                    try {
                                        this.selectedObject2.getConnection().rollback();
                                    }
                                    catch (SQLException sQLException) {
                                        Logger.severe(((Object)((Object)this)).getClass(), (Throwable)sQLException);
                                    }
                                    Connections.getInstance().unlock(this.selectedObject2.getConnection());
                                    try {
                                        Runnable runnable = new /* invalid duplicate definition of identical inner class */;
                                        if (SwingUtilities.isEventDispatchThread()) {
                                            runnable.run();
                                        } else {
                                            SwingUtilities.invokeLater(runnable);
                                        }
                                    }
                                    catch (Exception exception2) {
                                        Logger.severe(((Object)((Object)this)).getClass(), (Throwable)exception2);
                                    }
                                    throw throwable;
                                }
                                try {
                                    statement.close();
                                }
                                catch (SQLException sQLException) {
                                    Logger.warn(((Object)((Object)this)).getClass(), (Throwable)sQLException);
                                }
                            }
                            try {
                                this.selectedObject2.getConnection().rollback();
                            }
                            catch (SQLException sQLException) {
                                Logger.severe(((Object)((Object)this)).getClass(), (Throwable)sQLException);
                            }
                            Connections.getInstance().unlock(this.selectedObject2.getConnection());
                            try {
                                object = new /* invalid duplicate definition of identical inner class */;
                                if (SwingUtilities.isEventDispatchThread()) {
                                    object.run();
                                }
                                SwingUtilities.invokeLater((Runnable)object);
                            }
                            catch (Exception exception3) {
                                Logger.severe(((Object)((Object)this)).getClass(), (Throwable)exception3);
                            }
                        }
                    }
                }
                boolean bl = false;
                if (this.mergeLevel.equals((Object)MigrationPlugin.ProjectMergeLevel.PROJECT_MERGE_LEVEL_SCHEMA)) {
                    if (l8 != -1L && l7 != -1L && (l4 == 0L || l3 == 0L)) {
                        bl = true;
                    }
                    if (l6 != -1L && l5 != -1L && (l2 == 0L || l == 0L)) {
                        bl = true;
                    }
                    if (bl) {
                        Logger.warn(((Object)((Object)this)).getClass(), (String)Messages.getString("NoCatalog"));
                    }
                }
                if ((bl || n != 3) && (n != 1 || l6 != -1L && l5 != -1L) && (n != 2 || l8 != -1L && l7 != -1L) && (n != 0 || l6 != -1L && l5 != -1L || l8 != -1L && l7 != -1L)) {
                    throw new Exception(Messages.getString("ProjecMergeTaskFailed"));
                }
                string = "OK";
            }
            catch (Exception exception) {
                throw new TaskException((Throwable)exception);
            }
            return string;
        }

        public String getQuery() {
            return Messages.getString("UpdateQuery");
        }
    }
}

