/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.extension;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Level;
import oracle.jdeveloper.audit.extension.Definition;
import oracle.jdeveloper.audit.extension.DefinitionBundle;
import oracle.jdeveloper.audit.extension.DefinitionContext;
import oracle.jdeveloper.audit.extension.ExtensionBundle;
import oracle.jdeveloper.audit.service.TypeSafeEnumeration;
import oracle.jdeveloper.audit.service.TypeSafeEnumerationFactory;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.TransformContext;
import oracle.jdevimpl.audit.util.Strings;

public abstract class TopLevelDefinition
extends Definition {
    private final String id;
    private final ExtensionBundle bundle;
    private List<String> deprecatedIds;
    private Map<String, String> strings = NO_STRINGS;
    private static final Map<String, String> NO_STRINGS = Collections.emptyMap();
    private static Set<String> missingStrings = new HashSet<String>();
    public static final String LABEL_KEY = "label";
    public static final String DESCRIPTION_KEY = "description";
    private static final int SPACES = 0x200020;
    private static final int QUOTES = 0x220022;
    private static final int APOSTROPHES = 0x270027;

    TopLevelDefinition(String id, ExtensionBundle bundle, DefinitionContext context) {
        super(context);
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        if (id.endsWith(".null")) {
            throw new IllegalArgumentException("id.endsWith(\".null\")");
        }
        this.id = id;
        this.bundle = bundle;
    }

    public ExtensionBundle getExtensionBundle() {
        return this.bundle;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return Strings.lastToken(this.id, '.');
    }

    public List<String> getDeprecatedIds() {
        if (this.deprecatedIds != null) {
            return this.deprecatedIds;
        }
        return Collections.emptyList();
    }

    public void addDeprecatedId(String id) {
        if (this.deprecatedIds == null) {
            this.deprecatedIds = new ArrayList<String>();
        }
        this.deprecatedIds.add(id);
    }

    public Map<String, String> getStrings() {
        return this.strings;
    }

    public void setStrings(Map<String, String> strings) {
        if (this.strings != NO_STRINGS) {
            throw new IllegalStateException("strings already set");
        }
        if (strings != null && !strings.isEmpty()) {
            this.strings = strings;
        }
    }

    public String label() {
        String label = this.string(LABEL_KEY);
        if (label == null) {
            label = this.defaultLabelString();
        }
        return label;
    }

    public String description() {
        String description = this.string(DESCRIPTION_KEY);
        if (description == null) {
            this.reportMissingString(DESCRIPTION_KEY);
            description = DefinitionBundle.get("no-description");
        } else if (description.trim().isEmpty()) {
            description = DefinitionBundle.get("no-description");
        }
        return description;
    }

    public String propertyLabel(String propertyName) {
        return this.propertyString(propertyName, LABEL_KEY);
    }

    public String propertyDescription(String propertyName) {
        return this.propertyString(propertyName, DESCRIPTION_KEY);
    }

    public String string(String relativeKey) {
        String fullKey = this.getStrings().get(relativeKey);
        try {
            if (fullKey != null) {
                return this.bundle.getString(fullKey);
            }
            if (this.bundle.isKeyed()) {
                return this.bundle.getString(this.getName() + "." + relativeKey);
            }
            return null;
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    protected String defaultLabelString() {
        this.reportMissingString(LABEL_KEY);
        return this.bundle.isLegacy() ? this.id : Strings.capitalizeAndSeparateAll(this.getName().replace('-', ' ').replace('_', ' '));
    }

    protected void reportMissingString(String relativeKey) {
        String keyType;
        if (!this.bundle.isLog()) {
            return;
        }
        String qualifiedName = this.id + "#" + relativeKey;
        if (missingStrings.contains(qualifiedName)) {
            return;
        }
        String fullKey = this.getStrings().get(relativeKey);
        if (fullKey == null) {
            keyType = "default";
            fullKey = this.getName() + "." + relativeKey;
        } else {
            keyType = "supplied";
        }
        String what = Strings.separateCamelCase(Strings.removeSuffix(this.getClass().getSimpleName(), "Definition"), ' ').toLowerCase();
        this.log(Level.WARNING, "No \"{0}\" resource found for {1} \"{2}\": {3} key is \"{4}\"; bundle is {5}", relativeKey, what, this.id, keyType, fullKey, this.bundle.getDiagnostic());
        missingStrings.add(qualifiedName);
    }

    public String formattedString(String relativeKey, Object context) {
        return this.formattedString(relativeKey, context, false);
    }

    public String formattedString(String relativeKey, Object context, boolean erase) {
        return this.bind(this.string(relativeKey), context, erase);
    }

    public String propertyString(String propertyName, String relativeKey) {
        return this.string(propertyName + "." + relativeKey);
    }

    public String bind(String message, Object context, boolean erase) {
        if (message == null) {
            return null;
        }
        int length = message.length();
        StringBuffer buffer = new StringBuffer(length * 2);
        int i = 0;
        while (true) {
            int bufferLength;
            int pair;
            int i0 = i;
            while (true) {
                if (i == length) {
                    buffer.append(message.substring(i0));
                    return buffer.toString();
                }
                char c = message.charAt(i);
                if (c == '{') break;
                ++i;
            }
            buffer.append(message.substring(i0, i));
            int brace = i++;
            i0 = i;
            while (true) {
                if (i == length) {
                    buffer.append(message.substring(brace));
                    return buffer.toString();
                }
                char c = message.charAt(i);
                if (c == '}') break;
                ++i;
            }
            Object value = this.resolveReference(message, i0, i++, context);
            boolean missing = false;
            boolean empty = false;
            if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                if (array.length > 0) {
                    buffer.append(array[0]);
                    for (int j = 1; j < array.length; ++j) {
                        buffer.append(", ");
                        buffer.append(array[j]);
                    }
                } else {
                    empty = true;
                }
            } else if (value instanceof TypeSafeEnumeration) {
                TypeSafeEnumerationFactory factory = TypeSafeEnumerationFactory.factory(value.getClass());
                if (factory != null) {
                    buffer.append(factory.label(value));
                } else {
                    buffer.append(value);
                }
            } else if (value != null) {
                String string = String.valueOf(value);
                buffer.append(string);
                empty = string.isEmpty();
            } else {
                missing = true;
            }
            if (missing) {
                if (erase) {
                    int bufferLength2 = buffer.length();
                    if (bufferLength2 <= 0 || i >= length) continue;
                    pair = buffer.charAt(bufferLength2 - 1) << 16 | message.charAt(i);
                    if (pair == 0x220022 || pair == 0x270027) {
                        buffer.setLength(--bufferLength2);
                        if (bufferLength2 > 0 && ++i < length) {
                            pair = buffer.charAt(bufferLength2 - 1) << 16 | message.charAt(i);
                        }
                    }
                    if (pair != 0x200020) continue;
                    ++i;
                    continue;
                }
                buffer.append(message, i0 - 1, i);
                continue;
            }
            if (!empty || (bufferLength = buffer.length()) <= 0 || i >= length || (pair = buffer.charAt(bufferLength - 1) << 16 | message.charAt(i)) != 0x200020) continue;
            ++i;
        }
    }

    private Object resolveReference(String string, int first, int last, Object bean) {
        Method method;
        int nameLength;
        if (string.charAt(first) == '@') {
            for (int i = ++first; i < last; ++i) {
                String boundString;
                if (string.charAt(i) != '#') continue;
                Object value = this.resolveReference(string, i + 1, last, bean);
                if (value == null || (boundString = this.formattedString(string.substring(first, i) + '#' + value, bean, false)) == null) break;
                return boundString;
            }
            return this.formattedString(string.substring(first, last), bean, false);
        }
        if (bean instanceof TransformContext) {
            int dot = string.indexOf(46, first);
            if (dot < 0 || dot > last) {
                dot = last;
            }
            nameLength = dot - first;
            StringBuffer methodName = new StringBuffer(3 + nameLength);
            methodName.append("get");
            if (nameLength <= 1) {
                methodName.append(string.charAt(first));
            } else {
                methodName.append(Character.toUpperCase(string.charAt(first)));
                methodName.append(string.substring(first + 1, dot));
            }
            try {
                method = bean.getClass().getMethod(methodName.toString(), new Class[0]);
                bean = method.invoke(bean, new Object[0]);
            }
            catch (Throwable e) {
                bean = ((TransformContext)bean).getViolation();
            }
        }
        if (bean instanceof Violation) {
            char c;
            Violation context = (Violation)bean;
            int dot = string.indexOf(46, first);
            if (dot < 0 || dot > last) {
                dot = last;
            }
            if (dot - first == 1 && Character.isDigit(c = string.charAt(first))) {
                int index = c - 48;
                if (index >= context.getParameterCount()) {
                    return null;
                }
                return context.getParameterValue(index);
            }
            bean = context.getParameterValue(string.substring(first, dot));
            if (bean == null) {
                return null;
            }
            first = dot + 1;
        }
        while (first < last && bean != null) {
            int dot = string.indexOf(46, first);
            if (dot < 0 || dot > last) {
                dot = last;
            }
            nameLength = dot - first;
            if (bean instanceof Map) {
                bean = ((Map)bean).get(string.substring(first, dot));
            } else {
                StringBuffer methodName = new StringBuffer(3 + nameLength);
                methodName.append("get");
                if (nameLength <= 1) {
                    methodName.append(string.charAt(first));
                } else {
                    methodName.append(Character.toUpperCase(string.charAt(first)));
                    methodName.append(string.substring(first + 1, dot));
                }
                try {
                    if (bean instanceof Object[]) {
                        method = bean.getClass().getComponentType().getMethod(methodName.toString(), new Class[0]);
                        Object[] array = bean;
                        Object[] newArray = (Object[])Array.newInstance(method.getReturnType(), array.length);
                        for (int j = 0; j < array.length; ++j) {
                            newArray[j] = method.invoke(bean, new Object[0]);
                        }
                        bean = newArray;
                    } else {
                        method = bean.getClass().getMethod(methodName.toString(), new Class[0]);
                        bean = method.invoke(bean, new Object[0]);
                    }
                }
                catch (Throwable e) {
                    return null;
                }
            }
            first = dot + 1;
        }
        return bean;
    }

    public String getElementName() {
        String name = this.getClass().getSimpleName();
        return name.substring(0, name.length() - "Definition".length()).toLowerCase() + "-definition";
    }

    public boolean equals(Object that) {
        return that instanceof TopLevelDefinition && ((TopLevelDefinition)that).id.equals(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public String toString() {
        String name = this.getClass().getSimpleName();
        return name.substring(0, name.length() - "Definition".length()).toLowerCase() + " \"" + this.id + "\" definition";
    }
}

