/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.insight.completion;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.insight.EditorAdapter;
import oracle.ide.insight.InsightController;
import oracle.ide.insight.InsightHook;
import oracle.ide.insight.completion.CompletionContext;
import oracle.ide.insight.completion.CompletionController;
import oracle.ide.insight.completion.CompletionMultiProvider;
import oracle.ide.insight.completion.CompletionProvider;
import oracle.ide.insight.completion.CompletionSupport;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.ActionHookInvoker;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.CharacterTypedListener;
import oracle.javatools.editor.language.LanguageSupport;

public final class EditorCompletionSupport
extends CompletionSupport<BasicEditorPane> {
    private final BasicEditorPane editor;
    private final Context context;
    private final InsightTrigger insightTrigger = new InsightTrigger();
    private final KeyL keyL = new KeyL();

    public EditorCompletionSupport(Context context, BasicEditorPane editor) {
        super(new EditorAdapter<CompletionController>());
        this.editor = editor;
        this.context = context;
        this.multiProvider = this.createMultiProvider(context, null, null);
        this.install();
    }

    public EditorCompletionSupport(Context context, BasicEditorPane editor, String insightProviderID) {
        super(new EditorAdapter<CompletionController>());
        assert (insightProviderID != null);
        this.editor = editor;
        this.context = context;
        this.multiProvider = this.createMultiProvider(context, insightProviderID, null);
        this.install();
    }

    public EditorCompletionSupport(Context context, BasicEditorPane editor, CompletionProvider insightProvider) {
        super(new EditorAdapter<CompletionController>());
        assert (insightProvider != null);
        this.editor = editor;
        this.context = context;
        this.multiProvider = this.createMultiProvider(context, null, insightProvider);
        this.install();
    }

    @Override
    protected void install() {
        super.install();
        this.editor.addCharacterTypedListener((CharacterTypedListener)this.insightTrigger);
        this.editor.addActionHookInvoker((ActionHookInvoker)this.insightTrigger);
        this.editor.addKeyListener((KeyListener)this.keyL);
    }

    @Override
    public BasicEditorPane getTextComponent() {
        return this.editor;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    public TextBuffer getTextBuffer() {
        assert (this.isDisposed());
        return this.getTextComponent().getTextBuffer();
    }

    public int getOffset() {
        assert (this.isDisposed());
        return this.getTextComponent().getCaretPosition();
    }

    public LanguageSupport getLanguageSupport() {
        assert (this.isDisposed());
        return ((BasicDocument)this.getTextComponent().getDocument()).getLanguageSupport();
    }

    private CompletionMultiProvider createMultiProvider(Context context, String insightProviderID, CompletionProvider insightProvider) {
        List<CompletionProvider> providers = Collections.emptyList();
        if (insightProvider != null) {
            providers = new ArrayList();
            providers.add(insightProvider);
        } else if (insightProviderID != null) {
            providers = InsightHook.get().insightProviders(insightProviderID);
        } else {
            Class<?> nodeClass = context.getNode().getClass();
            providers = InsightHook.get().insightProviders(nodeClass);
        }
        return new CompletionMultiProvider(this.controller, providers);
    }

    @Override
    public void deinstall() {
        BasicEditorPane editor = (BasicEditorPane)this.getAdapter().getTextComponent();
        editor.removeCharacterTypedListener((CharacterTypedListener)this.insightTrigger);
        editor.removeActionHookInvoker((ActionHookInvoker)this.insightTrigger);
        editor.removeKeyListener((KeyListener)this.keyL);
        super.deinstall();
    }

    private class InsightTrigger
    implements CharacterTypedListener,
    ActionHookInvoker {
        private InsightTrigger() {
        }

        public void characterTyped(BasicEditorPane editorPane, int offset, char typedChar) {
            if (!EditorCompletionSupport.this.isAutoPopup()) {
                return;
            }
            if (EditorCompletionSupport.this.controller.getState() == InsightController.State.HIDDEN) {
                EditorCompletionSupport.this.timerTrigger(Character.valueOf(typedChar));
            }
        }

        public boolean invokeAction(String actionKey) {
            if (!EditorCompletionSupport.this.isShowOnShortcut()) {
                return false;
            }
            if (actionKey.equals("completion-insight") || actionKey.equals("smart-completion-insight")) {
                if (EditorCompletionSupport.this.controller.getState() == InsightController.State.HIDDEN) {
                    EditorCompletionSupport.this.triggerInsight(CompletionContext.Invoked.MANUAL);
                }
                return true;
            }
            return false;
        }
    }

    private class KeyL
    extends KeyAdapter {
        private KeyL() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            EditorCompletionSupport.this.cancelTimer();
        }
    }
}

