/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dialog.directory;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import oracle.ewt.alert.Alert;
import oracle.ewt.dTree.DTreeSelection;
import oracle.ewt.dialog.directory.DirectoryDialog;
import oracle.ewt.dialog.directory.DirectoryTree;
import oracle.ewt.dialog.directory.FileUtils;
import oracle.ewt.lwAWT.lwText.LWTextField;

class OKListener
implements ActionListener {
    private DirectoryDialog _dialog;
    private DirectoryTree _tree;
    private LWTextField _field;
    private static String _FILE_EXISTS_KEY = "FILE_EXISTS";
    private static String _NO_DIRECTORY_KEY = "NO_DIRECTORY";
    private static String _TRY_CREATE_KEY = "TRY_CREATE";
    private static String _WRITE_FAILED_KEY = "WRITE_FAILED";
    private static String _CREATE_FAILED_KEY = "CREATE_FAILED";
    private static String _KEY_QUERY_TITLE = "QUERY_TITLE";
    private static String _KEY_ERROR_TITLE = "ERROR_TITLE";

    public OKListener(DirectoryDialog directoryDialog, DirectoryTree directoryTree, LWTextField lWTextField) {
        this._dialog = directoryDialog;
        this._tree = directoryTree;
        this._field = lWTextField;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this._handleOK();
    }

    private void _handleOK() {
        String string = this._field.getText();
        File file = new File(string);
        boolean bl = file.exists();
        if (bl) {
            if (!FileUtils.isDirectory(file)) {
                this._runDirectoryAlert(_FILE_EXISTS_KEY, file);
            } else {
                File file2 = this._tree.getDirectory();
                if (file2 != null && FileUtils.areDirectoriesEqual(file2, file)) {
                    this._dialog._dismiss(file);
                } else {
                    int n = this._tree.setDirectory(file, false);
                }
            }
        } else if (this._dialog.isCreateAllowed()) {
            if (this._runQueryAlert(_TRY_CREATE_KEY, file) == 1) {
                int n = this._tree.setDirectory(file, true);
                switch (n) {
                    case 0: {
                        this._dialog._dismiss(file);
                        break;
                    }
                    case 1: {
                        this._runDirectoryAlert(_WRITE_FAILED_KEY, file);
                        this._clearTreeSelection();
                        break;
                    }
                    case 2: 
                    case 3: {
                        this._runDirectoryAlert(_CREATE_FAILED_KEY, file);
                        this._clearTreeSelection();
                    }
                }
            }
        } else {
            this._runDirectoryAlert(_NO_DIRECTORY_KEY, file);
            this._clearTreeSelection();
        }
    }

    private void _clearTreeSelection() {
        DTreeSelection dTreeSelection = this._tree.getSelection();
        dTreeSelection.selectItem(null);
        this._field.requestFocus();
    }

    private void _runDirectoryAlert(String string, File file) {
        Alert alert = new Alert((Frame)this._dialog.getParent(), this._getDirectoryMessage(string, file), 0, 1);
        alert.setTitle(this._dialog._getMessage(_KEY_ERROR_TITLE));
        alert.setCenterOver(this._dialog);
        alert.runAlert();
    }

    private int _runQueryAlert(String string, File file) {
        Alert alert = new Alert((Frame)this._dialog.getParent(), this._getDirectoryMessage(string, file), 0, 3);
        alert.setTitle(this._dialog._getMessage(_KEY_QUERY_TITLE));
        alert.setCenterOver(this._dialog);
        return alert.runAlert();
    }

    private String _getDirectoryMessage(String string, File file) {
        String string2 = this._dialog._getMessage(string);
        Object[] objectArray = new Object[]{file.getPath()};
        return MessageFormat.format(string2, objectArray);
    }
}

