/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.oracle;

import java.awt.Image;
import oracle.ewt.ColorScheme;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.UIManager;
import oracle.ewt.graphics.ImageStrip;
import oracle.ewt.graphics.ImageUtils;
import oracle.ewt.laf.basic.DisabledBGPainter;
import oracle.ewt.laf.basic.DisablingPainter;
import oracle.ewt.laf.oracle.GrayFilter;
import oracle.ewt.laf.oracle.OracleInsetBorderPainter;
import oracle.ewt.laf.oracle.OracleLookAndFeel;
import oracle.ewt.painter.AlignmentPainter;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FGBGColorChange;
import oracle.ewt.painter.FilledRectPainter;
import oracle.ewt.painter.ImagePainter;
import oracle.ewt.painter.ImageSetPainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.painter.TruncatingTextPainter;

public class OracleUIUtils {
    private static Painter _sImagePainter;
    private static Painter _sAlignedImagePainter;
    private static Painter _sSingleLineTextPainter;
    private static Painter _sFilledRectanglePainter;
    private static Painter _sBackgroundPainter;
    private static Painter _sDisabledBackgroundPainter;
    private static BorderPainter _sWideInsetPainter;
    private static BorderPainter _sNarrowInsetPainter;
    private static Painter _sTruncatingTextPainter;
    private static Painter _sImageSetPainter;

    public static Painter getSingleLineTextPainter() {
        if (_sSingleLineTextPainter == null) {
            _sSingleLineTextPainter = new DisablingPainter(_sTruncatingTextPainter);
        }
        return _sSingleLineTextPainter;
    }

    public static Painter getTruncatingTextPainter() {
        return _sTruncatingTextPainter;
    }

    public static Painter getImagePainter() {
        if (_sImagePainter == null) {
            _sImagePainter = new ImagePainter();
        }
        return _sImagePainter;
    }

    public static Painter getImageSetPainter() {
        return _sImageSetPainter;
    }

    public static Painter getAlignedImagePainter() {
        if (_sAlignedImagePainter == null) {
            _sAlignedImagePainter = new AlignmentPainter(OracleUIUtils.getImagePainter());
        }
        return _sAlignedImagePainter;
    }

    public static Painter getFilledRectanglePainter() {
        if (_sFilledRectanglePainter == null) {
            _sFilledRectanglePainter = FilledRectPainter.getPainter();
        }
        return _sFilledRectanglePainter;
    }

    public static Painter getBackgroundPainter() {
        if (_sBackgroundPainter == null) {
            _sBackgroundPainter = new FGBGColorChange(OracleUIUtils.getFilledRectanglePainter(), false);
        }
        return _sBackgroundPainter;
    }

    public static Painter getDisabledBackgroundPainter() {
        if (_sDisabledBackgroundPainter == null) {
            _sDisabledBackgroundPainter = new DisabledBGPainter(OracleUIUtils.getFilledRectanglePainter());
        }
        return _sDisabledBackgroundPainter;
    }

    public static BorderPainter getNarrowInsetBorderPainter() {
        return _sNarrowInsetPainter;
    }

    public static BorderPainter getWideInsetBorderPainter() {
        return _sWideInsetPainter;
    }

    public static ImageSetPainter createImageSetPainter(String string, int n, ColorScheme colorScheme) {
        return new ImageSetPainter(new ImageStrip(OracleUIUtils.getColorizedImage(string, colorScheme), n));
    }

    public static Object cImageInst(UIDefaults uIDefaults, Object object, String string) {
        int n = string.lastIndexOf("%");
        if (n < 0) {
            return OracleUIUtils.getColorizedImage(string, null);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        ColorScheme colorScheme = null;
        try {
            OracleLookAndFeel oracleLookAndFeel = (OracleLookAndFeel)UIManager.getLookAndFeel();
            colorScheme = oracleLookAndFeel.getColorScheme(string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return OracleUIUtils.getColorizedImage(string2, colorScheme);
    }

    public static Object imageInst(UIDefaults uIDefaults, Object object, String string) {
        return OracleUIUtils.getImage(string);
    }

    public static Object imageFilterInst(UIDefaults uIDefaults, Object object, String string) {
        if (object.equals(LookAndFeel.DISABLING_FILTER)) {
            return new GrayFilter(true);
        }
        return null;
    }

    public static Image getImage(String string) {
        return ImageUtils.getImageResource(OracleUIUtils.class, "images/" + string);
    }

    public static Image getColorizedImage(String string, ColorScheme colorScheme) {
        return ImageUtils.createFilteredImage(OracleUIUtils.getImage(string), OracleLookAndFeel.createColorizingFilter(colorScheme));
    }

    static {
        _sWideInsetPainter = new OracleInsetBorderPainter(false);
        _sNarrowInsetPainter = new OracleInsetBorderPainter(true);
        _sTruncatingTextPainter = new TruncatingTextPainter();
        _sImageSetPainter = new ImageSetPainter();
    }
}

