/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwText.displayFilter;

import oracle.ewt.lwAWT.lwText.LWCommonText;
import oracle.ewt.lwAWT.lwText.displayFilter.IdentityDisplayFilter;

public class CharEchoFilter
extends IdentityDisplayFilter {
    private char _replacementChar;

    public CharEchoFilter() {
        this('\u0000');
    }

    public CharEchoFilter(char c) {
        this.setReplacementChar(c);
    }

    public String convertString(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        char c = this.getReplacementChar();
        if (LWCommonText.isSurrogatePairSupportEnabled()) {
            n = string.codePointCount(0, n);
        }
        for (int i = 0; i < n; ++i) {
            cArray[i] = c;
        }
        return new String(cArray);
    }

    public int displayIndexToValueIndex(String string, int n) {
        if (!LWCommonText.isSurrogatePairSupportEnabled()) {
            return n;
        }
        if (n <= 0) {
            return 0;
        }
        try {
            return string.offsetByCodePoints(0, n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return string.length();
        }
    }

    public int valueIndexToDisplayIndex(String string, int n) {
        if (!LWCommonText.isSurrogatePairSupportEnabled()) {
            return n;
        }
        if (n <= 0) {
            return 0;
        }
        if (n > string.length()) {
            n = string.length();
        }
        return string.codePointCount(0, n);
    }

    public void setReplacementChar(char c) {
        this._replacementChar = c;
    }

    public char getReplacementChar() {
        return this._replacementChar;
    }
}

