/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.shuttle;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.text.Collator;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.Sort;
import oracle.bali.share.sort.StringComparator;
import oracle.ewt.lwAWT.LWList;
import oracle.ewt.shuttle.ConsumableActionEvent;
import oracle.ewt.shuttle.ToMultiItemPicker;

public class ListPicker
implements ToMultiItemPicker,
ItemListener,
ActionListener,
KeyListener {
    private LWList _list;
    private ActionListener _actionListener;
    private ItemListener _itemListener;
    private boolean _sort;
    private static Comparator _sComparator;
    private static final DataFlavor[] sSupportedFlavors;

    public ListPicker(LWList lWList) {
        if (null == lWList) {
            throw new IllegalArgumentException();
        }
        this._list = lWList;
        this._list.addItemListener(this);
        this._list.addActionListener(this);
        this._list.addKeyListener(this);
        if (this.getItemsSorted()) {
            this.sortItems();
        }
    }

    public boolean getItemsSorted() {
        return this._sort;
    }

    public void setSortItems(boolean bl) {
        this._sort = bl;
    }

    public LWList getList() {
        return this._list;
    }

    public boolean isSelectableItemPresent() {
        return this._list.getItemCount() != 0;
    }

    public boolean isItemSelected() {
        int[] nArray = this._list.getSelectedIndexes();
        if (nArray != null) {
            return nArray.length != 0;
        }
        return false;
    }

    public void deselectAll() {
        int[] nArray = this._list.getSelectedIndexes();
        int n = 0;
        if (nArray != null) {
            n = nArray.length;
        }
        for (int i = 0; i < n; ++i) {
            this._list.deselect(nArray[i]);
        }
    }

    public void removeSelectedItems() {
        int n = this._list.getFocusedItem();
        String[] stringArray = this._list.getSelectedItems();
        int n2 = stringArray == null ? 0 : stringArray.length;
        this._list.freezeRepaints();
        --n2;
        while (n2 >= 0) {
            this._list.remove(stringArray[n2]);
            --n2;
        }
        if (this._list.getItemCount() <= n) {
            n = this._list.getItemCount() - 1;
        }
        this._list.setFocusedItem(n);
        this._list.unfreezeRepaints();
    }

    public void removeAllSelectableItems() {
        this._list.freezeRepaints();
        this._list.removeAll();
        this._list.unfreezeRepaints();
    }

    public Transferable[] getSelectedItems() {
        String[] stringArray = this._list.getSelectedItems();
        if (stringArray != null) {
            int n = stringArray.length;
            Transferable[] transferableArray = new StringSelection[n];
            for (int i = 0; i < n; ++i) {
                transferableArray[i] = new StringSelection(stringArray[i]);
            }
            return transferableArray;
        }
        return null;
    }

    public Transferable[] getAllSelectableItems() {
        String[] stringArray = this._list.getItems();
        if (stringArray != null) {
            int n = stringArray.length;
            Transferable[] transferableArray = new StringSelection[n];
            for (int i = 0; i < n; ++i) {
                transferableArray[i] = new StringSelection(stringArray[i]);
            }
            return transferableArray;
        }
        return null;
    }

    public Component getComponent() {
        return this._list;
    }

    public DataFlavor[] getSupportedDataFlavors() {
        return sSupportedFlavors;
    }

    public void addActionListener(ActionListener actionListener) {
        this._actionListener = AWTEventMulticaster.add(this._actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this._actionListener = AWTEventMulticaster.remove(this._actionListener, actionListener);
        if (this._actionListener == null) {
            this._list.removeActionListener(this);
            this._list.removeKeyListener(this);
        }
    }

    public boolean addSelectedItems(Transferable[] transferableArray) {
        return this._insertItems(transferableArray);
    }

    public boolean isReorderable() {
        return true;
    }

    public boolean isSelectionUpwardlyMobile() {
        return this._isSelectionMobile(true);
    }

    public boolean isSelectionDownwardlyMobile() {
        return this._isSelectionMobile(false);
    }

    public void moveSelectionUp() {
        this._moveSelection(true);
    }

    public void moveSelectionDown() {
        this._moveSelection(false);
    }

    public boolean canAcceptFlavors(DataFlavor[] dataFlavorArray) {
        DataFlavor[] dataFlavorArray2 = sSupportedFlavors;
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            for (int j = 0; j < dataFlavorArray2.length; ++j) {
                if (!dataFlavorArray[i].equals(dataFlavorArray2[j])) continue;
                return true;
            }
        }
        return false;
    }

    public void addItemListener(ItemListener itemListener) {
        this._itemListener = AWTEventMulticaster.add(this._itemListener, itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this._itemListener = AWTEventMulticaster.remove(this._itemListener, itemListener);
        if (this._itemListener == null) {
            this._list.removeItemListener(this);
        }
    }

    public Object[] getSelectedObjects() {
        return this.getSelectedItems();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this._itemListener.itemStateChanged(new ItemEvent(this, itemEvent.getID(), itemEvent.getItem(), itemEvent.getStateChange()));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this._actionListener != null) {
            ConsumableActionEvent consumableActionEvent = new ConsumableActionEvent(this, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getModifiers());
            this._actionListener.actionPerformed(consumableActionEvent);
            if (actionEvent instanceof ConsumableActionEvent && consumableActionEvent.isConsumed()) {
                ((ConsumableActionEvent)actionEvent).consume();
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 && this._actionListener != null) {
            ConsumableActionEvent consumableActionEvent = new ConsumableActionEvent(this, 1001, null);
            this._actionListener.actionPerformed(consumableActionEvent);
            if (consumableActionEvent.isConsumed()) {
                keyEvent.consume();
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    protected synchronized void sortItems() {
        Object[] objectArray = this._list.getItems();
        this._list.removeAll();
        Sort.qSort((Object[])objectArray, (int)objectArray.length, (Comparator)this._getComparator());
        for (int i = 0; i < objectArray.length; ++i) {
            this._list.add((String)objectArray[i]);
        }
    }

    private boolean _insertItems(Transferable[] transferableArray) {
        if (!this._checkFlavorCompatibility(transferableArray)) {
            return false;
        }
        int n = transferableArray.length;
        int n2 = this._list.getItemCount();
        this._list.freezeRepaints();
        for (int i = 0; i < n; ++i) {
            Transferable transferable = transferableArray[i];
            if (!transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) continue;
            String[] stringArray = null;
            Object object = null;
            try {
                object = transferable.getTransferData(DataFlavor.stringFlavor);
                stringArray = (String[])object;
            }
            catch (ClassCastException classCastException) {
                if (!(object instanceof String)) {
                    return false;
                }
                stringArray = new String[]{(String)object};
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
            for (int j = 0; j < stringArray.length; ++j) {
                this._list.add(stringArray[j]);
                this._list.select(n2);
                ++n2;
            }
        }
        if (this.getItemsSorted()) {
            this.sortItems();
        }
        this._list.unfreezeRepaints();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _moveSelection(boolean bl) {
        int n;
        int[] nArray = this._list.getSelectedIndexes();
        int n2 = n = nArray == null ? 0 : nArray.length;
        if (n > 0) {
            Sort.qSort((int[])nArray, (int)n, (boolean)true);
            try {
                this._list.freezeRepaints();
                int n3 = this._list.getFocusedItem();
                n3 = bl ? --n3 : ++n3;
                if (n3 < 0) {
                    n3 = 0;
                } else if (n3 >= this._list.getItemCount()) {
                    n3 = this._list.getItemCount() - 1;
                }
                int n4 = n - 1;
                while (n4 >= 0) {
                    String string;
                    int n5;
                    int n6;
                    int n7 = n6 = nArray[n4];
                    int n8 = n4;
                    while (n8 > 0 && nArray[n8] - nArray[n8 - 1] == 1) {
                        --n8;
                        --n7;
                    }
                    if (bl) {
                        for (n5 = n6; n5 >= n7; --n5) {
                            string = this._list.getItem(n6);
                            this._list.remove(n6);
                            this._list.add(string, n7 - 1);
                            this._list.select(n7 - 1);
                        }
                    } else {
                        for (n5 = n7; n5 <= n6; ++n5) {
                            string = this._list.getItem(n7);
                            this._list.remove(n7);
                            this._list.add(string, n6 + 1);
                            this._list.select(n6 + 1);
                        }
                    }
                    n4 = n8 - 1;
                }
                this._list.setFocusedItem(n3);
            }
            finally {
                this._list.unfreezeRepaints();
            }
        }
    }

    private boolean _isSelectionMobile(boolean bl) {
        int n;
        boolean bl2 = false;
        int[] nArray = this._list.getSelectedIndexes();
        int n2 = n = nArray == null ? 0 : nArray.length;
        if (n != 0) {
            int n3 = nArray[0];
            int n4 = nArray[n - 1];
            for (int i = 0; i < n; ++i) {
                if (nArray[i] < n3) {
                    n3 = nArray[i];
                }
                if (nArray[i] <= n4) continue;
                n4 = nArray[i];
            }
            bl2 = bl ? n3 != 0 : n4 != this._list.getItemCount() - 1;
        }
        return bl2;
    }

    private boolean _checkFlavorCompatibility(Transferable[] transferableArray) {
        if (transferableArray == null) {
            return false;
        }
        for (int i = 0; i < transferableArray.length; ++i) {
            Transferable transferable = transferableArray[i];
            if (transferable == null || this.canAcceptFlavors(transferable.getTransferDataFlavors())) continue;
            return false;
        }
        return true;
    }

    private Comparator _getComparator() {
        if (_sComparator == null) {
            _sComparator = new StringComparator(Collator.getInstance());
        }
        return _sComparator;
    }

    static {
        sSupportedFlavors = new DataFlavor[]{DataFlavor.stringFlavor};
    }
}

