/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.infotip;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import oracle.javatools.ui.border.PointingBorder;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.themes.LinearGradientPainter;

class InfoTipComponent
extends JPanel {
    private final PointingBorder pointingBorder;
    InfoTipStyles style;
    private float fadeAmount = 1.0f;

    InfoTipComponent(PointingBorder.Direction direction, InfoTipStyles style) {
        this.style = style;
        this.pointingBorder = new GradientPointingBorder(direction);
        this.setLayout(new BorderLayout());
        Insets insets = style.getBorderInsets();
        CompoundBorder border = BorderFactory.createCompoundBorder(this.pointingBorder, BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
        this.setBorder(border);
        this.setOpaque(false);
        this.setBackground(UIManager.getColor("Label.background"));
        this.addMouseListener(new MouseAdapter(){});
        this.setupTemporaryHide();
    }

    void setDirection(PointingBorder.Direction direction) {
        this.pointingBorder.setDirection(direction);
        this.repaint();
    }

    PointingBorder.Direction getDirection() {
        return this.pointingBorder.getDirection();
    }

    void setXOffset(int offset) {
        this.pointingBorder.setXOffset(offset);
    }

    void setYOffset(int offset) {
        this.pointingBorder.setYOffset(offset);
    }

    protected void setupTemporaryHide() {
        KeyStroke hide = KeyStroke.getKeyStroke(18, 512);
        KeyStroke hideCtrl = KeyStroke.getKeyStroke(18, 640);
        String HIDE_KEY = "HIDE_KEY";
        this.getInputMap(2).put(hide, HIDE_KEY);
        this.getInputMap(2).put(hideCtrl, HIDE_KEY);
        this.getActionMap().put(HIDE_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InfoTipComponent.this.fadeAmount = 0.1f;
                InfoTipComponent.this.repaint();
            }
        });
        KeyStroke showUp = KeyStroke.getKeyStroke(18, 0, true);
        KeyStroke showUpShift = KeyStroke.getKeyStroke(18, 64, true);
        KeyStroke showUpCtrl = KeyStroke.getKeyStroke(18, 128, true);
        String SHOW_UP_KEY = "SHOW_UP_KEY";
        this.getInputMap(2).put(showUp, SHOW_UP_KEY);
        this.getInputMap(2).put(showUpShift, SHOW_UP_KEY);
        this.getInputMap(2).put(showUpCtrl, SHOW_UP_KEY);
        this.getActionMap().put(SHOW_UP_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InfoTipComponent.this.fadeAmount = 1.0f;
                InfoTipComponent.this.repaint();
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        if (this.fadeAmount >= 0.0f && this.fadeAmount < 1.0f) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setComposite(AlphaComposite.getInstance(3, this.fadeAmount));
        }
        super.paint(g);
    }

    private class GradientPointingBorder
    extends PointingBorder {
        public GradientPointingBorder(PointingBorder.Direction direction) {
            super(direction);
            this.setBorderColor(InfoTipComponent.this.style.getBackgroundBorderColor());
            this.setPointSize(25, 13);
        }

        @Override
        protected void paintBackground(Graphics2D g2, Component c, Shape s) {
            LinearGradientPainter backgroundPainter = InfoTipComponent.this.style.getBackgroundPainter();
            backgroundPainter.paint(g2, s);
        }
    }
}

