/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.table;

import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.RolloverTableHandler;
import oracle.javatools.ui.table.TableUIManager;

public class RolloverTableRenderer
implements TableCellRenderer {
    private TableCellRenderer _baseRenderer;
    private boolean _explicitlySetBackground;

    public RolloverTableRenderer(TableCellRenderer baseRenderer) {
        this.setBaseRenderer(baseRenderer);
    }

    public TableCellRenderer getBaseRenderer() {
        return this._baseRenderer;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        SortOrder order;
        List<RowSorter.SortKey> sortKeys;
        boolean setBack = this._explicitlySetBackground;
        TableCellRenderer baseRenderer = this.getBaseRenderer();
        if (baseRenderer == null && (baseRenderer = table.getDefaultRenderer(table.getColumnClass(column))) instanceof DefaultTableCellRenderer) {
            setBack = true;
        }
        Component c = baseRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        boolean isRollover = RolloverTableRenderer.isTableCellRolloverHighlight(table, row, column);
        boolean isSortColumn = false;
        RowSorter<? extends TableModel> sorter = table.getRowSorter();
        if (!(sorter == null || (sortKeys = sorter.getSortKeys()).isEmpty() || table.convertColumnIndexToView(sortKeys.get(0).getColumn()) != column || (order = sortKeys.get(0).getSortOrder()) != SortOrder.ASCENDING && order != SortOrder.DESCENDING)) {
            isSortColumn = true;
        }
        RolloverTableRenderer.setTableCellRolloverHighlight(table, c, isSelected, setBack, isRollover, isSortColumn);
        return c;
    }

    void setBaseRenderer(TableCellRenderer baseRenderer) {
        this._baseRenderer = baseRenderer;
        if (baseRenderer instanceof DefaultTableCellRenderer) {
            this._explicitlySetBackground = true;
        }
    }

    static boolean isTableCellRolloverHighlight(JTable table, int row, int column) {
        Integer rRow = (Integer)table.getClientProperty("ROLLOVER_ROW");
        Integer rCol = (Integer)table.getClientProperty("ROLLOVER_COLUMN");
        rRow = rRow == null ? -1 : rRow;
        rCol = rCol == null ? -1 : rCol;
        return table.getCellSelectionEnabled() && rRow == row && rCol == column || table.getRowSelectionAllowed() && !table.getColumnSelectionAllowed() && rRow == row || table.getColumnSelectionAllowed() && !table.getRowSelectionAllowed() && rCol == column || table.getCellSelectionEnabled() && rRow == row && rCol == -2 || table.getCellSelectionEnabled() && rRow == -2 && column == rCol;
    }

    static void setTableCellRolloverHighlight(JTable table, Component c, boolean isSelected, boolean explicitlySetBackground, boolean isRollover, boolean isSortColumn) {
        c.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
        if (isRollover) {
            if (isSelected) {
                c.setBackground(RolloverTableHandler.getTableCellRolloverSelectionHighlight());
                c.setForeground(table.getSelectionForeground());
            } else {
                c.setBackground(RolloverTableHandler.getTableCellRolloverHighlight());
                c.setForeground(table.getForeground());
            }
        } else if (explicitlySetBackground) {
            if (isSelected) {
                c.setBackground(table.getSelectionBackground());
            } else {
                if (isSortColumn) {
                    Color bg = ((GenericTable)table).getSortColumnBackgroundColor();
                    if (bg == null) {
                        bg = TableUIManager.SORTED_COL_BACK;
                    }
                    c.setBackground(bg);
                    return;
                }
                c.setBackground(table.getBackground());
            }
        }
    }
}

