/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.util.List;
import javax.ide.extension.Extension;
import oracle.ide.ExtensionRegistry;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.HashStructureNodeChangeEvent;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.Workspace;
import oracle.ide.model.WorkspaceChangeEvent;
import oracle.ide.model.WorkspaceChangeListener;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.library.ExtensionLibrary;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.model.ApplicationLibraries;
import oracle.jdeveloper.model.JProjectLibraries;

final class LibraryExtensionLoader
extends ProjectChangeListener
implements WorkspaceChangeListener {
    static void initialize() {
        LibraryExtensionLoader loader = new LibraryExtensionLoader();
        Project.addProjectChangeListener((String)"oracle.jdevimpl.config.JProjectLibraries/libraryReferences", (ProjectChangeListener)loader);
        Workspace.addWorkspaceChangeListener((String)"oracle.jdeveloper.model.ApplicationLibraries/libraryReferences", (WorkspaceChangeListener)loader);
        Workspace.addWorkspaceChangeListener((String)"oracle.jdeveloper.model.ApplicationLibraries/modulePathLibraryReferences", (WorkspaceChangeListener)loader);
        Node.addNodeListenerForType(Project.class, (NodeListener)new ProjectOpenListener());
        Node.addNodeListenerForType(Workspace.class, (NodeListener)new WorkspaceOpenListener());
    }

    private LibraryExtensionLoader() {
    }

    public void projectPropertiesChanged(ProjectChangeEvent e) {
        this.propertiesChanged((HashStructureNodeChangeEvent)e);
    }

    public void workspacePropertiesChanged(WorkspaceChangeEvent e) {
        this.propertiesChanged((HashStructureNodeChangeEvent)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void propertiesChanged(HashStructureNodeChangeEvent e) {
        for (ChangeInfo info : e.getChangeDetails()) {
            if (info.getChangeType() != 1) continue;
            HashStructure hash = info.getNewValueAsHashStructure();
            if (hash != null) {
                this.hashAdded(hash);
                continue;
            }
            ListStructure list = info.getNewValueAsListStructure();
            Object object = list.iteratorLock();
            synchronized (object) {
                for (Object o : list) {
                    if (!(o instanceof HashStructure)) continue;
                    this.hashAdded((HashStructure)o);
                }
            }
        }
    }

    private void hashAdded(HashStructure hash) {
        String id = hash.getString("id");
        if (id != null) {
            LibraryExtensionLoader.loadExtension(JLibraryManager.findLibrary(id));
        }
    }

    private static void loadExtension(JLibrary library) {
        ExtensionLibrary extensionLibrary;
        if (library instanceof ExtensionLibrary && (extensionLibrary = (ExtensionLibrary)library).getForceExtensionInitialization()) {
            LibraryExtensionLoader.loadExtension(extensionLibrary.getProviderExtensionId(), library.getID());
        }
    }

    private static void loadExtension(String extensionId, Object libraryId) {
        ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
        Extension extension = registry.findExtension(extensionId);
        if (extension != null) {
            registry.fullyLoadExtension(extension, "Triggered by library \"" + libraryId + "\"");
        } else {
            registry.getLogger().warning("Library \"" + libraryId + "\" requires extension \"" + extensionId + "\", but the extension is not registered");
        }
    }

    private static final class WorkspaceOpenListener
    extends NodeListener {
        private WorkspaceOpenListener() {
        }

        public void nodeWillOpen(NodeEvent e) {
            Node node = e.getNode();
            if (node instanceof Workspace) {
                ApplicationLibraries libraries = ApplicationLibraries.getInstance((Workspace)node);
                for (JLibrary library : libraries.getLibraryReferences()) {
                    LibraryExtensionLoader.loadExtension(library);
                }
            }
        }
    }

    private static final class ProjectOpenListener
    extends NodeListener {
        private ProjectOpenListener() {
        }

        public void nodeWillOpen(NodeEvent e) {
            Project project;
            DependencyConfiguration config;
            List dependables;
            Node node = e.getNode();
            if (node instanceof Project && (dependables = (config = DependencyConfiguration.getInstance((Project)(project = (Project)node))).getDependencyList()) != null) {
                for (Object dependency : dependables) {
                    Element source = ((Dependable)dependency).getSource();
                    if (!(source instanceof Project)) continue;
                    JProjectLibraries depLibraries = JProjectLibraries.getInstance((PropertyStorage)((Project)source));
                    for (JLibrary library : depLibraries.getExports()) {
                        LibraryExtensionLoader.loadExtension(library);
                    }
                }
            }
        }
    }
}

