/*
 * Decompiled with CFR 0.152.
 */
package ice.scripters;

import ice.scripters.WindowObj;
import ice.storm.DynEnv;
import ice.storm.DynamicList;
import ice.storm.DynamicObject;
import ice.storm.Viewport;

public final class FramesList
extends DynamicList {
    private WindowObj window;

    FramesList(WindowObj window_arg) {
        this.window = window_arg;
    }

    protected int getLength() {
        int length = 0;
        for (Viewport v = this.window.theView.getFirstChild(); v != null; v = v.getNextSibling()) {
            if (!v.isFrameArrayMember()) continue;
            ++length;
        }
        return length;
    }

    private DynamicObject getFrameByIndex(int index) {
        Viewport v;
        for (v = this.window.theView.getFirstChild(); v != null; v = v.getNextSibling()) {
            if (!v.isFrameArrayMember()) continue;
            if (index == 0) break;
            --index;
        }
        return v == null ? null : v.getWindowObj();
    }

    public DynamicObject getFrameByName(String name) {
        Viewport v;
        for (v = this.window.theView.getFirstChild(); !(v == null || v.isFrameArrayMember() && v.getName().equals(name)); v = v.getNextSibling()) {
        }
        return v == null ? null : v.getWindowObj();
    }

    protected Object script_item(int index, DynEnv env) {
        return this.getFrameByIndex(index);
    }

    protected Object script_namedItem(String name, DynEnv env) {
        DynamicObject frame = this.getFrameByName(name);
        if (frame == null) {
            this.window.theView.getPilot().updateFrameList();
            frame = this.getFrameByName(name);
        }
        return frame;
    }

    public String toString() {
        return "[FramesList: " + this.getLength() + "]";
    }
}

