/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.history;

import java.net.URL;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import oracle.ide.util.Assert;
import oracle.ide.util.Enum;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.history.HistoryModel;
import oracle.javatools.history.HistoryProperty;
import oracle.jdeveloper.history.CustomFilterSubstitution;
import oracle.jdeveloper.history.DefaultHistoryFilter;
import oracle.jdeveloper.history.DefaultHistoryProperty;
import oracle.jdeveloper.history.HistoryManager;
import oracle.jdeveloper.history.RevisionIdentifier;

public class CustomFilter
extends DefaultHistoryFilter {
    private static final String REGEXP_PREFIX = "REGEXP:";
    private final String _source;
    private final Expression _expression;
    private String _name;

    private CustomFilter(String source, Expression expression) {
        this._source = source;
        this._expression = expression;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CustomFilter)) {
            return false;
        }
        String otherName = ((CustomFilter)o)._name;
        if (this._name == null || otherName == null) {
            return super.equals(o);
        }
        return otherName.equals(this._name) && ((CustomFilter)o)._source.equals(this._source);
    }

    public int hashCode() {
        return this._name != null ? this._name.intern().hashCode() : super.hashCode();
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public String getSource() {
        return this._source;
    }

    @Override
    public boolean accept(HistoryModel model, URL url, HistoryEntry entry) {
        return this._expression.evaluate(model, url, entry);
    }

    @Override
    public String getShortLabel() {
        return this._name != null ? this._name : this._source;
    }

    public static final CustomFilter parse(String source) throws ParseException {
        return new CustomFilter(source, Expression.parse(source.split("\\s+"), new ParsePosition(0)));
    }

    private static final DateFormat createDateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd zzz"){
            private final String _timezoneSuffix = " " + new SimpleDateFormat("zzz").format(new Date(0L));

            @Override
            public Date parse(String source, ParsePosition pos) {
                return super.parse(source + this._timezoneSuffix, pos);
            }

            @Override
            public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
                StringBuffer formatBuffer = super.format(date, toAppendTo, fieldPosition);
                formatBuffer.setLength(10);
                return formatBuffer;
            }
        };
        return dateFormat;
    }

    private static class BooleanOperator
    extends Enum {
        public static final BooleanOperator AND = new BooleanOperator("AND");
        public static final BooleanOperator OR = new BooleanOperator("OR");
        private static int _nextOrdinal = 0;

        private BooleanOperator(String name) {
            super(name, _nextOrdinal++);
        }

        static BooleanOperator parse(String[] tokens, ParsePosition pp) throws ParseException {
            BooleanOperator result = BooleanOperator.look(tokens, pp);
            pp.setIndex(pp.getIndex() + 1);
            if (result != null) {
                return result;
            }
            throw new ParseException("", 0);
        }

        static BooleanOperator look(String[] tokens, ParsePosition pp) {
            if (pp.getIndex() >= tokens.length) {
                return null;
            }
            String token = tokens[pp.getIndex()];
            if (token.equalsIgnoreCase("AND")) {
                return AND;
            }
            if (token.equalsIgnoreCase("OR")) {
                return OR;
            }
            return null;
        }

        boolean evaluate(HistoryModel model, URL url, HistoryEntry entry, boolean leftProduction, Expression expression2) {
            if (this == AND) {
                return leftProduction && expression2.evaluate(model, url, entry);
            }
            if (this == OR) {
                return leftProduction || expression2.evaluate(model, url, entry);
            }
            return false;
        }
    }

    private static class ArithmeticOperator
    extends Enum {
        public static final ArithmeticOperator PLUS = new ArithmeticOperator("PLUS");
        public static final ArithmeticOperator MINUS = new ArithmeticOperator("MINUS");
        private static int _nextOrdinal = 0;

        private ArithmeticOperator(String name) {
            super(name, _nextOrdinal++);
        }

        static ArithmeticOperator parse(String[] tokens, ParsePosition pp) throws ParseException {
            ArithmeticOperator result = ArithmeticOperator.look(tokens, pp);
            pp.setIndex(pp.getIndex() + 1);
            if (result != null) {
                return result;
            }
            throw new ParseException("", 0);
        }

        static ArithmeticOperator look(String[] tokens, ParsePosition pp) {
            if (pp.getIndex() >= tokens.length) {
                return null;
            }
            String token = tokens[pp.getIndex()];
            if (token.equalsIgnoreCase("+")) {
                return PLUS;
            }
            if (token.equalsIgnoreCase("-")) {
                return MINUS;
            }
            return null;
        }

        Object evaluate(HistoryModel model, URL url, HistoryEntry entry, Object leftProduction, Value value2) {
            Object o1 = leftProduction;
            Object o2 = value2.evaluate(model, url, entry);
            if (o1 instanceof Date) {
                o1 = new Long(Value.convertDateToLong((Date)o1));
            }
            if (o2 instanceof Date) {
                o2 = new Long(Value.convertDateToLong((Date)o2));
            }
            if (!(o1 instanceof Number) || !(o2 instanceof Number)) {
                return o1;
            }
            if (this == PLUS) {
                return new Long(((Number)o1).longValue() + ((Number)o2).longValue());
            }
            if (this == MINUS) {
                return new Long(((Number)o1).longValue() - ((Number)o2).longValue());
            }
            return o1;
        }
    }

    private static class ConditionalOperator
    extends Enum {
        public static final ConditionalOperator EQUALS = new ConditionalOperator("EQUALS");
        public static final ConditionalOperator GREATER_OR_LESS_THAN = new ConditionalOperator("GREATER_OR_LESS_THAN");
        public static final ConditionalOperator NOT_EQUALS = new ConditionalOperator("NOT_EQUALS");
        public static final ConditionalOperator GREATER_THAN = new ConditionalOperator("GREATER_THAN");
        public static final ConditionalOperator LESS_THAN = new ConditionalOperator("LESS_THAN");
        public static final ConditionalOperator GREATER_THAN_OR_EQUALS = new ConditionalOperator("GREATER_THAN_OR_EQUALS");
        public static final ConditionalOperator LESS_THAN_OR_EQUALS = new ConditionalOperator("LESS_THAN_OR_EQUALS");
        public static final ConditionalOperator MATCHES = new ConditionalOperator("MATCHES");
        private static int _nextOrdinal = 0;

        private ConditionalOperator(String name) {
            super(name, _nextOrdinal++);
        }

        static ConditionalOperator parse(String[] tokens, ParsePosition pp) throws ParseException {
            if (pp.getIndex() >= tokens.length) {
                throw new ParseException("", 0);
            }
            String token = tokens[pp.getIndex()];
            pp.setIndex(pp.getIndex() + 1);
            if (token.equals("=")) {
                return EQUALS;
            }
            if (token.equals("<>")) {
                return GREATER_OR_LESS_THAN;
            }
            if (token.equals("!=")) {
                return NOT_EQUALS;
            }
            if (token.equals(">")) {
                return GREATER_THAN;
            }
            if (token.equals("<")) {
                return LESS_THAN;
            }
            if (token.equals(">=")) {
                return GREATER_THAN_OR_EQUALS;
            }
            if (token.equals("<=")) {
                return LESS_THAN_OR_EQUALS;
            }
            if (token.equalsIgnoreCase("MATCHES")) {
                return MATCHES;
            }
            throw new ParseException("", 0);
        }

        boolean evaluate(HistoryModel model, URL url, HistoryEntry entry, Column column, Value value) {
            if (column == null) {
                return false;
            }
            Object o1 = column.evaluate(model, url, entry);
            if (o1 == null) {
                return false;
            }
            Object o2 = value.evaluate(model, url, entry);
            if (this == MATCHES) {
                o1 = this.convertValueToString(o1, false);
                if (((String)(o2 = this.convertValueToString(o2, false))).toUpperCase().startsWith(CustomFilter.REGEXP_PREFIX)) {
                    if (!(o1 instanceof String) || !(o2 instanceof String)) {
                        return false;
                    }
                    try {
                        return Pattern.compile(((String)o2).substring(CustomFilter.REGEXP_PREFIX.length())).matcher((String)o1).find();
                    }
                    catch (PatternSyntaxException pse) {
                        return false;
                    }
                }
                return ((String)o1).indexOf((String)o2) >= 0;
            }
            if (o1 instanceof Date) {
                o1 = Value.convertLongToDate(Value.convertDateToLong((Date)o1));
            }
            if (o1 instanceof Date && o2 instanceof Number) {
                o2 = Value.convertLongToDate(((Number)o2).longValue());
            }
            if (o1 instanceof RevisionIdentifier) {
                o2 = new RevisionIdentifier(null, this.convertValueToString(o2, true));
            }
            if (!(o1 instanceof Comparable) || !o1.getClass().isInstance(o2)) {
                o1 = this.convertValueToString(o1, true);
                o2 = this.convertValueToString(o2, true);
            }
            Comparable c1 = (Comparable)o1;
            Comparable c2 = (Comparable)o2;
            if (this == EQUALS) {
                return c1.equals(c2);
            }
            if (this == GREATER_OR_LESS_THAN) {
                return c1.compareTo(c2) != 0;
            }
            if (this == NOT_EQUALS) {
                return !c1.equals(c2);
            }
            if (this == GREATER_THAN) {
                return c1.compareTo(c2) > 0;
            }
            if (this == LESS_THAN) {
                return c1.compareTo(c2) < 0;
            }
            if (this == GREATER_THAN_OR_EQUALS) {
                return c1.compareTo(c2) >= 0;
            }
            if (this == LESS_THAN_OR_EQUALS) {
                return c1.compareTo(c2) <= 0;
            }
            return false;
        }

        private String convertValueToString(Object value, boolean numeric) {
            if (value instanceof String) {
                return value.toString();
            }
            if (value instanceof Number) {
                return NumberFormat.getIntegerInstance().format(value);
            }
            if (value instanceof Date) {
                if (numeric) {
                    return CustomFilter.createDateFormat().format(value);
                }
                return DateFormat.getDateTimeInstance().format(value);
            }
            return value.toString();
        }
    }

    private static class Value {
        private static final long MILLIS_PER_DAY = 86400000L;
        private String _atom;
        private ArithmeticOperator _arithmetic;
        private Value _value;

        private Value() {
        }

        static Value parse(String[] tokens, ParsePosition pp) throws ParseException {
            Value value = new Value();
            if (pp.getIndex() >= tokens.length) {
                throw new ParseException("", 0);
            }
            String token = tokens[pp.getIndex()];
            pp.setIndex(pp.getIndex() + 1);
            value._atom = token;
            if (value._atom.toUpperCase().startsWith(CustomFilter.REGEXP_PREFIX)) {
                String regexp = value._atom.substring(CustomFilter.REGEXP_PREFIX.length());
                if (regexp.equals("")) {
                    throw new ParseException("", 0);
                }
                try {
                    Pattern.compile(regexp);
                }
                catch (PatternSyntaxException pse) {
                    throw new ParseException("", 0);
                }
            }
            if (ArithmeticOperator.look(tokens, pp) != null) {
                value._arithmetic = ArithmeticOperator.parse(tokens, pp);
                value._value = Value.parse(tokens, pp);
            }
            return value;
        }

        Object evaluate(HistoryModel model, URL url, HistoryEntry entry) {
            Object result = this._evaluate(model, url, entry);
            if (result instanceof Date) {
                result = Value.convertLongToDate(Value.convertDateToLong((Date)result));
            }
            if (this._arithmetic != null) {
                return this._arithmetic.evaluate(model, url, entry, result, this._value);
            }
            return result;
        }

        private Object _evaluate(HistoryModel model, URL url, HistoryEntry entry) {
            if (this._atom.toUpperCase().startsWith(CustomFilter.REGEXP_PREFIX)) {
                return this._atom;
            }
            if (Pattern.matches("^\\$\\{.+\\}$", this._atom)) {
                return this.evaluateSubstitution(model, url);
            }
            try {
                if (Pattern.matches("^-?\\d+$", this._atom)) {
                    return Long.valueOf(this._atom);
                }
            }
            catch (NumberFormatException nfe) {
                Assert.printStackTrace((Throwable)nfe);
            }
            try {
                if (Pattern.matches("^\\d{4}-\\d{2}-\\d{2}$", this._atom)) {
                    return CustomFilter.createDateFormat().parse(this._atom);
                }
            }
            catch (ParseException pe) {
                Assert.printStackTrace((Throwable)pe);
            }
            return this._atom;
        }

        private Object evaluateSubstitution(HistoryModel model, URL url) {
            CustomFilterSubstitution[] substitutions = HistoryManager.getHistoryManager().getCustomFilterManager().getSubstitutions();
            Object result = null;
            for (int i = 0; i < substitutions.length; ++i) {
                if (!this._atom.equals("${" + substitutions[i].getName() + "}")) continue;
                result = substitutions[i].evaluate(model, url);
                break;
            }
            return result != null ? result : "";
        }

        static final long convertDateToLong(Date date) {
            DateFormat dateFormat = CustomFilter.createDateFormat();
            try {
                return dateFormat.parse(dateFormat.format(date)).getTime() / 86400000L;
            }
            catch (ParseException pe) {
                Assert.printStackTrace((Throwable)pe);
                return date.getTime() / 86400000L;
            }
        }

        static final Date convertLongToDate(long long_) {
            DateFormat dateFormat = CustomFilter.createDateFormat();
            try {
                return dateFormat.parse(dateFormat.format(new Date(long_ * 86400000L)));
            }
            catch (ParseException pe) {
                Assert.printStackTrace((Throwable)pe);
                return new Date(long_ * 86400000L);
            }
        }
    }

    private static class Column {
        private String _column;

        private Column() {
        }

        static Column parse(String[] tokens, ParsePosition pp) throws ParseException {
            Column column = new Column();
            if (pp.getIndex() >= tokens.length) {
                throw new ParseException("", 0);
            }
            String token = tokens[pp.getIndex()];
            pp.setIndex(pp.getIndex() + 1);
            column._column = token;
            return column;
        }

        Object evaluate(HistoryModel model, URL url, HistoryEntry entry) {
            HistoryProperty[] properties = model.getProperties();
            for (int i = 0; i < properties.length; ++i) {
                String customFilterId;
                if (!(properties[i] instanceof DefaultHistoryProperty) || (customFilterId = ((DefaultHistoryProperty)properties[i]).getCustomFilterId()) == null || !customFilterId.equalsIgnoreCase(this._column)) continue;
                return entry.getValue(properties[i]);
            }
            return null;
        }
    }

    private static class Expression {
        private boolean _not;
        private Column _column;
        private ConditionalOperator _conditional;
        private Value _value;
        private BooleanOperator _boolean;
        private Expression _expression;

        private Expression() {
        }

        static Expression parse(String[] tokens, ParsePosition pp) throws ParseException {
            Expression expression = new Expression();
            if (pp.getIndex() < tokens.length && tokens[pp.getIndex()].equalsIgnoreCase("NOT")) {
                expression._not = true;
                pp.setIndex(pp.getIndex() + 1);
            }
            if (pp.getIndex() >= tokens.length) {
                throw new ParseException("", 0);
            }
            expression._column = Column.parse(tokens, pp);
            expression._conditional = ConditionalOperator.parse(tokens, pp);
            expression._value = Value.parse(tokens, pp);
            if (pp.getIndex() < tokens.length) {
                expression._boolean = BooleanOperator.parse(tokens, pp);
                expression._expression = Expression.parse(tokens, pp);
            }
            if (pp.getIndex() >= tokens.length) {
                return expression;
            }
            throw new ParseException("", 0);
        }

        boolean evaluate(HistoryModel model, URL url, HistoryEntry entry) {
            boolean result = this._evaluate(model, url, entry);
            if (this._boolean != null) {
                return this._boolean.evaluate(model, url, entry, result, this._expression);
            }
            return result;
        }

        private boolean _evaluate(HistoryModel model, URL url, HistoryEntry entry) {
            return this._not ^ this._conditional.evaluate(model, url, entry, this._column, this._value);
        }
    }
}

