/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator.tocNavigator;

import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.bali.ewt.dTree.DTreeDeferredParent;
import oracle.bali.ewt.dTree.DTreeDeferringParent;
import oracle.bali.ewt.dTree.DTreeItemFactory;
import oracle.bali.ewt.model.OneDModel;
import oracle.help.common.Topic;
import oracle.help.common.TopicTreeNode;
import oracle.help.java.tree.TopicTreeComponent;
import oracle.help.java.tree.TopicTreeEvent;
import oracle.help.java.tree.TopicTreeItem;
import oracle.help.java.util.ImageLoader;
import oracle.help.navigator.tocNavigator.TOCItemFactory;

public class TOCBranchItem
extends DTreeDeferredParent
implements TopicTreeItem {
    private ImageIcon _collapsedIcon = null;
    private ImageIcon _expandedIcon = null;
    private static ImageIcon _defaultExpandedIcon = null;
    private static ImageIcon _defaultCollapsedIcon = null;

    public TOCBranchItem(OneDModel source) {
        super(source);
    }

    @Override
    public Topic getTopic() {
        TopicTreeNode node = this.getTopicTreeNode();
        return node.getTopic();
    }

    @Override
    public TopicTreeNode getTopicTreeNode() {
        DTreeDeferringParent parent = this.getDeferringParent();
        TopicTreeNode node = (TopicTreeNode)parent.getChildData(this.getIndex());
        return node;
    }

    public DTreeItemFactory getItemFactory() {
        return TOCItemFactory.getInstance();
    }

    public String getLabel() {
        String label = null;
        Topic theTopic = this.getTopic();
        if (theTopic != null) {
            label = theTopic.getLabel();
        }
        return label;
    }

    public Icon getIcon() {
        ImageIcon theIcon = null;
        theIcon = this.isExpanded() ? this.getExpandedIcon() : this.getCollapsedIcon();
        return theIcon;
    }

    protected ImageIcon getExpandedIcon() {
        if (this._expandedIcon == null) {
            this._expandedIcon = this._getCustomIcon();
            if (this._expandedIcon == null) {
                Image defaultExpandedImage;
                if (_defaultExpandedIcon == null && (defaultExpandedImage = ImageLoader.loadImage(this.getClass(), "images/openbook.gif")) != null) {
                    _defaultExpandedIcon = new ImageIcon(defaultExpandedImage);
                }
                this._expandedIcon = _defaultExpandedIcon;
            }
        }
        return this._expandedIcon;
    }

    protected ImageIcon getCollapsedIcon() {
        if (this._collapsedIcon == null) {
            this._collapsedIcon = this._getCustomIcon();
            if (this._collapsedIcon == null) {
                Image defaultCollapsedImage;
                if (_defaultCollapsedIcon == null && (defaultCollapsedImage = ImageLoader.loadImage(this.getClass(), "images/closedbook.gif")) != null) {
                    _defaultCollapsedIcon = new ImageIcon(defaultCollapsedImage);
                }
                this._collapsedIcon = _defaultCollapsedIcon;
            }
        }
        return this._collapsedIcon;
    }

    private ImageIcon _getCustomIcon() {
        Image active;
        ImageIcon resultIcon = null;
        Image resultImage = null;
        if (this.isExpanded() && (active = ImageLoader.loadImage(this.getTopic().getActiveIcon())) != null) {
            resultImage = active;
        }
        if (resultImage == null) {
            resultImage = ImageLoader.loadImage(this.getTopic().getDefaultIcon());
        }
        if (resultImage != null) {
            resultIcon = new ImageIcon(resultImage);
        }
        return resultIcon;
    }

    public void processMouseEvent(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            TopicTreeComponent tree = (TopicTreeComponent)this.getTree();
            Point location = new Point(this.getX() + evt.getX(), this.getY() + evt.getY());
            tree.firePopupRequested(new TopicTreeEvent(this, 2002), location);
        } else {
            super.processMouseEvent(evt);
        }
    }
}

