/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import oracle.jdeveloper.vcs.generic.RemovedEntryLister;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITStatusResolver;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitStatus;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITRemovedEntryLister
extends RemovedEntryLister {
    public URL[] listRemovedEntries(URL directoryUrl) throws Exception {
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(directoryUrl);
            if (client == null) {
                URL[] uRLArray = new URL[]{};
                return uRLArray;
            }
            ArrayList<URL> urls = new ArrayList<URL>();
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("status");
            File[] roots = new File[]{new File(directoryUrl.getPath())};
            Map fileStatus = client.getStatus(roots, (ProgressMonitor)monitor);
            if (monitor.getError() != null) {
                throw new GITProcessException(Resource.get("PENDING_ERROR_FINDING_RM"), monitor.getError());
            }
            for (File file : fileStatus.keySet()) {
                GitStatus status = (GitStatus)fileStatus.get(file);
                if (!GITStatusResolver.isDeleted(status)) continue;
                urls.add(file.toURI().toURL());
            }
            URL[] uRLArray = urls.toArray(new URL[0]);
            return uRLArray;
        }
        catch (GitException ex) {
            GITProfile.getQualifiedLogger(GITRemovedEntryLister.class.getName()).warning(ex.getMessage());
            throw new GITProcessException(Resource.get("PENDING_ERROR_FINDING_RM"), (Exception)((Object)ex));
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }
}

