/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.auth;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import oracle.ide.ExtensionRegistry;
import oracle.ide.config.Preferences;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ideri.util.Product;
import oracle.javatools.annotations.NotNull;
import oracle.javatools.data.PropertyStorage;
import oracle.jdevimpl.vcs.git.GITConnection;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.auth.GitAuthType;
import oracle.jdevimpl.vcs.git.auth.GitAuthorizingType;
import oracle.jdevimpl.vcs.git.auth.ObjectFactory;
import oracle.jdevimpl.vcs.git.prefs.GITVersionToolsPrefs;
import org.netbeans.api.keyring.Keyring;

public class GITAuthHelper {
    private static final Logger sLogger = GITProfile.getQualifiedLogger(GITAuthHelper.class.getName());
    public static final String FILENAME = "gitauthorations.xml";
    private URL _storeURL;
    private JAXBContext _ioContext;
    private Collection<GITConnection> _index;
    private final Lock _lock = new ReentrantLock();
    private boolean _save;
    private boolean _use = true;

    public GITAuthHelper(boolean save) {
        String testing = System.getenv("GITTESTING");
        if (testing != null) {
            this._use = false;
        }
        this._save = save;
        URL url = ExtensionRegistry.getExtensionRegistry().getSystemDirectory("oracle.jdeveloper.git");
        this._storeURL = URLFactory.newURL((URL)url, (String)FILENAME);
        this._index = new ArrayList<GITConnection>();
        try {
            this._ioContext = JAXBContext.newInstance((String)"oracle.jdevimpl.vcs.git.auth", (ClassLoader)ExtensionRegistry.getExtensionRegistry().getClassLoader("oracle.jdeveloper.git"));
        }
        catch (JAXBException je) {
            sLogger.log(Level.WARNING, "unable to obtain binding context for Perforce-connections.xml", je);
        }
    }

    public Collection<GITConnection> getConnections() {
        this.load();
        return this._index;
    }

    public void setPersistedConnections(Collection<GITConnection> list) {
        this._index.clear();
        this._index.addAll(list);
        if (list.isEmpty()) {
            URLFileSystem.delete((URL)this.getStoreURL());
        } else {
            this.save();
            this.useKeyring(list);
        }
    }

    public boolean hasConnection() {
        return URLFileSystem.exists((URL)this.getStoreURL());
    }

    protected URL getStoreURL() {
        return this._storeURL;
    }

    private void save() {
        if (this._ioContext == null) {
            sLogger.log(Level.WARNING, "jaxb context unavailable");
        }
        this._lock.lock();
        try {
            ObjectFactory objectFact = new ObjectFactory();
            this.marshall(this.createIoConnections(objectFact), objectFact);
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "unable to write gitauthorations.xml", e);
        }
        finally {
            this._lock.unlock();
        }
    }

    private void load() {
        if (this._ioContext == null) {
            sLogger.log(Level.WARNING, "jaxb context unavailable");
        }
        this._lock.lock();
        this._index.clear();
        try {
            this.indexIoProfiles(this.unMarshell());
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "unable to load connections", e);
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<GitAuthType> unMarshell() throws JAXBException, IOException {
        if (!URLFileSystem.exists((URL)this.getStoreURL())) {
            return Collections.EMPTY_LIST;
        }
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(URLFileSystem.openInputStream((URL)this.getStoreURL()));
            Unmarshaller ioWorker = this._ioContext.createUnmarshaller();
            JAXBElement jaxBElm = (JAXBElement)ioWorker.unmarshal((InputStream)is);
            GitAuthorizingType connections = (GitAuthorizingType)jaxBElm.getValue();
            List<GitAuthType> list = connections.getGitAuth();
            return list;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void marshall(List<GitAuthType> ioList, ObjectFactory fact) throws JAXBException, FileNotFoundException {
        Marshaller ioWorker = this._ioContext.createMarshaller();
        GitAuthorizingType connections = fact.createGitAuthorizingType();
        connections.getGitAuth().addAll(ioList);
        ioWorker.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        OutputStream os = null;
        try {
            JAXBElement<GitAuthorizingType> jaxBElm = fact.createGitAuth(connections);
            os = new BufferedOutputStream(new FileOutputStream(URLFileSystem.getPlatformPathName((URL)this.getStoreURL()), false));
            ioWorker.marshal(jaxBElm, os);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void indexIoProfiles(List<GitAuthType> git) {
        for (GitAuthType auth : git) {
            GITConnection connect = new GITConnection(auth.getUrl());
            connect.setUsername(auth.getUser());
            connect.setRemote(auth.getRemote());
            connect.setTime(auth.getTime());
            this._index.add(connect);
        }
    }

    private List<GitAuthType> createIoConnections(ObjectFactory objectFact) {
        if (this._index.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<GitAuthType> io = new ArrayList<GitAuthType>(this._index.size());
        for (GITConnection connect : this._index) {
            GitAuthType dt = objectFact.createGitAuthType();
            dt.setUrl(connect.getUrl());
            dt.setUser(connect.getUsername());
            dt.setRemote(connect.getRemote());
            dt.setTime(connect.getTime());
            io.add(dt);
        }
        return io;
    }

    private void useKeyring(Collection<GITConnection> connects) {
        if (Product.isRaptor() || !this._use) {
            return;
        }
        Boolean save = GITVersionToolsPrefs.getInstance((PropertyStorage)Preferences.getPreferences()).getSavePassPhrase();
        for (GITConnection connect : connects) {
            if (save.booleanValue()) {
                if (connect.getPassword() != null && connect.getPassword().length > 0) {
                    Keyring.save((String)connect.getUrl(), (char[])connect.getPassword(), null);
                    connect.setPassword(null);
                }
                if (connect.getPassphrase() == null || connect.getPassphrase().length <= 0) continue;
                Keyring.save((String)this.getPassphraseKey(connect.getUrl()), (char[])connect.getPassphrase(), null);
                connect.setPassphrase(null);
                continue;
            }
            if (!this._save) continue;
            Keyring.delete((String)connect.getUrl());
            Keyring.delete((String)this.getPassphraseKey(connect.getUrl()));
        }
    }

    public void authentication(@NotNull GITConnection connect) {
        if (Product.isRaptor() || !this._use) {
            return;
        }
        if (GITVersionToolsPrefs.getInstance((PropertyStorage)Preferences.getPreferences()).getSavePassPhrase()) {
            connect.setPassword(Keyring.read((String)connect.getUrl()));
            connect.setPassphrase(Keyring.read((String)this.getPassphraseKey(connect.getUrl())));
        }
    }

    private String getPassphraseKey(String key) {
        return "GitJdevPhase" + key;
    }
}

