/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.changelist;

import java.net.URL;
import java.util.logging.Level;
import oracle.ide.config.Preferences;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListCommentsCustomizer;
import oracle.jdeveloper.vcs.generic.PendingChangesAdapter;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.util.VCSNavigableUtils;
import oracle.jdevimpl.vcs.git.cmd.GITOperationCommit;
import oracle.jdevimpl.vcs.git.prefs.GITVersionToolsPrefs;
import oracle.jdevimpl.vcs.git.res.Resource;

public class GITPendingChangesAdapter
extends PendingChangesAdapter {
    private static final String CL_ID_OUTGOING = "oracle.jdeveloper.git.OUTGOING";

    public VCSProfile getProfile() {
        return VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git");
    }

    public HashStructureAdapter getPreferences() {
        return GITVersionToolsPrefs.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    public String[] getPreferencesPath() {
        return VCSNavigableUtils.getSystemNavigablePath((String)VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git").getInformation().getShortLabel(), (String[])new String[]{Resource.get("PREFERENCES_VTOOLS")});
    }

    public boolean isActionSilent(ChangeList changeList, String actionId) {
        int policy = GITVersionToolsPrefs.getInstance((PropertyStorage)Preferences.getPreferences()).getPendingChangesDialogUsage();
        switch (policy) {
            case 0: {
                return false;
            }
            case 1: {
                return changeList.isOptionsVisible();
            }
            case 2: {
                return true;
            }
        }
        throw new IllegalStateException();
    }

    public Object resolvePropertyValue(String changeListId, String propertyId, URL url) {
        if (changeListId.equals(CL_ID_OUTGOING)) {
            try {
                VCSStatus status = (VCSStatus)this.getProfile().getStatusCacheBridge().get(url);
                if (status != null) {
                    return status;
                }
            }
            catch (Exception e) {
                this.getProfile().getLogger().log(Level.WARNING, "Can't get status for " + url.getPath() + " " + e.getMessage());
                return "<<error>>";
            }
        }
        return super.resolvePropertyValue(changeListId, propertyId, url);
    }

    public void initializeCommentsCustomizer(ChangeListCommentsCustomizer commentsCustomizer, Object id) {
        commentsCustomizer.setRecentCommentsModel(GITOperationCommit.getRecentCommentsModel());
        commentsCustomizer.setShowTemplatesAndCommentsCombo(true);
    }
}

