/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.algorithm.list.ListCompareContributor;

public class ContributorCache {
    private static final ContributorCache sIntance = new ContributorCache();
    private final Map<CompareContributor, ListCompareContributor> _cache = new HashMap<CompareContributor, ListCompareContributor>();

    public static ContributorCache getInstance() {
        return sIntance;
    }

    public synchronized void putContributorInfo(CompareContributor key, ListCompareContributor value) {
        if (this._cache == null) {
            return;
        }
        this._cache.put(key, value);
    }

    public synchronized ListCompareContributor getValue(CompareContributor key) {
        if (this._cache != null) {
            return this._cache.get(key);
        }
        return null;
    }

    public synchronized void remove(CompareContributor contrib) {
        if (contrib != null && this._cache != null && !this._cache.isEmpty()) {
            if (this._cache.containsKey(contrib)) {
                this._cache.remove(contrib);
            } else if (this._cache.containsValue(contrib)) {
                Iterator<CompareContributor> it = this._cache.keySet().iterator();
                while (it.hasNext()) {
                    CompareContributor key = it.next();
                    ListCompareContributor value = this._cache.get(key);
                    if (!value.equals(contrib)) continue;
                    it.remove();
                }
            }
        }
    }

    private ContributorCache() {
    }
}

