/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.data;

import java.net.URL;
import java.util.Arrays;
import oracle.ide.net.URLFactory;
import oracle.javatools.data.ChangeBuffer;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.Dirtyable;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.mt.annotation.CodeSharingSafe;

public abstract class Structure
implements Dirtyable {
    @CodeSharingSafe(value="StaticField")
    private static final boolean INTERN_STRINGS = Boolean.parseBoolean(System.getProperty("ide.hashstructure.internStrings", "true"));
    private transient Structure _parent;
    private transient String _structName;
    private transient boolean _dirty;
    private StructureChangeListener[] _listeners;
    private final Object _changeBufferLock = new Object();
    private int _changeBufferDepth = 0;
    private transient ChangeBuffer _changeBuffer;

    Structure() {
    }

    protected static final Object intern(Object object) {
        if (object instanceof String) {
            return Structure.intern((String)object);
        }
        if (object instanceof URL) {
            return Structure.intern((URL)object);
        }
        return object;
    }

    protected static final String intern(String s) {
        if (!INTERN_STRINGS || s == null) {
            return s;
        }
        return s.intern();
    }

    protected static final URL intern(URL url) {
        return URLFactory.intern(url);
    }

    @Override
    public final boolean isDirty() {
        Dirtyable parent = this.getParentDirtyable();
        return parent != null ? parent.isDirty() : this._dirty;
    }

    @Override
    public void markDirty(boolean dirty) {
        Dirtyable parent = this.getParentDirtyable();
        if (parent != null) {
            parent.markDirty(dirty);
        } else {
            this._dirty = dirty;
        }
        if (dirty) {
            this.clearParentPlaceholderFlags();
        }
    }

    public void clear() {
    }

    public String getStructName() {
        Structure parent;
        if (this._structName == null && this.getParent() != null && (parent = this.getParent()) != null) {
            return parent.getNameOfChild(this);
        }
        return this._structName;
    }

    public String getFullName() {
        Structure parent = this.getParent();
        if (parent != null) {
            String parentName = parent.getFullName();
            String structName = this.getStructName();
            if (parentName == null) {
                return structName;
            }
            return parentName + "/" + structName;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStructureChangeListener(StructureChangeListener listener) {
        if (listener != null) {
            Object object = this._changeBufferLock;
            synchronized (object) {
                if (this._listeners == null) {
                    this._listeners = new StructureChangeListener[1];
                    this._listeners[0] = listener;
                } else {
                    int length = this._listeners.length;
                    StructureChangeListener[] newArray = Arrays.copyOf(this._listeners, length + 1);
                    newArray[length] = listener;
                    this._listeners = newArray;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStructureChangeListener(StructureChangeListener listener) {
        if (listener != null) {
            Object object = this._changeBufferLock;
            synchronized (object) {
                if (this._listeners != null) {
                    if (this._listeners.length == 1) {
                        if (listener.equals(this._listeners[0])) {
                            this._listeners = null;
                        }
                    } else {
                        int length = this._listeners.length;
                        int newLength = length - 1;
                        StructureChangeListener[] newArray = new StructureChangeListener[newLength];
                        for (int i = 0; i < newLength; ++i) {
                            if (listener.equals(this._listeners[i])) {
                                for (int j = i + 1; j < length; ++j) {
                                    newArray[j - 1] = this._listeners[j];
                                }
                                this._listeners = newArray;
                                return;
                            }
                            newArray[i] = this._listeners[i];
                        }
                        if (listener.equals(this._listeners[newLength])) {
                            this._listeners = newArray;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyBatchChanges(Runnable runnable) {
        Object object = this._changeBufferLock;
        synchronized (object) {
            if (this._changeBuffer == null) {
                this._changeBuffer = new ChangeBuffer();
            }
            ++this._changeBufferDepth;
        }
        ChangeBuffer changeBuffer = null;
        try {
            runnable.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Object object2 = this._changeBufferLock;
            synchronized (object2) {
                if (--this._changeBufferDepth == 0) {
                    changeBuffer = this._changeBuffer;
                    this._changeBuffer = null;
                }
            }
        }
        if (changeBuffer != null && changeBuffer.getChanges().length > 0) {
            this.fireBatchEvent("", changeBuffer);
        }
    }

    private void clearParentPlaceholderFlags() {
        Structure parent = this.getParent();
        if (parent != null) {
            parent.clearPlaceholderFlag(this.getStructName());
        }
    }

    void clearPlaceholderFlag(String structName) {
    }

    Dirtyable getParentDirtyable() {
        return this.getParent();
    }

    String getNameOfChild(Structure struct) {
        return null;
    }

    abstract void removeChild(Structure var1);

    final Structure getParent() {
        return this._parent;
    }

    private void setStructName(String structName) {
        this._structName = structName;
    }

    boolean mayHaveParent() {
        return true;
    }

    void setParent(Structure parent) {
        this._parent = parent;
    }

    final void checkAndSetParent(Structure struct, String structName) {
        this.checkForCycleWith(struct);
        this.removeFromParent(struct);
        struct.setParent(this);
        struct.setStructName(structName);
    }

    static boolean areDifferent(Object o1, Object o2) {
        return !Structure.areEqual(o1, o2);
    }

    static boolean areEqual(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    void checkForCycleWith(Structure other) {
        for (Structure curParent = this; curParent != null; curParent = curParent.getParent()) {
            if (curParent != other) continue;
            throw new IllegalStateException("Cyclical references are not allowed.");
        }
    }

    private void removeFromParent(Structure child) {
        Structure oldParent = child.getParent();
        if (oldParent != null) {
            oldParent.removeChild(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fireValueModified(String name, Structure valueParent, Object oldValue, Object newValue) {
        Structure parent;
        boolean hasListeners;
        Object object = this._changeBufferLock;
        synchronized (object) {
            if (this._changeBuffer != null) {
                this._changeBuffer.addChangeInfo(ChangeInfo.valueModified(name, valueParent, oldValue, newValue));
                return;
            }
            hasListeners = this._listeners != null;
        }
        if (hasListeners) {
            ChangeInfo[] details = new ChangeInfo[]{ChangeInfo.valueModified(name, valueParent, oldValue, newValue)};
            this.fireStructureChangeEvent(details);
        }
        if ((parent = this.getParent()) != null) {
            String nameInParent = this.getNameInParent(name);
            parent.fireValueModified(nameInParent, valueParent, oldValue, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void fireValueAdded(String name, Structure valueParent, Object newValue) {
        Structure parent;
        boolean hasListeners;
        Object object = this._changeBufferLock;
        synchronized (object) {
            if (this._changeBuffer != null) {
                this._changeBuffer.addChangeInfo(ChangeInfo.valueAdded(name, valueParent, newValue));
                return;
            }
            hasListeners = this._listeners != null;
        }
        if (hasListeners) {
            ChangeInfo[] details = new ChangeInfo[]{ChangeInfo.valueAdded(name, valueParent, newValue)};
            this.fireStructureChangeEvent(details);
        }
        if (this.hasParentListeners() && (parent = this.getParent()) != null) {
            String nameInParent = this.getNameInParent(name);
            parent.fireValueAdded(nameInParent, valueParent, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean hasParentListeners() {
        for (Structure parent = this.getParent(); parent != null; parent = parent.getParent()) {
            Object object = this._parent._changeBufferLock;
            synchronized (object) {
                if (parent._listeners != null) {
                    return true;
                }
                continue;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void firePlaceholderValueAdded(String name, Structure valueParent, Object newValue) {
        Structure parent;
        boolean hasListeners;
        Object object = this._changeBufferLock;
        synchronized (object) {
            if (this._changeBuffer != null) {
                this._changeBuffer.addChangeInfo(ChangeInfo.placeholderValueAdded(name, valueParent, newValue));
                return;
            }
            hasListeners = this._listeners != null;
        }
        if (hasListeners) {
            ChangeInfo[] details = new ChangeInfo[]{ChangeInfo.placeholderValueAdded(name, valueParent, newValue)};
            this.fireStructureChangeEvent(details);
        }
        if ((parent = this.getParent()) != null) {
            String nameInParent = this.getNameInParent(name);
            parent.firePlaceholderValueAdded(nameInParent, valueParent, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void fireValueRemoved(String name, Structure valueParent, Object oldValue) {
        Structure parent;
        boolean hasListeners;
        Object object = this._changeBufferLock;
        synchronized (object) {
            if (this._changeBuffer != null) {
                this._changeBuffer.addChangeInfo(ChangeInfo.valueRemoved(name, valueParent, oldValue));
                return;
            }
            hasListeners = this._listeners != null;
        }
        if (hasListeners) {
            ChangeInfo[] details = new ChangeInfo[]{ChangeInfo.valueRemoved(name, valueParent, oldValue)};
            this.fireStructureChangeEvent(details);
        }
        if ((parent = this.getParent()) != null) {
            String nameInParent = this.getNameInParent(name);
            parent.fireValueRemoved(nameInParent, valueParent, oldValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBatchEvent(String namePrefix, ChangeBuffer buffer) {
        Structure parent;
        boolean hasListeners;
        Object object = this._changeBufferLock;
        synchronized (object) {
            if (this._changeBuffer != null) {
                this._changeBuffer.addChangeInfos(buffer.getChangesWithPrefixApplied(namePrefix));
                return;
            }
            hasListeners = this._listeners != null;
        }
        if (hasListeners) {
            ChangeInfo[] details = buffer.getChangesWithPrefixApplied(namePrefix);
            this.fireStructureChangeEvent(details);
        }
        if ((parent = this.getParent()) != null) {
            String prefixInParent = this.getNameInParent(namePrefix);
            parent.fireBatchEvent(prefixInParent, buffer);
        }
    }

    private String getNameInParent(String name) {
        return this.getStructName() + "/" + name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStructureChangeEvent(ChangeInfo[] details) {
        StructureChangeEvent event = new StructureChangeEvent((Object)this, details);
        StructureChangeListener[] structureChangeListenerArray = this._changeBufferLock;
        synchronized (this._changeBufferLock) {
            StructureChangeListener[] listeners = this._listeners;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (listeners != null) {
                for (StructureChangeListener listener : listeners) {
                    listener.structureValuesChanged(event);
                }
            }
            return;
        }
    }
}

